/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.gui.widgets;

import io.homo.superresolution.core.utils.ColorUtil;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.gui.AbstractConfigScreen;
import me.shedaniel.clothconfig2.gui.ClothConfigScreen;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.math.Color;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ClothListWidget
extends ClothConfigScreen.ListWidget<AbstractConfigEntry<AbstractConfigEntry<?>>> {
    public ClothListWidget(AbstractConfigScreen screen, Minecraft client, int width, int height, int top, int bottom, ResourceLocation backgroundLocation) {
        super(screen, client, width, height, top, bottom, backgroundLocation);
    }

    protected int getScrollbarPosition() {
        return this.width - 6;
    }

    public double getScroll() {
        return this.scroll;
    }

    protected void renderScrollBar(GuiGraphics graphics, int maxScroll, int scrollbarPositionMinX, int scrollbarPositionMaxX) {
        if (maxScroll > 0) {
            int height = (this.bottom - this.top) * (this.bottom - this.top) / this.getMaxScrollPosition();
            height = Mth.clamp((int)height, (int)32, (int)(this.bottom - this.top - 8));
            height = (int)((double)height - Math.min(this.scroll < 0.0 ? (double)((int)(-this.scroll)) : (double)(this.scroll > (double)this.getMaxScroll() ? (int)this.scroll - this.getMaxScroll() : 0), (double)height * 0.95));
            height = Math.max(10, height);
            int minY = Math.min(Math.max((int)this.getScroll() * (this.bottom - this.top - height) / maxScroll + this.top, this.top), this.bottom - height);
            int bottomc = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.ofMouse()) ? 168 : 128;
            graphics.fill(scrollbarPositionMinX, this.top, scrollbarPositionMaxX, this.bottom, ColorUtil.color(120, 0, 0, 0));
            graphics.fill(scrollbarPositionMinX, minY, scrollbarPositionMaxX, minY + height, Color.ofRGB((int)bottomc, (int)bottomc, (int)bottomc).getColor());
        }
    }

    public void scrollTo(double value, boolean animated, long duration) {
        if (animated) {
            this.scrollAnimator.setTo(value, 200L);
        } else {
            this.scrollAnimator.setAs(value);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double x, double y) {
        for (DynamicEntryListWidget.Entry entry : this.visibleChildren()) {
            if (!entry.mouseScrolled(mouseX, mouseY, x, y)) continue;
            return true;
        }
        this.offset(32.0 * -y, true);
        return true;
    }

    protected void renderBackBackground(GuiGraphics graphics) {
    }

    protected void renderHoleBackground(GuiGraphics graphics, int y1, int y2, int alpha1, int alpha2) {
    }
}

