/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.graphics.impl.framebuffer.IBindableFrameBuffer;
import io.homo.superresolution.core.graphics.opengl.utils.GlBlitRenderer;

class FrameBufferRenderTargetAdapter
extends RenderTarget {
    private IBindableFrameBuffer frameBuffer;

    FrameBufferRenderTargetAdapter(IBindableFrameBuffer frameBuffer) {
        super(frameBuffer.getDepthTextureFormat() != null);
        this.frameBuffer = frameBuffer;
        this.updateState();
    }

    protected static FrameBufferRenderTargetAdapter ofRenderTarget(IBindableFrameBuffer frameBuffer) {
        return new FrameBufferRenderTargetAdapter(frameBuffer);
    }

    public FrameBufferRenderTargetAdapter bindFrameBuffer(IBindableFrameBuffer frameBuffer) {
        this.frameBuffer = frameBuffer;
        return this;
    }

    private void updateState() {
        this.width = this.frameBuffer.getWidth();
        this.height = this.frameBuffer.getHeight();
        this.viewWidth = this.frameBuffer.getWidth();
        this.viewHeight = this.frameBuffer.getHeight();
        this.frameBufferId = Math.toIntExact(this.frameBuffer.handle());
        this.colorTextureId = this.frameBuffer.getTextureId(FrameBufferAttachmentType.Color);
        this.depthBufferId = this.frameBuffer.getTextureId(FrameBufferAttachmentType.DepthStencil) == -1 ? this.frameBuffer.getTextureId(FrameBufferAttachmentType.Depth) : this.frameBuffer.getTextureId(FrameBufferAttachmentType.DepthStencil);
    }

    public void bindRead() {
        this.updateState();
        this.frameBuffer.bind(FrameBufferBindPoint.Read);
    }

    public void unbindRead() {
        this.updateState();
        this.frameBuffer.unbind(FrameBufferBindPoint.Read);
    }

    public void bindWrite(boolean setViewport) {
        this.updateState();
        this.frameBuffer.bind(FrameBufferBindPoint.Write, setViewport);
    }

    public void unbindWrite() {
        this.updateState();
        this.frameBuffer.unbind(FrameBufferBindPoint.Write);
    }

    public void setClearColor(float red, float green, float blue, float alpha) {
        this.updateState();
        this.frameBuffer.setClearColorRGBA(red, green, blue, alpha);
    }

    public void blitToScreen(int width, int height) {
        this.updateState();
        GlBlitRenderer.blitToScreen(this.frameBuffer.getTexture(FrameBufferAttachmentType.Color), this.viewWidth, this.viewHeight);
    }

    public void blitAndBlendToScreen(int width, int height) {
        this.updateState();
        this.blitToScreen(width, height);
    }

    public void clear() {
        this.updateState();
        this.frameBuffer.clearFrameBuffer();
    }

    public void resize(int width, int height) {
    }

    public void createBuffers(int width, int height) {
        this.updateState();
    }

    public int getColorTextureId() {
        this.updateState();
        return this.frameBuffer.getTextureId(FrameBufferAttachmentType.Color);
    }

    public int getDepthTextureId() {
        this.updateState();
        return this.frameBuffer.getTextureId(FrameBufferAttachmentType.DepthStencil) == -1 ? this.frameBuffer.getTextureId(FrameBufferAttachmentType.Depth) : this.frameBuffer.getTextureId(FrameBufferAttachmentType.DepthStencil);
    }

    public void destroyBuffers() {
        this.updateState();
    }

    public void copyDepthFrom(RenderTarget otherTarget) {
        this.updateState();
        GlStateManager._glBindFramebuffer((int)36008, (int)otherTarget.frameBufferId);
        GlStateManager._glBindFramebuffer((int)36009, (int)this.frameBufferId);
        GlStateManager._glBlitFrameBuffer((int)0, (int)0, (int)otherTarget.width, (int)otherTarget.height, (int)0, (int)0, (int)this.width, (int)this.height, (int)256, (int)9728);
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
    }
}

