/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.upscale.nis.struct;

import io.homo.superresolution.common.upscale.nis.enums.NISGPUArchitecture;

public class NISOptimizer {
    private boolean isUpscaling;
    private NISGPUArchitecture gpuArch;

    public int getOptimalBlockWidth() {
        switch (this.gpuArch) {
            case NVIDIA_Generic: 
            case NVIDIA_Generic_fp16: 
            case AMD_Generic: 
            case Intel_Generic: {
                return 32;
            }
        }
        return 32;
    }

    public int getOptimalBlockHeight() {
        switch (this.gpuArch) {
            case NVIDIA_Generic: {
                return this.isUpscaling ? 24 : 32;
            }
            case NVIDIA_Generic_fp16: {
                return 32;
            }
            case AMD_Generic: {
                return this.isUpscaling ? 24 : 32;
            }
            case Intel_Generic: {
                return this.isUpscaling ? 24 : 32;
            }
        }
        return this.isUpscaling ? 24 : 32;
    }

    public int getOptimalThreadGroupSize() {
        switch (this.gpuArch) {
            case NVIDIA_Generic: 
            case NVIDIA_Generic_fp16: {
                return 128;
            }
            case AMD_Generic: 
            case Intel_Generic: {
                return 256;
            }
        }
        return 256;
    }
}

