/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.glslang;

import io.homo.superresolution.core.NativeLibManager;
import io.homo.superresolution.core.SuperResolutionNative;
import io.homo.superresolution.core.graphics.glslang.GlslangCompileShaderResult;
import io.homo.superresolution.core.graphics.glslang.enums.EProfile;
import io.homo.superresolution.core.graphics.glslang.enums.EShClient;
import io.homo.superresolution.core.graphics.glslang.enums.EShLanguage;
import io.homo.superresolution.core.graphics.glslang.enums.EShSource;
import io.homo.superresolution.core.graphics.glslang.enums.EShTargetClientVersion;
import io.homo.superresolution.core.graphics.glslang.enums.EShTargetLanguage;
import io.homo.superresolution.core.graphics.glslang.enums.EShTargetLanguageVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class GlslangShaderCompiler {
    public static void init() {
        SuperResolutionNative.initGlslang();
    }

    public static GlslangCompileShaderResult compileShaderToSpirv(String shaderSrc, EShLanguage stage, EShSource language, EShClient client, EShTargetClientVersion clientVersion, EShTargetLanguage targetLanguage, EShTargetLanguageVersion targetLanguageVersion, int defaultVersion, EProfile defaultProfile, boolean forceDefaultVersionAndProfile, boolean forwardCompatible) {
        return SuperResolutionNative.compileShaderToSpirv(shaderSrc, stage.getValue(), language.getValue(), client.getValue(), clientVersion.getValue(), targetLanguage.getValue(), targetLanguageVersion.getValue(), defaultVersion, defaultProfile.getValue(), forceDefaultVersionAndProfile, forwardCompatible);
    }

    public static String addCustomDefines(String source, Map<String, String> defines) {
        if (defines.isEmpty()) {
            return source;
        }
        StringBuilder definesBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : defines.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            definesBuilder.append("#define ").append(key);
            if (value != null && !value.isEmpty()) {
                definesBuilder.append(" ").append(value);
            }
            definesBuilder.append("\n");
        }
        String defineBlock = definesBuilder.toString().trim();
        String[] lines = source.split("\\R");
        ArrayList<String> linesList = new ArrayList<String>(Arrays.asList(lines));
        int versionLine = -1;
        for (int i = 0; i < linesList.size(); ++i) {
            if (!((String)linesList.get(i)).trim().startsWith("#version")) continue;
            versionLine = i;
            break;
        }
        if (versionLine == -1) {
            throw new IllegalArgumentException("Shader source must contain #version directive");
        }
        if (!defineBlock.isEmpty()) {
            String[] defineLines = defineBlock.split("\\R");
            for (int i = 0; i < defineLines.length; ++i) {
                linesList.add(versionLine + 1 + i, defineLines[i]);
            }
        }
        String lineSeparator = source.contains("\r\n") ? "\r\n" : "\n";
        return String.join((CharSequence)lineSeparator, linesList);
    }

    public static void main(String[] args) {
        NativeLibManager.extract("I:\\super_resolution_moddev\\superresolution\\run");
        NativeLibManager.load("I:\\super_resolution_moddev\\superresolution\\run");
        GlslangShaderCompiler.init();
        HashMap<String, String> defines = new HashMap<String, String>();
        defines.put("A", "114");
        String shaderSrc = GlslangShaderCompiler.addCustomDefines("    //#version 430\n    #version 430\n #extension GL_GOOGLE_include_directive : enable\n#include \"a.h\"\nprecision mediump float;\n\nlayout (location = 0) in vec2 aPosition;\nlayout (location = 1) in vec2 aTexCoord;\nlayout (location = 0) out vec2 vTexCoord;\nvoid main() {\n    vTexCoord = aTexCoord;\n    gl_Position = vec4(aPosition, A, 1.0);\n}\n", defines);
    }
}

