/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl.buffer;

import io.homo.superresolution.core.graphics.impl.buffer.BufferUsage;
import java.util.Objects;

public class BufferDescription {
    private final long size;
    private final BufferUsage usage;

    protected BufferDescription(long size, BufferUsage usage) {
        this.size = size;
        this.usage = usage;
    }

    public static Builder create() {
        return new Builder();
    }

    public long size() {
        return this.size;
    }

    public BufferUsage usage() {
        return this.usage;
    }

    public String toString() {
        return "BufferDescription{size=" + this.size + ", usage=" + String.valueOf((Object)this.usage) + "}";
    }

    public static class Builder {
        private long size;
        private BufferUsage usage;

        public Builder size(long size) {
            if (size <= 0L) {
                throw new IllegalArgumentException("Size must be positive");
            }
            this.size = size;
            return this;
        }

        public Builder usage(BufferUsage usage) {
            this.usage = Objects.requireNonNull(usage, "Usage cannot be null");
            return this;
        }

        public BufferDescription build() {
            if (this.size <= 0L) {
                throw new IllegalStateException("Size must be set to a positive value");
            }
            if (this.usage == null) {
                throw new IllegalStateException("Usage must be set");
            }
            return new BufferDescription(this.size, this.usage);
        }
    }
}

