/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.shader;

import io.homo.superresolution.api.platform.Platform;
import io.homo.superresolution.common.config.SuperResolutionConfig;
import io.homo.superresolution.core.SuperResolutionConstants;
import io.homo.superresolution.core.SuperResolutionNative;
import io.homo.superresolution.core.graphics.glslang.GlslangCompileShaderResult;
import io.homo.superresolution.core.graphics.glslang.GlslangShaderCompiler;
import io.homo.superresolution.core.graphics.glslang.enums.EProfile;
import io.homo.superresolution.core.graphics.glslang.enums.EShClient;
import io.homo.superresolution.core.graphics.glslang.enums.EShLanguage;
import io.homo.superresolution.core.graphics.glslang.enums.EShSource;
import io.homo.superresolution.core.graphics.glslang.enums.EShTargetClientVersion;
import io.homo.superresolution.core.graphics.glslang.enums.EShTargetLanguage;
import io.homo.superresolution.core.graphics.glslang.enums.EShTargetLanguageVersion;
import io.homo.superresolution.core.graphics.glslang.enums.GlslangCompileShaderError;
import io.homo.superresolution.core.graphics.impl.shader.IShaderProgram;
import io.homo.superresolution.core.graphics.impl.shader.ShaderCompileException;
import io.homo.superresolution.core.graphics.impl.shader.ShaderSource;
import io.homo.superresolution.core.graphics.impl.shader.ShaderType;
import io.homo.superresolution.core.graphics.opengl.Gl;
import io.homo.superresolution.core.utils.Md5CaculateUtil;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaderCompiler {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"SuperResolution-ShaderCompiler");

    public static boolean saveVulkanProgramBinary(IShaderProgram<?> program) {
        return ShaderCompiler.saveProgramBinaryWithApi(program, "vk");
    }

    public static boolean checkVulkanProgramBinary(IShaderProgram<?> program) {
        return ShaderCompiler.checkProgramBinaryWithApi(program, "vk");
    }

    public static ShaderBinary getVulkanShaderBinary(IShaderProgram<?> program, ShaderType type) {
        return ShaderCompiler.getShaderBinaryWithApi(program, type, "vk");
    }

    public static boolean saveOpenGLProgramBinary(IShaderProgram<?> program) {
        return ShaderCompiler.saveProgramBinaryWithApi(program, "ogl");
    }

    public static boolean checkOpenGLProgramBinary(IShaderProgram<?> program) {
        return ShaderCompiler.checkProgramBinaryWithApi(program, "ogl");
    }

    public static ShaderBinary getOpenGLShaderBinary(IShaderProgram<?> program, ShaderType type) {
        return ShaderCompiler.getShaderBinaryWithApi(program, type, "ogl");
    }

    private static boolean saveProgramBinaryWithApi(IShaderProgram<?> program, String apiTag) {
        ShaderCompiler.createCacheDir();
        String hash = ShaderCompiler.getShaderProgramMd5(program, apiTag);
        GlslangCompileShaderResult currentSourceResult = null;
        try {
            for (Map.Entry<ShaderType, ShaderSource> entry : program.getDescription().sourceMap().entrySet()) {
                ShaderType type = entry.getKey();
                ShaderSource source = entry.getValue();
                Path path = SuperResolutionConstants.SHADER_CACHE_FILE.resolve(program.getDescription().shaderName() + "." + hash + "." + type.name().toLowerCase() + "." + apiTag + ".spv");
                EShClient client = ShaderCompiler.isVulkan(apiTag) ? EShClient.EShClientVulkan : EShClient.EShClientOpenGL;
                EShTargetClientVersion clientVersion = ShaderCompiler.isVulkan(apiTag) ? EShTargetClientVersion.EShTargetVulkan_1_2 : EShTargetClientVersion.EShTargetOpenGL_450;
                currentSourceResult = ShaderCompiler.compileShaderToSpirv(source.getSource(), ShaderCompiler.mapToGlslangType(type), client, clientVersion);
                LOGGER.debug("\u5f00\u59cbSPIR-V\u7f16\u8bd1: \u7c7b\u578b={}, API={}, \u7f13\u5b58\u8def\u5f84={}", new Object[]{type.name(), apiTag, path});
                if (currentSourceResult.error() != GlslangCompileShaderError.OK) {
                    LOGGER.error("\u7740\u8272\u5668\u7f16\u8bd1\u5931\u8d25[{}]\uff0c\u9519\u8bef\u7c7b\u578b={}\uff0c\u65e5\u5fd7={}", new Object[]{type.name(), currentSourceResult.error().name(), currentSourceResult.log()});
                    throw new ShaderCompileException(currentSourceResult.log());
                }
                ByteBuffer buffer = currentSourceResult.spirvBuffer();
                long size = currentSourceResult.spirVDataSize();
                if (buffer == null || size <= 0L) {
                    LOGGER.error("SPIR-V\u7f13\u51b2\u533a\u4e3a\u7a7a\u6216\u5927\u5c0f\u975e\u6cd5\uff0ctype={}, size={}", (Object)type.name(), (Object)size);
                    throw new IOException("SPIR-V\u7f13\u51b2\u533a\u4e3a\u7a7a\u6216\u5927\u5c0f\u975e\u6cd5");
                }
                LOGGER.debug("\u4fdd\u5b58SPIR-V\uff0c\u5927\u5c0f={} bytes, \u8def\u5f84={}", (Object)size, (Object)path);
                if (SuperResolutionConfig.isDebugDumpShader()) {
                    try {
                        Path srcPath = Path.of(SuperResolutionConstants.SHADER_CACHE_FILE.toAbsolutePath().toString(), program.getDescription().shaderName() + "." + type.name().toLowerCase() + "." + apiTag + ".source.glsl");
                        Path prePath = Path.of(SuperResolutionConstants.SHADER_CACHE_FILE.toAbsolutePath().toString(), program.getDescription().shaderName() + "." + type.name().toLowerCase() + "." + apiTag + ".preprocessed.glsl");
                        LOGGER.debug("\u5199\u51faGLSL\u6e90\u7801\u8c03\u8bd5\u6587\u4ef6: {}\uff0c{}", (Object)srcPath, (Object)prePath);
                        Files.writeString(srcPath, (CharSequence)currentSourceResult.sourceCode(), new OpenOption[0]);
                        Files.writeString(prePath, (CharSequence)currentSourceResult.preprocessedCode(), new OpenOption[0]);
                    }
                    catch (IOException e0) {
                        LOGGER.error("\u65e0\u6cd5\u4fdd\u5b58\u7740\u8272\u5668\u6e90\u7801\u6587\u4ef6: {}", (Object)e0.getMessage());
                    }
                }
                try {
                    byte[] outBytes = new byte[(int)size];
                    buffer.position(0);
                    buffer.get(outBytes);
                    Files.write(path, outBytes, new OpenOption[0]);
                    LOGGER.debug("SPIR-V\u4fdd\u5b58\u6210\u529f: {}", (Object)path);
                }
                catch (IOException e) {
                    LOGGER.error("\u4fdd\u5b58SPIR-V\u5931\u8d25", (Throwable)e);
                }
                SuperResolutionNative.freeDirectBuffer(buffer);
                LOGGER.debug("\u91ca\u653eDirectBuffer\u5b8c\u6210");
            }
            return true;
        }
        catch (ShaderCompileException | IOException e) {
            try {
                if (currentSourceResult != null) {
                    LOGGER.debug("\u7740\u8272\u5668\u7f16\u8bd1\u5f02\u5e38\u7c7b\u578b: {}", (Object)currentSourceResult.error().name());
                    LOGGER.debug("\u7f16\u8bd1\u65e5\u5fd7: {}", (Object)currentSourceResult.log());
                    Path errorSourcePath = Path.of(SuperResolutionConstants.SHADER_CACHE_FILE.toString(), program.getDescription().shaderName() + ".error." + apiTag + ".source.glsl");
                    Path errorPrePath = Path.of(SuperResolutionConstants.SHADER_CACHE_FILE.toString(), program.getDescription().shaderName() + ".error." + apiTag + ".preprocessed.glsl");
                    Path errorLogPath = Path.of(SuperResolutionConstants.SHADER_CACHE_FILE.toString(), program.getDescription().shaderName() + ".error." + apiTag + ".log");
                    Files.writeString(errorSourcePath, (CharSequence)currentSourceResult.sourceCode(), new OpenOption[0]);
                    Files.writeString(errorPrePath, (CharSequence)currentSourceResult.preprocessedCode(), new OpenOption[0]);
                    Files.writeString(errorLogPath, (CharSequence)currentSourceResult.log(), new OpenOption[0]);
                    LOGGER.info("\u4fdd\u5b58\u9519\u8bef\u7740\u8272\u5668\u6e90\u7801\u81f3: {}, {}, {}", new Object[]{errorSourcePath, errorPrePath, errorLogPath});
                }
            }
            catch (IOException e0) {
                LOGGER.error("\u65e0\u6cd5\u4fdd\u5b58\u7740\u8272\u5668\u6e90\u7801\u6587\u4ef6: {}", (Object)e0.getMessage());
            }
            LOGGER.error("\u4fdd\u5b58SPIR-V\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public static void createCacheDir() {
        File cacheDir = SuperResolutionConstants.SHADER_CACHE_FILE.toFile();
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            LOGGER.error("\u65e0\u6cd5\u521b\u5efa\u7740\u8272\u5668\u7f13\u5b58\u76ee\u5f55: {}", (Object)SuperResolutionConstants.SHADER_CACHE_FILE);
        }
    }

    private static String getShaderProgramMd5(IShaderProgram<?> shaderProgram, String apiTag) {
        if (ShaderCompiler.isVulkan(apiTag)) {
            return ShaderCompiler.getVulkanShaderProgramMd5(shaderProgram);
        }
        return ShaderCompiler.getOpenGLShaderProgramMd5(shaderProgram);
    }

    private static boolean isVulkan(String apiTag) {
        return apiTag.equals("vk");
    }

    private static GlslangCompileShaderResult compileShaderToSpirv(String src, EShLanguage stage, EShClient client, EShTargetClientVersion clientVersion) {
        ShaderCompiler.createCacheDir();
        LOGGER.debug("\u8c03\u7528GlslangShaderCompiler\u7f16\u8bd1SPIR-V");
        GlslangCompileShaderResult result = GlslangShaderCompiler.compileShaderToSpirv(src, stage, EShSource.EShSourceGlsl, client, clientVersion, EShTargetLanguage.EShTargetSpv, EShTargetLanguageVersion.EShTargetSpv_1_4, Gl.isLegacy() ? 410 : 460, EProfile.ENoProfile, true, false);
        LOGGER.debug("\u7f16\u8bd1SPIR-V\u7ed3\u675f\uff0c\u9519\u8bef\u7801={}, \u6570\u636e\u5927\u5c0f={}", (Object)result.error(), (Object)result.spirVDataSize());
        return result;
    }

    private static EShLanguage mapToGlslangType(ShaderType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ShaderType.Vertex -> EShLanguage.EShLangVertex;
            case ShaderType.Fragment -> EShLanguage.EShLangFragment;
            case ShaderType.Compute -> EShLanguage.EShLangCompute;
        };
    }

    private static String getVulkanShaderProgramMd5(IShaderProgram<?> shaderProgram) {
        StringBuilder identityBuilder = new StringBuilder();
        ArrayList sortedDefines = new ArrayList(new ArrayList<Map.Entry<String, String>>(shaderProgram.getDescription().definesMap().entrySet()).stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).toList());
        for (ShaderType type : ShaderType.values()) {
            ShaderSource sources = shaderProgram.getDescription().sourceMap().get((Object)type);
            if (sources == null) continue;
            identityBuilder.append(type.name()).append(":");
            identityBuilder.append(sources.getSource());
            sortedDefines.addAll(sources.getShaderDefines().values());
        }
        sortedDefines = (ArrayList)sortedDefines.stream().sorted().collect(Collectors.toList());
        identityBuilder.append(shaderProgram.getDescription().shaderName()).append(String.join((CharSequence)"|", sortedDefines));
        return Md5CaculateUtil.getMD5(identityBuilder.toString());
    }

    private static String getOpenGLShaderProgramMd5(IShaderProgram<?> shaderProgram) {
        StringBuilder identityBuilder = new StringBuilder();
        for (ShaderType type : ShaderType.values()) {
            ShaderSource sources = shaderProgram.getDescription().sourceMap().get((Object)type);
            if (sources == null) continue;
            identityBuilder.append(type.name()).append(":");
            identityBuilder.append(sources.getSource());
        }
        List sortedDefines = shaderProgram.getDescription().definesMap().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).sorted().collect(Collectors.toList());
        identityBuilder.append(shaderProgram.getDescription().shaderName()).append(String.join((CharSequence)"|", sortedDefines));
        return Md5CaculateUtil.getMD5(identityBuilder.toString());
    }

    private static boolean checkProgramBinaryWithApi(IShaderProgram<?> program, String apiTag) {
        ShaderCompiler.createCacheDir();
        if (Platform.currentPlatform.isDevelopmentEnvironment()) {
            return false;
        }
        String hash = ShaderCompiler.getShaderProgramMd5(program, apiTag);
        for (ShaderType type : program.getDescription().sourceMap().keySet()) {
            Path path = SuperResolutionConstants.SHADER_CACHE_FILE.resolve(program.getDescription().shaderName() + "." + hash + "." + type.name().toLowerCase() + "." + apiTag + ".spv");
            if (Files.exists(path, new LinkOption[0])) continue;
            LOGGER.debug("\u672a\u627e\u5230\u7f13\u5b58\u6587\u4ef6: {}", (Object)path);
            return false;
        }
        LOGGER.debug("\u7740\u8272\u5668\u7f13\u5b58\u6587\u4ef6\u5b58\u5728\u3002");
        return true;
    }

    private static ShaderBinary getShaderBinaryWithApi(IShaderProgram<?> program, ShaderType type, String apiTag) {
        ShaderCompiler.createCacheDir();
        String hash = ShaderCompiler.getShaderProgramMd5(program, apiTag);
        String filename = program.getDescription().shaderName() + "." + hash + "." + type.name().toLowerCase() + "." + apiTag + ".spv";
        LOGGER.debug("\u52a0\u8f7d\u7f13\u5b58\u4e8c\u8fdb\u5236: {}", (Object)filename);
        return ShaderCompiler.loadBinaryWithApi(filename, apiTag);
    }

    private static ShaderBinary loadBinaryWithApi(String filename, String apiTag) {
        ShaderCompiler.createCacheDir();
        Path path = SuperResolutionConstants.SHADER_CACHE_FILE.resolve(filename);
        try {
            byte[] data = Files.readAllBytes(path);
            if (data.length == 0 || data.length > 0x200000) {
                LOGGER.error("SPIR-V\u7f13\u5b58\u5927\u5c0f\u5f02\u5e38: {}", (Object)data.length);
                return null;
            }
            ByteBuffer buffer = MemoryUtil.memAlloc((int)data.length);
            buffer.put(data).flip();
            LOGGER.debug("\u6210\u529f\u52a0\u8f7dSPIR-V\u7f13\u5b58\u6587\u4ef6: {}", (Object)filename);
            int format = ShaderCompiler.isVulkan(apiTag) ? -1 : 38225;
            return new ShaderBinary(buffer, data.length, format);
        }
        catch (IOException e) {
            LOGGER.error("\u52a0\u8f7dSPIR-V\u5931\u8d25: {}", (Object)filename, (Object)e);
            return null;
        }
    }

    static {
        ShaderCompiler.createCacheDir();
    }

    public static class ShaderBinary
    implements AutoCloseable {
        private final ByteBuffer binary;
        private final int size;
        private final int format;
        private volatile boolean closed = false;

        public ShaderBinary(ByteBuffer binary, int size, int format) {
            this.binary = binary;
            this.size = size;
            this.format = format;
        }

        public ByteBuffer binary() {
            return this.binary;
        }

        public int size() {
            return this.size;
        }

        public int format() {
            return this.format;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (!this.closed) {
                ShaderBinary shaderBinary = this;
                synchronized (shaderBinary) {
                    if (!this.closed) {
                        LOGGER.debug("\u91ca\u653e\u7740\u8272\u5668\u4ee3\u7801\u5185\u5b58 {} bytes", (Object)this.size);
                        MemoryUtil.memFree((Buffer)this.binary);
                        this.closed = true;
                    }
                }
            }
        }
    }
}

