/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.core;

import io.homo.superresolution.core.gui.core.AbstractContainerWidget;
import io.homo.superresolution.core.gui.core.AbstractWidget;
import io.homo.superresolution.core.gui.core.IScrollHandler;
import io.homo.superresolution.core.gui.core.SmoothDragScrollHandler;
import io.homo.superresolution.core.gui.core.UIInputState;
import io.homo.superresolution.core.gui.core.WidgetStyle;
import io.homo.superresolution.core.gui.core.animator.AnimationSet;
import io.homo.superresolution.core.gui.core.backends.interfaces.IUIDrawContext;
import io.homo.superresolution.core.gui.core.impl.Rectangle;
import io.homo.superresolution.core.gui.core.layout.ILayoutElement;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaNode;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public abstract class AbstractScrollableContainerWidget
extends AbstractContainerWidget<AbstractScrollableContainerWidget, WidgetStyle<?>, AnimationSet> {
    protected Vector2f viewRegion = new Vector2f(0.0f, 0.0f);
    protected Vector2f scrollOffset = new Vector2f(0.0f, 0.0f);
    protected boolean horizontalScrollEnabled = true;
    protected boolean verticalScrollEnabled = true;
    protected float topPadding = 0.0f;
    protected float bottomPadding = 0.0f;
    protected float leftPadding = 0.0f;
    protected float rightPadding = 0.0f;
    protected boolean isContainerDragging = false;
    protected YogaNode wrapperNode = new YogaNode(AbstractWidget.yogaConfig);
    private IScrollHandler scrollHandler = new SmoothDragScrollHandler(this::setScrollOffset);

    public AbstractScrollableContainerWidget() {
        this.wrapperNode.addChildAt(this.getWrapperedLayoutNode(), 0);
        this.wrapperNode.setDebugName("ScrollableContainerWrapperNode");
    }

    @Override
    public YogaNode getLayoutNode() {
        return this.wrapperNode;
    }

    public YogaNode getWrapperedLayoutNode() {
        return super.getLayoutNode();
    }

    @Override
    public void setElementSize(float width, float height) {
        super.setElementSize(width, height);
        this.viewRegion.set(width, height);
        if (width > 0.0f) {
            this.wrapperNode.setWidth(width);
        }
        if (height > 0.0f) {
            this.wrapperNode.setHeight(height);
        }
    }

    @Override
    public void addChild(ILayoutElement element) {
        this.children.add(element);
        element.setParent(this);
        this.getWrapperedLayoutNode().addChildAt(element.getLayoutNode(), Math.max(this.getLayoutNode().getChildCount() - 1, 0));
    }

    @Override
    public void removeChild(ILayoutElement element) {
        this.children.remove(element);
        element.setParent(null);
        this.getWrapperedLayoutNode().removeChild(element.getLayoutNode());
    }

    public IScrollHandler getScrollHandler() {
        return this.scrollHandler;
    }

    public AbstractScrollableContainerWidget setScrollHandler(IScrollHandler scrollHandler) {
        this.scrollHandler = scrollHandler;
        return this;
    }

    @Override
    protected void init() {
        super.init();
        this.onMousePress(event -> this.onMousePressed(event.getMousePosition()));
        this.onMouseDrag(event -> this.onMouseDragged(event.getMousePosition(), event.getDragDelta(), event.getButton()));
        this.onMouseRelease(event -> this.onMouseReleased(event.getMousePosition()));
        this.onMouseScroll(event -> {
            if (this.isDisabled()) {
                return;
            }
            this.scrollHandler.onScroll(0.0f, event.getScrollY());
        });
    }

    public void setTopPadding(float padding) {
        this.topPadding = Math.max(0.0f, padding);
    }

    public void setBottomPadding(float padding) {
        this.bottomPadding = Math.max(0.0f, padding);
    }

    public void setLeftPadding(float padding) {
        this.leftPadding = Math.max(0.0f, padding);
    }

    public void setRightPadding(float padding) {
        this.rightPadding = Math.max(0.0f, padding);
    }

    public Vector2f getScrollOffset() {
        return new Vector2f((Vector2fc)this.scrollOffset);
    }

    public void setScrollOffset(Vector2f offset) {
        this.scrollOffset = offset != null ? new Vector2f((Vector2fc)offset) : new Vector2f(0.0f, 0.0f);
    }

    public void setScrollOffset(float x, float y) {
        this.setScrollOffset(new Vector2f(x, y));
    }

    public void scrollBy(Vector2f delta) {
        this.setScrollOffset(this.scrollOffset.x + delta.x, this.scrollOffset.y + delta.y);
    }

    public void scrollBy(float deltaX, float deltaY) {
        this.setScrollOffset(this.scrollOffset.x + deltaX, this.scrollOffset.y + deltaY);
    }

    public boolean isHorizontalScrollEnabled() {
        return this.horizontalScrollEnabled;
    }

    public void setHorizontalScrollEnabled(boolean enabled) {
        this.horizontalScrollEnabled = enabled;
    }

    public boolean isVerticalScrollEnabled() {
        return this.verticalScrollEnabled;
    }

    public void setVerticalScrollEnabled(boolean enabled) {
        this.verticalScrollEnabled = enabled;
    }

    @Override
    public void mouseScroll(float x, float y, double scrollX) {
        super.mouseScroll(x, y, scrollX);
        if (this.isDisabled()) {
            return;
        }
        float scrollDelta = (float)scrollX;
        if (this.verticalScrollEnabled) {
            this.scrollHandler.scrollBy(new Vector2f(0.0f, -scrollDelta));
        } else if (this.horizontalScrollEnabled) {
            this.scrollHandler.scrollBy(new Vector2f(-scrollDelta, 0.0f));
        }
    }

    @Override
    public void render(IUIDrawContext drawContext, UIInputState inputState) {
        if (!this.isVisible()) {
            return;
        }
        Vector2f contentSize = new Vector2f(this.getWrapperedLayoutNode().getLayoutWidth(), this.getWrapperedLayoutNode().getLayoutHeight());
        Vector2f viewSize = new Vector2f(this.viewRegion.x, this.viewRegion.y);
        Vector2f min = new Vector2f(0.0f, 0.0f);
        Vector2f max = new Vector2f(Math.max(0.0f, contentSize.x - viewSize.x), Math.max(0.0f, contentSize.y - viewSize.y));
        this.scrollHandler.setScrollBounds(min, max);
        this.scrollHandler.update(inputState.frameTime());
        Vector2f position = this.getAbsolutePosition();
        Rectangle region = new Rectangle(position.x, position.y, this.viewRegion.x, this.viewRegion.y);
        drawContext.beginBatch();
        this.renderSelf(drawContext, inputState);
        drawContext.scissor(region.x, region.y, region.width, region.height);
        for (ILayoutElement child : this.children) {
            AbstractWidget widget;
            if (!(child instanceof AbstractWidget) || !region.intersect((widget = (AbstractWidget)child).getBounds())) continue;
            widget.render(drawContext, inputState);
        }
        drawContext.resetScissor();
        this.renderScrollbar(drawContext, inputState);
        drawContext.endBatch(this.getZIndex());
    }

    protected abstract void renderScrollbar(IUIDrawContext var1, UIInputState var2);

    @Override
    public Rectangle getViewRegion() {
        return this.getBounds();
    }

    public AbstractScrollableContainerWidget setViewRegion(Vector2f viewRegion) {
        this.viewRegion = viewRegion;
        return this;
    }

    @Override
    public Rectangle getBounds() {
        Vector2f position = this.getAbsolutePosition();
        return super.getBounds();
    }

    protected void onMousePressed(Vector2f mousePosition) {
        if (this.getBounds().in(mousePosition.x, mousePosition.y)) {
            this.scrollHandler.onDragStart(mousePosition);
        }
    }

    protected void onMouseDragged(Vector2f mousePosition, Vector2f dragDelta, int button) {
        this.scrollHandler.onDragMove(mousePosition, dragDelta);
    }

    protected void onMouseReleased(Vector2f mousePosition) {
        this.scrollHandler.onDragEnd(mousePosition);
    }
}

