/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.core.backends.interfaces;

import io.homo.superresolution.core.gui.core.backends.interfaces.Transform;
import java.util.ArrayDeque;
import java.util.Deque;

public class TransformStack {
    private final Deque<Transform> stack = new ArrayDeque<Transform>();

    public TransformStack() {
        this.stack.addLast(Transform.identity());
    }

    public void push() {
        this.stack.addLast(this.last().copy());
    }

    public void pop() {
        if (this.stack.size() > 1) {
            this.stack.removeLast();
        }
    }

    public Transform last() {
        return this.stack.getLast();
    }

    public void translate(float x, float y) {
        this.last().translate(x, y);
    }

    public void scale(float sx, float sy) {
        this.last().scale(sx, sy);
    }

    public void scale(float s) {
        this.scale(s, s);
    }

    public void rotate(float radians) {
        this.last().rotate(radians);
    }

    public void scaleAt(float sx, float sy, float cx, float cy) {
        this.last().scaleAt(sx, sy, cx, cy);
    }

    public void rotateAt(float radians, float cx, float cy) {
        this.last().rotateAt(radians, cx, cy);
    }

    public void setIdentity() {
        this.last().setIdentity();
    }

    public float[] currentMatrix() {
        return this.last().transformMatrix();
    }

    public boolean isClear() {
        return this.stack.size() == 1;
    }

    public String toString() {
        return "TransformStack{stack=" + String.valueOf(this.stack) + "}";
    }
}

