/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.fsr2.common;

import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineJobResource;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineResourceAccess;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureDescription;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.impl.texture.TextureSupplier;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsages;
import io.homo.superresolution.core.graphics.opengl.buffer.GlBuffer;
import io.homo.superresolution.core.graphics.opengl.texture.GlSampler;
import io.homo.superresolution.core.graphics.opengl.texture.GlTexture2D;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2Context;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2PipelineResourceType;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2PipelineResources;
import java.util.UUID;
import java.util.function.Supplier;

public class Fsr2ShaderResource {
    public PipelineResourceAccess access = PipelineResourceAccess.Read;
    public int binding = -1;
    public Supplier<Fsr2PipelineResources.Fsr2ResourceEntry> resourceEntry = null;
    public Supplier<Fsr2PipelineResourceType> resourceType = null;
    public String resourceName;
    private static ITexture nullTexture;
    public GlSampler sampler = GlSampler.create(GlSampler.SamplerType.NearestClamp);

    public GlSampler sampler() {
        return this.sampler;
    }

    public Fsr2ShaderResource sampler(GlSampler sampler) {
        this.sampler = sampler;
        return this;
    }

    public PipelineResourceAccess access() {
        return this.access;
    }

    public Fsr2ShaderResource access(PipelineResourceAccess access) {
        this.access = access;
        return this;
    }

    public int binding() {
        return this.binding;
    }

    public Fsr2ShaderResource binding(int binding) {
        this.binding = binding;
        return this;
    }

    public Fsr2ShaderResource resourceEntry(Fsr2PipelineResources.Fsr2ResourceEntry resourceEntry) {
        this.resourceEntry = () -> resourceEntry;
        return this;
    }

    public Fsr2ShaderResource resourceType(Fsr2PipelineResourceType resourceType) {
        this.resourceType = () -> resourceType;
        return this;
    }

    public Fsr2ShaderResource resourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    public Fsr2ShaderResource resourceEntrySupplier(Supplier<Fsr2PipelineResources.Fsr2ResourceEntry> resourceEntry) {
        this.resourceEntry = resourceEntry;
        return this;
    }

    public Fsr2ShaderResource resourceTypeSupplier(Supplier<Fsr2PipelineResourceType> resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public PipelineJobResource<?> getResourceDescription(Fsr2Context context) {
        Object name;
        Fsr2PipelineResourceType resourceType;
        if (this.resourceType != null) {
            this.resourceEntry = () -> context.resources.resource(this.resourceType.get());
        }
        if ((resourceType = context.resources.resourceEntriesMap().get(this.resourceEntry.get())) == null) {
            throw new RuntimeException();
        }
        Object object = this.resourceName != null ? this.resourceName : (name = this.access == PipelineResourceAccess.Read ? resourceType.srvShaderName() : resourceType.uavShaderName());
        if (name == null) {
            name = "RESOURCE+" + String.valueOf(UUID.randomUUID()) + "+" + this.binding;
        } else if (this.resourceName == null) {
            name = (String)name + "+" + this.binding;
        }
        if (this.resourceEntry.get().type() == Fsr2PipelineResources.Fsr2ResourceType.UBO) {
            return PipelineJobResource.UniformBuffer.create((GlBuffer)this.resourceEntry.get().getResource());
        }
        TextureSupplier textureSupplier = TextureSupplier.of(() -> {
            if (this.resourceType != null) {
                this.resourceEntry = () -> context.resources.resource(this.resourceType.get());
            }
            Fsr2PipelineResourceType _resourceType = context.resources.resourceEntriesMap().get(this.resourceEntry.get());
            ITexture texture = (ITexture)this.resourceEntry.get().getResource();
            if (texture == null) {
                if (_resourceType == Fsr2PipelineResourceType.SCENE_LUMINANCE_MIPMAP_5 && context.resources.resource(Fsr2PipelineResourceType.SCENE_LUMINANCE).getResource() != null) {
                    GlTexture2D texture2D = (GlTexture2D)context.resources.resource(Fsr2PipelineResourceType.SCENE_LUMINANCE).getResource();
                    return texture2D.getMipView(Math.min(texture2D.getMipmapLevel(), 5));
                }
                if (nullTexture == null) {
                    nullTexture = RenderSystems.current().device().createTexture(TextureDescription.create().width(1).height(1).type(TextureType.Texture2D).format(TextureFormat.RGBA8).usages(TextureUsages.create().storage().sampler()).label("SRFSR2NullTexture").build());
                }
                return nullTexture;
            }
            return texture;
        });
        if (this.access != PipelineResourceAccess.Read) {
            return PipelineJobResource.StorageTexture.create(textureSupplier, this.access);
        }
        return PipelineJobResource.SamplerTexture.create(textureSupplier);
    }
}

