/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.config;

import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.LogLevel;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaCloneNodeFunction;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaErrata;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaExperimentalFeature;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaNode;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.config.YogaConfig;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.config.YogaLogger;
import java.util.EnumSet;
import java.util.Set;

public class MutableYogaConfig
implements YogaConfig {
    private YogaCloneNodeFunction cloneNodeCallback = null;
    private YogaLogger logger;
    private boolean useWebDefaults = false;
    private int version = 0;
    private EnumSet<YogaExperimentalFeature> experimentalFeatures = EnumSet.noneOf(YogaExperimentalFeature.class);
    private EnumSet<YogaErrata> errata = EnumSet.noneOf(YogaErrata.class);
    private float pointScaleFactor = 1.0f;
    private Object context = null;

    MutableYogaConfig(YogaLogger logger) {
        this.logger = logger;
    }

    MutableYogaConfig() {
        this(YogaLogger.getDefaultLogger());
    }

    public void setUseWebDefaults(boolean useWebDefaults) {
        this.useWebDefaults = useWebDefaults;
    }

    @Override
    public boolean useWebDefaults() {
        return this.useWebDefaults;
    }

    public void setExperimentalFeatureEnabled(YogaExperimentalFeature feature, boolean enabled) {
        if (this.isExperimentalFeatureEnabled(feature) != enabled) {
            if (enabled) {
                this.experimentalFeatures.add(feature);
            } else {
                this.experimentalFeatures.remove((Object)feature);
            }
            ++this.version;
        }
    }

    @Override
    public boolean isExperimentalFeatureEnabled(YogaExperimentalFeature feature) {
        return this.experimentalFeatures.contains((Object)feature);
    }

    @Override
    public Set<YogaExperimentalFeature> getEnabledExperiments() {
        return EnumSet.copyOf(this.experimentalFeatures);
    }

    public void setErrata(Set<YogaErrata> errata) {
        if (!this.errata.equals(errata)) {
            this.errata = EnumSet.copyOf(errata);
            ++this.version;
        }
    }

    public void setErrata(YogaErrata errata) {
        EnumSet<YogaErrata> newErrata = EnumSet.of(errata);
        if (!this.errata.equals(newErrata)) {
            this.errata = newErrata;
            ++this.version;
        }
    }

    public void setErrata(YogaErrata errata, boolean enabled) {
        if (enabled && !this.errata.contains((Object)errata)) {
            this.errata.add(errata);
            ++this.version;
        } else if (!enabled && this.errata.contains((Object)errata)) {
            this.errata.remove((Object)errata);
            ++this.version;
        }
    }

    public void addErrata(YogaErrata errata) {
        if (!this.hasErrata(errata)) {
            this.errata.add(errata);
            ++this.version;
        }
    }

    public void removeErrata(YogaErrata errata) {
        if (this.hasErrata(errata)) {
            this.errata.remove((Object)errata);
            ++this.version;
        }
    }

    @Override
    public EnumSet<YogaErrata> getErrata() {
        return EnumSet.copyOf(this.errata);
    }

    @Override
    public boolean hasErrata(YogaErrata errata) {
        return this.errata.contains((Object)errata);
    }

    public void setPointScaleFactor(float pointScaleFactor) {
        if (this.pointScaleFactor != pointScaleFactor) {
            this.pointScaleFactor = pointScaleFactor;
            ++this.version;
        }
    }

    @Override
    public float getPointScaleFactor() {
        return this.pointScaleFactor;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public Object getContext() {
        return this.context;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public void setLogger(YogaLogger logger) {
        this.logger = logger;
    }

    @Override
    public void log(YogaNode node, LogLevel logLevel, String format, Object ... args) {
        if (this.logger != null) {
            this.logger.log(this, node, logLevel, format, args);
        }
    }

    public void setCloneNodeCallback(YogaCloneNodeFunction cloneNode) {
        this.cloneNodeCallback = cloneNode;
    }

    @Override
    public YogaNode cloneNode(YogaNode node, YogaNode owner, int childIndex) {
        YogaNode clone = null;
        if (this.cloneNodeCallback != null) {
            clone = this.cloneNodeCallback.cloneNode(node, owner, childIndex);
        }
        if (clone == null) {
            clone = node.cloneWithChildren();
        }
        return clone;
    }

    static class DefaultConfigHolder {
        static final YogaConfig DEFAULT_CONFIG = YogaConfig.create(YogaLogger.getDefaultLogger());

        DefaultConfigHolder() {
        }
    }
}

