/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.gui.effect;

import io.homo.superresolution.common.minecraft.handler.RenderHandlerManager;
import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.impl.buffer.StructuredUniformBuffer;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureDescription;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsages;
import io.homo.superresolution.core.graphics.opengl.framebuffer.GlFrameBuffer;
import io.homo.superresolution.core.graphics.opengl.shader.GlShaderProgram;
import io.homo.superresolution.core.graphics.opengl.texture.GlTexture2D;

public class BlurRenderer {
    public static final GlShaderProgram BLUR;
    public static final GlFrameBuffer blurFrameBuffer;
    public static final GlTexture2D blurTempTexture;
    public static final int MAX_LEVELS = 8;
    private static final float[] blurWeights;
    protected static StructuredUniformBuffer uniformBlock;

    public static void compileShader() {
        if (!BLUR.isCompiled()) {
            BLUR.compile();
        }
    }

    public static void copyTextureAndGenMipmap() {
        if (RenderHandlerManager.getOriginRenderTarget().getWidth() != blurTempTexture.getWidth() || RenderHandlerManager.getOriginRenderTarget().getHeight() != blurTempTexture.getHeight()) {
            blurTempTexture.resize(RenderHandlerManager.getOriginRenderTarget().getWidth(), RenderHandlerManager.getOriginRenderTarget().getHeight());
        }
        if (RenderHandlerManager.getOriginRenderTarget().getWidth() != blurFrameBuffer.getWidth() || RenderHandlerManager.getOriginRenderTarget().getHeight() != blurFrameBuffer.getHeight()) {
            blurFrameBuffer.resizeFrameBuffer(RenderHandlerManager.getOriginRenderTarget().getWidth(), RenderHandlerManager.getOriginRenderTarget().getHeight());
        }
        GlTexture2D dst = blurTempTexture;
        ITexture src = RenderHandlerManager.getOriginRenderTarget().getTexture(FrameBufferAttachmentType.Color);
        dst.copyFromTex((int)src.handle());
        dst.generateMipmap();
    }

    public static void genBlurWeights(double phi, double m) {
        int i;
        double a = 1.0 / (m * Math.sqrt(Math.PI * 2));
        double sum = 0.0;
        for (i = 0; i < 8; ++i) {
            double b = Math.pow(Math.E, -(Math.pow((double)i - phi, 2.0) / (2.0 * m * m)));
            BlurRenderer.blurWeights[i] = (float)(a * b);
            sum += (double)blurWeights[i];
        }
        i = 0;
        while (i < 8) {
            int n = i++;
            blurWeights[n] = blurWeights[n] / (float)sum;
        }
    }

    public static void renderBlur() {
    }

    static {
        blurWeights = new float[8];
        BLUR = null;
        blurFrameBuffer = GlFrameBuffer.create(TextureFormat.RGBA8, null, RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight());
        blurTempTexture = (GlTexture2D)RenderSystems.current().device().createTexture(TextureDescription.create().type(TextureType.Texture2D).width(RenderHandlerManager.getScreenWidth()).height(RenderHandlerManager.getScreenHeight()).format(TextureFormat.RGBA8).usages(TextureUsages.create().sampler().attachmentColor()).mipmapsAuto().build());
    }
}

