/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.gui.impl;

import io.homo.superresolution.common.gui.impl.ValueHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface OptionRequirement {
    public boolean check();

    @SafeVarargs
    public static <T> OptionRequirement isValue(ValueHolder<T> dependency, @Nullable T firstValue, T ... otherValues) {
        Set values = Stream.concat(Stream.of(firstValue), Arrays.stream(otherValues)).collect(Collectors.toCollection(HashSet::new));
        return () -> values.contains(dependency.value());
    }

    public static <T> OptionRequirement matches(ValueHolder<T> firstDependency, ValueHolder<T> secondDependency) {
        return () -> Objects.equals(firstDependency.value(), secondDependency.value());
    }

    public static OptionRequirement isTrue(ValueHolder<Boolean> dependency) {
        return () -> Boolean.TRUE.equals(dependency.value());
    }

    public static OptionRequirement isFalse(ValueHolder<Boolean> dependency) {
        return () -> Boolean.FALSE.equals(dependency.value());
    }

    public static OptionRequirement not(OptionRequirement requirement) {
        return () -> !requirement.check();
    }

    public static OptionRequirement all(OptionRequirement ... requirements) {
        return () -> Arrays.stream(requirements).allMatch(OptionRequirement::check);
    }

    public static OptionRequirement any(OptionRequirement ... requirements) {
        return () -> Arrays.stream(requirements).anyMatch(OptionRequirement::check);
    }

    public static OptionRequirement none(OptionRequirement ... requirements) {
        return () -> Arrays.stream(requirements).noneMatch(OptionRequirement::check);
    }

    public static OptionRequirement one(OptionRequirement ... requirements) {
        return () -> {
            boolean oneFound = false;
            for (OptionRequirement requirement : requirements) {
                if (!requirement.check()) continue;
                if (oneFound) {
                    return false;
                }
                oneFound = true;
            }
            return oneFound;
        };
    }
}

