/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.gui.screens;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.homo.superresolution.common.config.SuperResolutionConfig;
import io.homo.superresolution.common.gui.ConfigScreenBuilder;
import io.homo.superresolution.common.gui.Rectangle;
import io.homo.superresolution.common.gui.ScissorsHandler;
import io.homo.superresolution.common.gui.widgets.ClothListWidget;
import io.homo.superresolution.core.utils.ColorUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigScreen;
import me.shedaniel.clothconfig2.gui.AbstractConfigScreen;
import me.shedaniel.clothconfig2.gui.ClothConfigScreen;
import me.shedaniel.clothconfig2.gui.entries.EmptyEntry;
import me.shedaniel.clothconfig2.gui.widget.SearchFieldEntry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClothStyleConfigScreen
extends AbstractConfigScreen {
    protected static final PanoramaRenderer panorama = new PanoramaRenderer(TitleScreen.CUBE_MAP);
    protected final LinkedHashMap<Component, List<AbstractConfigEntry<?>>> categorizedEntries = Maps.newLinkedHashMap();
    public ClothListWidget listWidget;
    protected Button cancelButton;
    protected Button exitButton;
    protected Button saveButton;
    protected SearchFieldEntry searchFieldEntry;
    protected boolean enableSearch;
    protected double lastScroll = -1145.1145;

    public ClothStyleConfigScreen(Screen parent, Component title, Map<String, ConfigCategory> categoryMap, ResourceLocation backgroundLocation) {
        super(parent, title, backgroundLocation);
        categoryMap.forEach((categoryName, category) -> {
            ArrayList entries = Lists.newArrayList();
            for (Object object : category.getEntries()) {
                AbstractConfigListEntry entry = object instanceof Tuple ? (AbstractConfigListEntry)((Tuple)object).getB() : (AbstractConfigListEntry)object;
                entry.setScreen((AbstractConfigScreen)this);
                entries.add(entry);
            }
            this.categorizedEntries.put(category.getCategoryKey(), entries);
        });
    }

    public void setEnableSearch(boolean enableSearch) {
        this.enableSearch = enableSearch;
    }

    public Map<Component, List<AbstractConfigEntry<?>>> getCategorizedEntries() {
        return this.categorizedEntries;
    }

    protected void init() {
        super.init();
        this.listWidget = new ClothListWidget(this, this.minecraft, this.width, this.height, 30, this.height - 32, this.getBackgroundLocation());
        this.addWidget((GuiEventListener)this.listWidget);
        if (this.enableSearch) {
            this.listWidget.children().add(new EmptyEntry(5));
            this.searchFieldEntry = new SearchFieldEntry((ConfigScreen)this, (ClothConfigScreen.ListWidget)this.listWidget);
            this.listWidget.children().add(this.searchFieldEntry);
            this.listWidget.children().add(new EmptyEntry(5));
        }
        this.categorizedEntries.forEach((category, entries) -> {
            if (!this.listWidget.children().isEmpty()) {
                this.listWidget.children().add(new EmptyEntry(5));
            }
            this.listWidget.children().add(new EmptyEntry(4));
            this.listWidget.children().add(new CategoryTextEntry((Component)category, (Component)category.copy().withStyle(ChatFormatting.BOLD)));
            this.listWidget.children().add(new EmptyEntry(4));
            this.listWidget.children().addAll(entries);
        });
        int buttonWidths = Math.min(200, (this.width - 50 - 12) / 4);
        this.cancelButton = Button.builder((Component)(this.isEdited() ? Component.translatable((String)"text.cloth-config.cancel_discard") : Component.translatable((String)"gui.cancel")), widget -> this.quit()).bounds(0, this.height - 26, buttonWidths, 20).build();
        this.addWidget((GuiEventListener)this.cancelButton);
        this.exitButton = new Button(0, this.height - 26, buttonWidths, 20, (Component)Component.empty(), button -> this.saveAll(true), Supplier::get){

            public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                boolean hasErrors = false;
                block0: for (List<AbstractConfigEntry<?>> entries : ClothStyleConfigScreen.this.categorizedEntries.values()) {
                    for (AbstractConfigEntry<?> entry : entries) {
                        if (!entry.getConfigError().isPresent()) continue;
                        hasErrors = true;
                        break block0;
                    }
                }
                this.active = ClothStyleConfigScreen.this.isEdited() && !hasErrors;
                this.setMessage((Component)(hasErrors ? Component.translatable((String)"text.cloth-config.error_cannot_save") : Component.translatable((String)"text.cloth-config.save_and_done")));
                super.renderWidget(graphics, mouseX, mouseY, delta);
            }
        };
        this.addWidget((GuiEventListener)this.exitButton);
        this.saveButton = new Button(0, this.height - 26, buttonWidths, 20, (Component)Component.translatable((String)"superresolution.screen.button.label.apply"), button -> {
            this.saveAll(false);
            double scroll = this.listWidget.getScroll();
            Minecraft.getInstance().setScreen(ConfigScreenBuilder.create().buildConfigScreen(this.parent));
            if (Minecraft.getInstance().screen instanceof ClothStyleConfigScreen) {
                ((ClothStyleConfigScreen)Minecraft.getInstance().screen).lastScroll = scroll;
            }
        }, Supplier::get){

            public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                boolean hasErrors = false;
                block0: for (List<AbstractConfigEntry<?>> entries : ClothStyleConfigScreen.this.categorizedEntries.values()) {
                    for (AbstractConfigEntry<?> entry : entries) {
                        if (!entry.getConfigError().isPresent()) continue;
                        hasErrors = true;
                        break block0;
                    }
                }
                this.active = ClothStyleConfigScreen.this.isEdited() && !hasErrors;
                this.setMessage((Component)(hasErrors ? Component.translatable((String)"text.cloth-config.error_cannot_save") : Component.translatable((String)"superresolution.screen.button.label.apply")));
                super.renderWidget(graphics, mouseX, mouseY, delta);
            }
        };
        this.addWidget((GuiEventListener)this.saveButton);
        Optional.ofNullable(this.afterInitConsumer).ifPresent(consumer -> consumer.accept(this));
    }

    public boolean matchesSearch(Iterator<String> tags) {
        if (this.searchFieldEntry == null) {
            return true;
        }
        return this.searchFieldEntry.matchesSearch(tags);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (Minecraft.getInstance().level == null) {
            panorama.render(graphics, this.width, this.height, 1.0f, delta);
        }
        graphics.fill(0, 0, this.width, this.listWidget.top, ColorUtil.color(60, 0, 0, 0));
        graphics.fill(0, this.listWidget.bottom, this.width, this.listWidget.height, ColorUtil.color(60, 0, 0, 0));
        if (this.lastScroll != -1145.1145) {
            this.listWidget.scrollTo(this.lastScroll, false);
            this.lastScroll = -1145.1145;
        }
        this.listWidget.width = this.width;
        this.listWidget.render(graphics, mouseX, mouseY, delta);
        this.saveButton.setX(this.width / 2 - this.saveButton.getWidth() / 2);
        this.cancelButton.setX(this.saveButton.getX() - 3 - this.saveButton.getWidth());
        this.exitButton.setX(this.saveButton.getX() + 3 + this.saveButton.getWidth());
        this.cancelButton.render(graphics, mouseX, mouseY, delta);
        this.saveButton.render(graphics, mouseX, mouseY, delta);
        this.exitButton.render(graphics, mouseX, mouseY, delta);
        ScissorsHandler.scissor(new Rectangle(this.listWidget.left, this.listWidget.top, this.listWidget.width, this.listWidget.bottom - this.listWidget.top));
        for (AbstractConfigEntry child : this.listWidget.children()) {
            child.lateRender(graphics, mouseX, mouseY, delta);
        }
        ScissorsHandler.removeLastScissor();
        graphics.drawString(this.font, this.title.getVisualOrderText(), (int)((float)this.width / 2.0f - (float)this.font.width((FormattedText)this.title) / 2.0f), 12, -1);
        super.render(graphics, mouseX, mouseY, delta);
    }

    public void renderBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean isPauseScreen() {
        return SuperResolutionConfig.isPauseGameOnGui();
    }

    protected static class CategoryTextEntry
    extends AbstractConfigListEntry<Object> {
        private final Component category;
        private final Component text;

        public CategoryTextEntry(Component category, Component text) {
            super((Component)Component.literal((String)UUID.randomUUID().toString()), false);
            this.category = category;
            this.text = text;
        }

        public int getItemHeight() {
            List strings = Minecraft.getInstance().font.split((FormattedText)this.text, this.getParent().getItemWidth());
            if (strings.isEmpty()) {
                return 0;
            }
            return 4 + strings.size() * 10;
        }

        @Nullable
        public ComponentPath nextFocusPath(FocusNavigationEvent focusNavigationEvent) {
            return null;
        }

        public Object getValue() {
            return null;
        }

        public Optional<Object> getDefaultValue() {
            return Optional.empty();
        }

        public boolean isMouseInside(int mouseX, int mouseY, int x, int y, int entryWidth, int entryHeight) {
            return false;
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            super.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
            int yy = y + 2;
            List texts = Minecraft.getInstance().font.split((FormattedText)this.text, this.getParent().getItemWidth());
            for (FormattedCharSequence text : texts) {
                graphics.drawString(Minecraft.getInstance().font, text, x - 4 + entryWidth / 2 - Minecraft.getInstance().font.width(text) / 2, yy, -1);
                yy += 10;
            }
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }

        public Component getCategory() {
            return this.category;
        }
    }
}

