/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft;

import com.mojang.blaze3d.pipeline.RenderTarget;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferTextureAdapter;
import io.homo.superresolution.core.graphics.impl.framebuffer.IBindableFrameBuffer;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.opengl.framebuffer.GlFrameBuffer;
import io.homo.superresolution.core.utils.ColorUtil;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL30;

public class MinecraftRenderTargetWrapper
implements IBindableFrameBuffer {
    public RenderTarget renderTarget;
    private int clearColor = ColorUtil.color(255, 0, 0, 0);

    public MinecraftRenderTargetWrapper(RenderTarget renderTarget) {
        this.renderTarget = renderTarget;
    }

    public static MinecraftRenderTargetWrapper of(RenderTarget renderTarget) {
        if (renderTarget == null) {
            return null;
        }
        MinecraftRenderTargetWrapper wrapper = new MinecraftRenderTargetWrapper(renderTarget);
        wrapper.clearColor = ColorUtil.color(255, 0, 0, 0);
        return wrapper;
    }

    @Override
    public void clearFrameBuffer() {
        this.renderTarget.clear(Minecraft.ON_OSX);
    }

    @Override
    public void resizeFrameBuffer(int width, int height) {
        this.renderTarget.resize(width, height, Minecraft.ON_OSX);
    }

    @Override
    public int getWidth() {
        return this.renderTarget.width;
    }

    @Override
    public int getHeight() {
        return this.renderTarget.height;
    }

    @Override
    public void destroy() {
        this.renderTarget.destroyBuffers();
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint, boolean setViewport) {
        if (bindPoint == FrameBufferBindPoint.Read) {
            this.renderTarget.bindRead();
        } else {
            this.renderTarget.bindWrite(setViewport);
        }
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint) {
        this.bind(bindPoint, true);
    }

    @Override
    public void unbind(FrameBufferBindPoint bindPoint) {
        GL30.glBindFramebuffer((int)GlFrameBuffer.resolveBindTarget(bindPoint), (int)0);
    }

    @Override
    public int getTextureId(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new MatchException(null, null);
            case FrameBufferAttachmentType.Color -> this.renderTarget.getColorTextureId();
            case FrameBufferAttachmentType.AnyDepth, FrameBufferAttachmentType.Depth, FrameBufferAttachmentType.DepthStencil -> this.renderTarget.getDepthTextureId();
        };
    }

    @Override
    public ITexture getTexture(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new MatchException(null, null);
            case FrameBufferAttachmentType.Color -> FrameBufferTextureAdapter.ofColor(this);
            case FrameBufferAttachmentType.AnyDepth, FrameBufferAttachmentType.Depth, FrameBufferAttachmentType.DepthStencil -> FrameBufferTextureAdapter.ofDepth(this);
        };
    }

    @Override
    public long handle() {
        return this.renderTarget.frameBufferId;
    }

    @Override
    public void setClearColorRGBA(float red, float green, float blue, float alpha) {
        this.renderTarget.setClearColor(red, green, blue, alpha);
    }

    @Override
    public TextureFormat getColorTextureFormat() {
        return TextureFormat.RGBA8;
    }

    @Override
    public TextureFormat getDepthTextureFormat() {
        return TextureFormat.DEPTH32F;
    }

    @Override
    public RenderTarget asMcRenderTarget() {
        return this.renderTarget;
    }
}

