/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.mixin.core;

import io.homo.superresolution.common.minecraft.CallType;
import io.homo.superresolution.common.minecraft.handler.RenderHandlerManager;
import io.homo.superresolution.common.minecraft.handler.ShaderCompatHandler;
import io.homo.superresolution.common.upscale.AlgorithmManager;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.PostChain;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    @Unique
    private static boolean superresolution$windowIsHide = false;

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/PostChain;resize(II)V"), method={"resize"})
    private void onResizePostChain(PostChain instance, int w, int h) {
        if (ShaderCompatHandler.isShaderPackCompatSuperResolution()) {
            return;
        }
        instance.resize(RenderHandlerManager.getRenderWidth(), RenderHandlerManager.getRenderHeight());
    }

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    private void renderLevel_MC_1_21_1(DeltaTracker deltaTracker, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f frustumMatrix, Matrix4f projectionMatrix, CallbackInfo ci) {
        AlgorithmManager.setMatrixVanilla(projectionMatrix, frustumMatrix);
    }

    @Inject(at={@At(value="HEAD")}, method={"renderLevel"}, cancellable=true)
    private void onRenderWorldBegin(CallbackInfo ci) {
        if (Minecraft.getInstance().level != null) {
            RenderHandlerManager.onRenderWorldBegin(CallType.LEVEL_RENDERER);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"renderLevel"})
    private void onRenderWorldEnd(CallbackInfo ci) {
        if (Minecraft.getInstance().level != null) {
            RenderHandlerManager.onRenderWorldEnd(CallType.LEVEL_RENDERER);
        }
    }
}

