/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.mixin.core;

import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.debug.PerformanceInfo;
import io.homo.superresolution.common.minecraft.MinecraftWindow;
import io.homo.superresolution.common.minecraft.handler.RenderHandlerManager;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public class MinecraftMixin {
    @Unique
    private int super_resolution$cacheWidth = 0;
    @Unique
    private int super_resolution$cacheHeight = 0;

    @Inject(at={@At(value="RETURN")}, method={"onGameLoadFinished"})
    private void onLoadDone(CallbackInfo ci) {
        SuperResolution.check();
        SuperResolution.gameIsLoad = true;
    }

    @Inject(at={@At(value="HEAD")}, method={"runTick"})
    private void onRenderBegin(CallbackInfo ci) {
        if (this.super_resolution$cacheWidth != RenderHandlerManager.getScreenWidth() || this.super_resolution$cacheHeight != RenderHandlerManager.getScreenHeight()) {
            this.super_resolution$cacheWidth = RenderHandlerManager.getScreenWidth();
            this.super_resolution$cacheHeight = RenderHandlerManager.getScreenHeight();
            Minecraft.getInstance().resizeDisplay();
        }
        GL11.glViewport((int)0, (int)0, (int)RenderHandlerManager.getScreenWidth(), (int)RenderHandlerManager.getScreenHeight());
        PerformanceInfo.begin("runTick");
        RenderHandlerManager.onRenderBegin();
    }

    @Inject(at={@At(value="RETURN")}, method={"runTick"})
    private void onRenderEnd(CallbackInfo ci) {
        PerformanceInfo.end("runTick");
        RenderHandlerManager.onRenderEnd();
    }

    @Inject(at={@At(value="HEAD")}, method={"destroy"})
    private void onExit(CallbackInfo ci) {
        SuperResolution.getInstance().destroy();
    }

    @Inject(method={"resizeDisplay"}, at={@At(value="HEAD")}, cancellable=true)
    private void onResize(CallbackInfo ci) {
        if (MinecraftWindow.getWindowSourceWidth() <= 1 || MinecraftWindow.getWindowSourceHeight() <= 1) {
            ci.cancel();
        }
    }
}

