/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.mixin.core;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.config.SuperResolutionConfig;
import io.homo.superresolution.common.minecraft.handler.RenderHandlerManager;
import io.homo.superresolution.common.minecraft.handler.ShaderCompatHandler;
import io.homo.superresolution.common.mixin.core.accessor.PostChainAccessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PostChain.class})
public abstract class PostChainMixin {
    @Unique
    private List<String> super_resolution$blackList = null;
    @Shadow
    @Final
    private List<PostPass> passes;
    @Shadow
    @Final
    private Map<String, RenderTarget> customRenderTargets;
    @Shadow
    @Final
    private RenderTarget screenTarget;
    @Shadow
    @Final
    private String name;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void onInitPostChain(TextureManager textureManager, ResourceProvider resourceProvider, RenderTarget screenTarget, ResourceLocation resourceLocation, CallbackInfo ci) throws IOException, JsonSyntaxException {
        if (this.super_resolution$onBlackList()) {
            return;
        }
        if (ShaderCompatHandler.isShaderPackCompatSuperResolution()) {
            return;
        }
        if (!screenTarget.equals(RenderHandlerManager.getOriginRenderTarget().asMcRenderTarget())) {
            return;
        }
        this.passes.forEach(PostPass::close);
        this.passes.clear();
        this.customRenderTargets.values().forEach(RenderTarget::destroyBuffers);
        this.customRenderTargets.clear();
        ((PostChainAccessor)((Object)this)).setScreenTarget(RenderHandlerManager.getRenderTarget().asMcRenderTarget());
        this.updateOrthoMatrix();
        this.load(textureManager, resourceLocation);
        SuperResolution.LOGGER.info("\u5df2\u6ce8\u5165PostChain {}", (Object)this.name);
    }

    @Shadow
    public abstract void resize(int var1, int var2);

    @Shadow
    protected abstract void updateOrthoMatrix();

    @Shadow
    protected abstract void load(TextureManager var1, ResourceLocation var2) throws IOException, JsonSyntaxException;

    @Inject(method={"resize"}, at={@At(value="HEAD")}, cancellable=true)
    public void onResize(int width, int height, CallbackInfo ci) {
        if (this.super_resolution$onBlackList()) {
            return;
        }
        if (ShaderCompatHandler.isShaderPackCompatSuperResolution()) {
            return;
        }
        if (width != RenderHandlerManager.getRenderWidth() || height != RenderHandlerManager.getRenderHeight()) {
            this.resize(RenderHandlerManager.getRenderWidth(), RenderHandlerManager.getRenderHeight());
            ci.cancel();
        }
    }

    @Inject(method={"process"}, at={@At(value="HEAD")})
    public void onProcess(float partialTicks, CallbackInfo ci) {
        if (this.super_resolution$onBlackList()) {
            return;
        }
        if (ShaderCompatHandler.isShaderPackCompatSuperResolution()) {
            ((PostChainAccessor)((Object)this)).setScreenTarget(RenderHandlerManager.getOriginRenderTarget().asMcRenderTarget());
            return;
        }
        RenderHandlerManager.onProcessPostChain((PostChain)this);
    }

    @Unique
    private boolean super_resolution$onBlackList() {
        if (this.super_resolution$blackList == null) {
            this.super_resolution$blackList = new ArrayList<String>();
            this.super_resolution$blackList.add("minecraft:shaders/post/modern_gaussian_blur.json");
            this.super_resolution$blackList.add("minecraft:shaders/post/blur.json");
            this.super_resolution$blackList.add("colorblindness:shaders/post/achromatomaly.json");
            this.super_resolution$blackList.add("colorblindness:shaders/post/achromatopsia.json");
            this.super_resolution$blackList.add("colorblindness:shaders/post/deuteranomaly.json");
            this.super_resolution$blackList.add("colorblindness:shaders/post/deuteranopia.json");
            this.super_resolution$blackList.add("colorblindness:shaders/post/protanomaly.json");
            this.super_resolution$blackList.add("colorblindness:shaders/post/protanopia.json");
            this.super_resolution$blackList.add("colorblindness:shaders/post/tritanomaly.json");
            this.super_resolution$blackList.add("colorblindness:shaders/post/tritanopia.json");
            this.super_resolution$blackList.addAll(SuperResolutionConfig.getInjectPostChainBlackList());
        }
        return this.super_resolution$blackList.contains(this.name);
    }
}

