/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.core;

import io.homo.superresolution.core.gui.core.AbstractWidget;
import io.homo.superresolution.core.gui.core.UIInputState;
import io.homo.superresolution.core.gui.core.WidgetStyle;
import io.homo.superresolution.core.gui.core.animator.AnimationSet;
import io.homo.superresolution.core.gui.core.backends.interfaces.IUIDrawContext;
import io.homo.superresolution.core.gui.core.impl.Rectangle;
import io.homo.superresolution.core.gui.core.impl.Renderable;
import io.homo.superresolution.core.gui.core.layout.ILayoutContainer;
import io.homo.superresolution.core.gui.core.layout.ILayoutElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joml.Vector2f;

public abstract class AbstractContainerWidget<T extends AbstractWidget<?, ?, ?>, STYLE extends WidgetStyle<?>, ANIM extends AnimationSet>
extends AbstractWidget<T, STYLE, ANIM>
implements ILayoutContainer {
    protected final List<ILayoutElement> children = new ArrayList<ILayoutElement>();

    @Override
    protected void init() {
        super.getLayoutNode().setDebugName("ContainerNode");
    }

    @Override
    public void addChild(ILayoutElement element) {
        this.children.add(element);
        element.setParent(this);
        this.getLayoutNode().addChildAt(element.getLayoutNode(), this.getLayoutNode().getChildCount());
    }

    @Override
    public void removeChild(ILayoutElement element) {
        this.children.remove(element);
        element.setParent(null);
        this.getLayoutNode().removeChild(element.getLayoutNode());
    }

    @Override
    public List<ILayoutElement> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChild(AbstractWidget<?, ?, ?> widget) {
        this.addChild((ILayoutElement)widget);
    }

    public void removeChild(AbstractWidget<?, ?, ?> widget) {
        this.removeChild((ILayoutElement)widget);
    }

    @Override
    public void mouseMove(float x, float y) {
        super.mouseMove(x, y);
        if (this.isDisabled() || !this.isVisible()) {
            return;
        }
        for (ILayoutElement child : this.children) {
            AbstractWidget widget;
            if (!(child instanceof AbstractWidget) || !(widget = (AbstractWidget)child).isVisible() || widget.isDisabled() || this.isOutsideView(widget)) continue;
            widget.mouseMove(x, y);
        }
    }

    @Override
    public void mousePress(float x, float y, int button) {
        super.mousePress(x, y, button);
        if (this.isDisabled() || !this.isVisible()) {
            return;
        }
        for (ILayoutElement child : this.children) {
            AbstractWidget widget;
            if (!(child instanceof AbstractWidget) || !(widget = (AbstractWidget)child).isVisible() || widget.isDisabled() || this.isOutsideView(widget, new Vector2f(x, y))) continue;
            widget.mousePress(x, y, button);
        }
    }

    @Override
    public void mouseRelease(float x, float y, int button) {
        super.mouseRelease(x, y, button);
        if (this.isDisabled() || !this.isVisible()) {
            return;
        }
        for (ILayoutElement child : this.children) {
            AbstractWidget widget;
            if (!(child instanceof AbstractWidget) || !(widget = (AbstractWidget)child).isVisible() || widget.isDisabled() || this.isOutsideView(widget)) continue;
            widget.mouseRelease(x, y, button);
        }
    }

    @Override
    public void mouseDrag(float mouseX, float mouseY, float dragX, float dragY, int button) {
        super.mouseDrag(mouseX, mouseY, dragX, dragY, button);
        if (this.isDisabled() || !this.isVisible()) {
            return;
        }
        for (ILayoutElement child : this.children) {
            AbstractWidget widget;
            if (!(child instanceof AbstractWidget) || !(widget = (AbstractWidget)child).isVisible() || widget.isDisabled() || this.isOutsideView(widget)) continue;
            widget.mouseDrag(mouseX, mouseY, dragX, dragY, button);
        }
    }

    @Override
    public void mouseScroll(float x, float y, double scrollX) {
        super.mouseScroll(x, y, scrollX);
        if (this.isDisabled() || !this.isVisible()) {
            return;
        }
        for (ILayoutElement child : this.children) {
            AbstractWidget widget;
            if (!(child instanceof AbstractWidget) || !(widget = (AbstractWidget)child).isVisible() || widget.isDisabled() || this.isOutsideView(widget, new Vector2f(x, y))) continue;
            widget.mouseScroll(x, y, scrollX);
        }
    }

    @Override
    public void keyPress(int keyCode, int scancode, int modifiers) {
        super.keyPress(keyCode, scancode, modifiers);
        if (this.isDisabled() || !this.isVisible()) {
            return;
        }
        for (ILayoutElement child : this.children) {
            AbstractWidget widget;
            if (!(child instanceof AbstractWidget) || !(widget = (AbstractWidget)child).isVisible() || widget.isDisabled()) continue;
            widget.keyPress(keyCode, scancode, modifiers);
        }
    }

    @Override
    public void keyRelease(int keyCode, int scancode, int modifiers) {
        super.keyRelease(keyCode, scancode, modifiers);
        if (this.isDisabled() || !this.isVisible()) {
            return;
        }
        for (ILayoutElement child : this.children) {
            AbstractWidget widget;
            if (!(child instanceof AbstractWidget) || !(widget = (AbstractWidget)child).isVisible() || widget.isDisabled()) continue;
            widget.keyRelease(keyCode, scancode, modifiers);
        }
    }

    @Override
    public void charTyped(char codePoint, int modifiers) {
        super.charTyped(codePoint, modifiers);
        if (this.isDisabled() || !this.isVisible()) {
            return;
        }
        for (ILayoutElement child : this.children) {
            AbstractWidget widget;
            if (!(child instanceof AbstractWidget) || !(widget = (AbstractWidget)child).isVisible() || widget.isDisabled()) continue;
            widget.charTyped(codePoint, modifiers);
        }
    }

    @Override
    public void render(IUIDrawContext drawContext, UIInputState inputState) {
        if (!this.isVisible()) {
            return;
        }
        this.renderSelf(drawContext, inputState);
        for (ILayoutElement child : this.children) {
            if (!(child instanceof Renderable)) continue;
            Renderable renderableChild = (Renderable)((Object)child);
            renderableChild.render(drawContext, inputState);
        }
    }

    @Override
    public AbstractWidget<?, ?, ?> findInteractiveWidgetAt(Vector2f absPos) {
        if (!this.isVisible() || this.isDisabled() || !this.hitTest(absPos)) {
            return null;
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            AbstractWidget<?, ?, ?> interactive;
            AbstractWidget widget;
            ILayoutElement child = this.children.get(i);
            if (!(child instanceof AbstractWidget) || !(widget = (AbstractWidget)child).isVisible() || widget.isDisabled() || (interactive = widget.findInteractiveWidgetAt(absPos)) == null) continue;
            return interactive;
        }
        return this.isInteractive() ? this : null;
    }

    protected Rectangle getAbsoluteViewRect() {
        return new Rectangle(this.getAbsolutePosition().x, this.getAbsolutePosition().y, this.getBounds().width, this.getBounds().height);
    }

    private boolean isOutsideView(AbstractWidget<?, ?, ?> child) {
        Rectangle childAbs;
        Rectangle view = this.getAbsoluteViewRect();
        return !view.intersect(childAbs = new Rectangle(child.getAbsolutePosition().x, child.getAbsolutePosition().y, child.getBounds().width, child.getBounds().height));
    }

    private boolean isOutsideView(AbstractWidget<?, ?, ?> child, Vector2f position) {
        Rectangle view = this.getAbsoluteViewRect();
        Rectangle childAbs = new Rectangle(child.getAbsolutePosition().x, child.getAbsolutePosition().y, child.getBounds().width, child.getBounds().height);
        return !(view.x == 0.0f && view.y == 0.0f && view.width == 0.0f && view.height == 0.0f || view.intersect(childAbs) && view.intersection(childAbs).in(position));
    }

    protected abstract Rectangle getViewRegion();

    protected void renderSelf(IUIDrawContext drawContext, UIInputState inputState) {
    }
}

