/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.core.backends.nanovg;

import io.homo.superresolution.core.gui.core.backends.interfaces.BatchManager;
import io.homo.superresolution.core.gui.core.backends.interfaces.CommandsBatch;
import io.homo.superresolution.core.gui.core.backends.interfaces.IFont;
import io.homo.superresolution.core.gui.core.backends.interfaces.IPaint;
import io.homo.superresolution.core.gui.core.backends.interfaces.ITransformStack;
import io.homo.superresolution.core.gui.core.backends.interfaces.IUIDrawContext;
import io.homo.superresolution.core.gui.core.backends.interfaces.TextAlign;
import io.homo.superresolution.core.gui.core.backends.interfaces.Transform;
import io.homo.superresolution.core.gui.core.backends.interfaces.TransformStack;
import io.homo.superresolution.core.gui.core.backends.nanovg.NanoVG;
import io.homo.superresolution.core.gui.core.backends.nanovg.NanoVGContext;
import io.homo.superresolution.core.gui.core.backends.nanovg.NanoVGFont;
import io.homo.superresolution.core.gui.core.backends.nanovg.NanoVGFontLoader;
import io.homo.superresolution.core.gui.core.backends.nanovg.NanoVGPaint;
import io.homo.superresolution.core.gui.core.backends.nanovg.commands.NVGAddScissorCommand;
import io.homo.superresolution.core.gui.core.backends.nanovg.commands.NVGApplyTransformCommand;
import io.homo.superresolution.core.gui.core.backends.nanovg.commands.NVGBeginPathCommand;
import io.homo.superresolution.core.gui.core.backends.nanovg.commands.NVGDrawTextCommand;
import io.homo.superresolution.core.gui.core.backends.nanovg.commands.NVGEndPathCommand;
import io.homo.superresolution.core.gui.core.backends.nanovg.commands.NVGPathArcCommand;
import io.homo.superresolution.core.gui.core.backends.nanovg.commands.NVGPathLineCommand;
import io.homo.superresolution.core.gui.core.backends.nanovg.commands.NVGPathRectCommand;
import io.homo.superresolution.core.gui.core.backends.nanovg.commands.NVGPathRoundedRectComplexCommand;
import io.homo.superresolution.core.gui.core.backends.nanovg.commands.NVGResetScissorCommand;
import io.homo.superresolution.core.gui.core.backends.nanovg.commands.NVGRestoreStateCommand;
import io.homo.superresolution.core.gui.core.backends.nanovg.commands.NVGSaveStateCommand;
import io.homo.superresolution.core.gui.core.backends.nanovg.commands.NVGSetFillColorCommand;
import io.homo.superresolution.core.gui.core.backends.nanovg.commands.NVGSetGlobalAlphaCommand;
import io.homo.superresolution.core.gui.core.backends.nanovg.commands.NVGSetPaintCommand;
import io.homo.superresolution.core.gui.core.backends.nanovg.commands.NVGSetStrokeColorCommand;
import io.homo.superresolution.core.gui.core.backends.nanovg.commands.NVGSetStrokeWidthCommand;
import io.homo.superresolution.core.utils.Color;
import org.joml.Vector2f;
import org.lwjgl.nanovg.NVGColor;
import org.lwjgl.nanovg.NVGPaint;

public class NanoVGDrawContext
implements IUIDrawContext {
    private final NanoVGContext nvgContext;
    private final TransformStackWrapper transformStack;
    private final BatchManager batchManager;

    public NanoVGDrawContext(NanoVGContext nvgContext) {
        this.nvgContext = nvgContext;
        this.transformStack = new TransformStackWrapper(new TransformStack());
        this.batchManager = new BatchManager();
    }

    @Override
    public TransformStackWrapper transform() {
        return this.transformStack;
    }

    public NanoVGContext nvg() {
        return this.nvgContext;
    }

    @Override
    public void save() {
        CommandsBatch currentBatch = this.batchManager.getCurrentBatch();
        if (currentBatch != null) {
            currentBatch.addCommand(new NVGSaveStateCommand(this.nvgContext));
        }
    }

    @Override
    public void restore() {
        CommandsBatch currentBatch = this.batchManager.getCurrentBatch();
        if (currentBatch != null) {
            currentBatch.addCommand(new NVGRestoreStateCommand(this.nvgContext));
        }
    }

    @Override
    public void line(float x1, float y1, float x2, float y2) {
        CommandsBatch currentBatch = this.batchManager.getCurrentBatch();
        if (currentBatch != null) {
            currentBatch.addCommand(new NVGPathLineCommand(this.nvgContext, x1, y1, x2, y2));
        }
    }

    @Override
    public void rect(float x, float y, float width, float height) {
        CommandsBatch currentBatch = this.batchManager.getCurrentBatch();
        if (currentBatch != null) {
            currentBatch.addCommand(new NVGPathRectCommand(this.nvgContext, x, y, width, height));
        }
    }

    @Override
    public void arc(float x, float y, float radius, float a0, float a1) {
        CommandsBatch currentBatch = this.batchManager.getCurrentBatch();
        if (currentBatch != null) {
            currentBatch.addCommand(new NVGPathArcCommand(this.nvgContext, x, y, radius, a0, a1));
        }
    }

    @Override
    public void roundedRectComplex(float x, float y, float width, float height, float bottomLeftRadius, float bottomRightRadius, float topLeftRadius, float topRightRadius) {
        CommandsBatch currentBatch = this.batchManager.getCurrentBatch();
        if (currentBatch != null) {
            currentBatch.addCommand(new NVGPathRoundedRectComplexCommand(this.nvgContext, x, y, width, height, bottomLeftRadius, bottomRightRadius, topLeftRadius, topRightRadius));
        }
    }

    @Override
    public void beginPath() {
        CommandsBatch currentBatch = this.batchManager.getCurrentBatch();
        if (currentBatch != null) {
            currentBatch.addCommand(new NVGBeginPathCommand(this.nvgContext));
        }
    }

    @Override
    public void endPath(boolean fill) {
        CommandsBatch currentBatch = this.batchManager.getCurrentBatch();
        if (currentBatch != null) {
            currentBatch.addCommand(new NVGEndPathCommand(this.nvgContext, fill));
        }
    }

    @Override
    public void drawAlignedText(IFont font, float fontSize, String text, float startX, float startY, float maxWidth, float lineHeight, Color color, TextAlign align, boolean wrap) {
        CommandsBatch currentBatch = this.batchManager.getCurrentBatch();
        if (currentBatch != null) {
            currentBatch.addCommand(new NVGDrawTextCommand(this.nvgContext, font, fontSize, text, startX, startY, maxWidth, lineHeight, color, align, wrap));
        }
    }

    @Override
    public NanoVGPaint linearGradient(float startX, float startY, float endX, float endY, Color from, Color to) {
        return new NanoVGPaint(this.nvgContext.linearGradient(startX, startY, endX, endY, from, to));
    }

    @Override
    public NanoVGPaint linearGradient(float startX, float startY, float endX, float endY, Color from, Color to, IPaint srcPaint) {
        return new NanoVGPaint(this.nvgContext.linearGradient(startX, startY, endX, endY, from, to, ((NanoVGPaint)srcPaint).get()));
    }

    @Override
    public NanoVGPaint imagePattern(float ox, float oy, float ex, float ey, float width, float height, float angle, float alpha, int image) {
        return new NanoVGPaint(this.nvgContext.imagePattern(ox, oy, ex, ey, width, height, angle, alpha, image));
    }

    @Override
    public IPaint radialGradient(float centerX, float centerY, float radius, Color beginColor, Color endColor) {
        return new NanoVGPaint(org.lwjgl.nanovg.NanoVG.nvgRadialGradient((long)this.nvgContext.contextPtr, (float)centerX, (float)centerY, (float)0.0f, (float)radius, (NVGColor)beginColor.nvg(), (NVGColor)endColor.nvg(), (NVGPaint)NVGPaint.calloc()));
    }

    @Override
    public NanoVGPaint radialGradient(float centerX, float centerY, float innerRadius, float outerRadius, Color beginColor, Color endColor) {
        return (NanoVGPaint)this.radialGradient(centerX, centerY, innerRadius, outerRadius, beginColor, endColor, this.createPaint());
    }

    @Override
    public IPaint radialGradient(float centerX, float centerY, float radius, Color beginColor, Color endColor, IPaint srcPaint) {
        return this.radialGradient(centerX, centerY, 0.0f, radius, beginColor, endColor, srcPaint);
    }

    @Override
    public IPaint radialGradient(float centerX, float centerY, float innerRadius, float outerRadius, Color beginColor, Color endColor, IPaint srcPaint) {
        return new NanoVGPaint(org.lwjgl.nanovg.NanoVG.nvgRadialGradient((long)this.nvgContext.contextPtr, (float)centerX, (float)centerY, (float)innerRadius, (float)outerRadius, (NVGColor)beginColor.nvg(), (NVGColor)endColor.nvg(), (NVGPaint)((NanoVGPaint)srcPaint).get()));
    }

    @Override
    public void strokeWidth(float width) {
        CommandsBatch currentBatch = this.batchManager.getCurrentBatch();
        if (currentBatch != null) {
            currentBatch.addCommand(new NVGSetStrokeWidthCommand(this.nvgContext, width));
        }
    }

    @Override
    public void strokeColor(Color color) {
        CommandsBatch currentBatch = this.batchManager.getCurrentBatch();
        if (currentBatch != null) {
            currentBatch.addCommand(new NVGSetStrokeColorCommand(this.nvgContext, color));
        }
    }

    @Override
    public void fillColor(Color color) {
        CommandsBatch currentBatch = this.batchManager.getCurrentBatch();
        if (currentBatch != null) {
            currentBatch.addCommand(new NVGSetFillColorCommand(this.nvgContext, color));
        }
    }

    @Override
    public Color fillColor() {
        return this.nvgContext.fillColor();
    }

    @Override
    public Color strokeColor() {
        return this.nvgContext.strokeColor();
    }

    @Override
    public float strokeWidth() {
        return this.nvgContext.strokeWidth();
    }

    @Override
    public void paint(IPaint paint) {
        CommandsBatch currentBatch = this.batchManager.getCurrentBatch();
        if (currentBatch != null) {
            currentBatch.addCommand(new NVGSetPaintCommand(this.nvgContext, paint));
        }
    }

    @Override
    public IPaint createPaint() {
        return new NanoVGPaint();
    }

    @Override
    public float globalAlpha() {
        return this.nvgContext.globalAlpha();
    }

    @Override
    public void globalAlpha(float alpha) {
        CommandsBatch currentBatch = this.batchManager.getCurrentBatch();
        if (currentBatch != null) {
            currentBatch.addCommand(new NVGSetGlobalAlphaCommand(this.nvgContext, alpha));
        }
    }

    @Override
    public void resetScissor() {
        CommandsBatch currentBatch = this.batchManager.getCurrentBatch();
        if (currentBatch != null) {
            currentBatch.addCommand(new NVGResetScissorCommand(this.nvgContext));
        }
    }

    @Override
    public void scissor(float x, float y, float width, float height) {
        CommandsBatch currentBatch = this.batchManager.getCurrentBatch();
        if (currentBatch != null) {
            currentBatch.addCommand(new NVGAddScissorCommand(this.nvgContext, x, y, width, height));
        }
    }

    @Override
    public float measureTextWidth(String text, float fontSize) {
        return NanoVG.RENDERER.TEXT.measureTextWidth(text, fontSize);
    }

    @Override
    public float measureTextHeight(String text, float fontSize) {
        return NanoVG.RENDERER.TEXT.measureTextHeight(text, fontSize);
    }

    @Override
    public Vector2f measureText(String text, float fontSize) {
        return NanoVG.RENDERER.TEXT.measureText(text, fontSize);
    }

    @Override
    public NanoVGFont font() {
        return NanoVGFontLoader.FONT_MAP.get("regular");
    }

    @Override
    public void beginBatch() {
        this.batchManager.beginBatch();
    }

    @Override
    public void endBatch(int zIndex) {
        this.batchManager.endBatch(zIndex);
    }

    @Override
    public void closeBatch() {
        this.batchManager.closeCurrentBatch();
    }

    @Override
    public void clearBatches() {
        this.batchManager.clearBatches();
    }

    @Override
    public void drawAll() {
        this.batchManager.executeAll();
    }

    public BatchManager getBatchManager() {
        return this.batchManager;
    }

    @Override
    public void immediateScissor(float x, float y, float width, float height) {
        org.lwjgl.nanovg.NanoVG.nvgScissor((long)this.nvgContext.contextPtr, (float)x, (float)y, (float)width, (float)height);
    }

    @Override
    public void immediateResetScissor() {
        org.lwjgl.nanovg.NanoVG.nvgResetScissor((long)this.nvgContext.contextPtr);
    }

    @Override
    public void immediateSave() {
        org.lwjgl.nanovg.NanoVG.nvgSave((long)this.nvgContext.contextPtr);
    }

    @Override
    public void immediateRestore() {
        org.lwjgl.nanovg.NanoVG.nvgRestore((long)this.nvgContext.contextPtr);
    }

    public class TransformStackWrapper
    implements ITransformStack {
        private final TransformStack transformStack;

        private TransformStackWrapper(TransformStack transformStack) {
            this.transformStack = transformStack;
        }

        @Override
        public TransformStack stack() {
            return this.transformStack;
        }

        @Override
        public Transform last() {
            return this.transformStack.last();
        }

        protected void applyTransformStack() {
            CommandsBatch currentBatch = NanoVGDrawContext.this.batchManager.getCurrentBatch();
            if (currentBatch != null) {
                currentBatch.addCommand(new NVGApplyTransformCommand(NanoVGDrawContext.this.nvgContext, this.transformStack.last().copy()));
            }
        }

        @Override
        public void push() {
            this.transformStack.push();
            this.applyTransformStack();
        }

        @Override
        public void pop() {
            this.transformStack.pop();
            this.applyTransformStack();
        }

        @Override
        public void translate(float x, float y) {
            this.transformStack.translate(x, y);
            this.applyTransformStack();
        }

        @Override
        public void scale(float sx, float sy) {
            this.transformStack.scale(sx, sy);
            this.applyTransformStack();
        }

        @Override
        public void rotate(float radians) {
            this.transformStack.rotate(radians);
            this.applyTransformStack();
        }

        @Override
        public void identity() {
            this.transformStack.setIdentity();
            this.applyTransformStack();
        }
    }
}

