/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.neoforge.mixin.compat.iris;

import io.homo.superresolution.common.compat.iris.IrisFramebufferUtils;
import net.irisshaders.iris.compat.dh.DHCompatInternal;
import net.irisshaders.iris.gl.framebuffer.GlFramebuffer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DHCompatInternal.class}, remap=false)
public class DHCompatInternalMixin {
    @Shadow
    private GlFramebuffer dhGenericFramebuffer;
    @Shadow
    private GlFramebuffer dhShadowFramebuffer;
    @Shadow
    private GlFramebuffer dhWaterFramebuffer;
    @Shadow
    private GlFramebuffer dhTerrainFramebuffer;

    @Inject(method={"reconnectDHTextures"}, at={@At(value="RETURN")})
    public void fixDHDepth(int depthTex, CallbackInfo ci) {
        if (this.dhTerrainFramebuffer != null && IrisFramebufferUtils.getFramebufferDepthAttachment(this.dhWaterFramebuffer.getId()) != depthTex) {
            this.reconnectTextures(depthTex);
        }
        if (this.dhWaterFramebuffer != null && IrisFramebufferUtils.getFramebufferDepthAttachment(this.dhWaterFramebuffer.getId()) != depthTex) {
            this.reconnectTextures(depthTex);
        }
        if (this.dhGenericFramebuffer != null && IrisFramebufferUtils.getFramebufferDepthAttachment(this.dhWaterFramebuffer.getId()) != depthTex) {
            this.reconnectTextures(depthTex);
        }
    }

    private void reconnectTextures(int depthTex) {
        if (this.dhTerrainFramebuffer != null) {
            this.dhTerrainFramebuffer.addDepthAttachment(depthTex);
        }
        if (this.dhWaterFramebuffer != null) {
            this.dhWaterFramebuffer.addDepthAttachment(depthTex);
        }
        if (this.dhGenericFramebuffer != null) {
            this.dhGenericFramebuffer.addDepthAttachment(depthTex);
        }
    }
}

