/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.neoforge.platform;

import io.homo.superresolution.api.platform.EnvironmentType;
import io.homo.superresolution.api.platform.Platform;
import io.homo.superresolution.neoforge.platform.IrisNeoForgePlatform;
import java.nio.file.Path;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.LoadingModList;

public class NeoForgePlatform
extends Platform {
    @Override
    public void init() {
        this.irisPlatform = new IrisNeoForgePlatform();
    }

    @Override
    public boolean isModLoaded(String modId) {
        return LoadingModList.get().getModFileById(modId) != null;
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public String getModVersionString(String modId) {
        if (this.isModLoaded(modId)) {
            return ModList.get().getModFileById(modId).versionString();
        }
        return null;
    }

    @Override
    public EnvironmentType getEnv() {
        return FMLLoader.getDist().isClient() ? EnvironmentType.CLIENT : EnvironmentType.SERVER;
    }

    @Override
    public String getMinecraftVersion() {
        return "1.21.1";
    }

    @Override
    public Path getGameFolder() {
        return FMLLoader.getGamePath();
    }
}

