/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.shadercompat.mixin.core;

import com.google.common.collect.ImmutableList;
import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.config.SuperResolutionConfig;
import io.homo.superresolution.common.minecraft.handler.SRShaderCompatConfig;
import io.homo.superresolution.shadercompat.SRCompatShaderPack;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Map;
import net.irisshaders.iris.shaderpack.ShaderPack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ShaderPack.class}, remap=false)
public class ShaderPackMixin
implements SRCompatShaderPack {
    @Unique
    private SRShaderCompatConfig superresolution$config;

    @Inject(method={"<init>(Ljava/nio/file/Path;Ljava/util/Map;Lcom/google/common/collect/ImmutableList;Z)V"}, at={@At(value="RETURN")}, remap=false)
    private void loadSuperResolutionComaptConfig(Path root, Map<?, ?> changedConfigs, ImmutableList<?> environmentDefines, boolean isZip, CallbackInfo ci) {
        try {
            Path srConfigPath = root.resolve("superresolution.json");
            if (Files.exists(srConfigPath, new LinkOption[0])) {
                this.superresolution$config = SRShaderCompatConfig.loadFromJson(srConfigPath);
                SuperResolution.LOGGER.info("\u5149\u5f71\u5305 {} \u652f\u6301\u8d85\u5206\u8fa8\u7387\u529f\u80fd", (Object)root);
                return;
            }
        }
        catch (NoSuchFileException srConfigPath) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            SuperResolution.LOGGER.warn("\u52a0\u8f7d {} \u5149\u5f71\u5305\u4e2d\u7684 superresolution.json \u65f6\u53d1\u751f\u9519\u8bef", (Object)root);
        }
        this.superresolution$config = null;
    }

    @Override
    @Unique
    public SRShaderCompatConfig superresolution$getSuperResolutionComaptConfig() {
        return SuperResolutionConfig.isForceDisableShaderCompat() ? null : this.superresolution$config;
    }

    @Override
    @Unique
    public boolean superresolution$isSupportsSuperResolution() {
        return !SuperResolutionConfig.isForceDisableShaderCompat() && this.superresolution$config != null && this.superresolution$config.sr.enabled;
    }
}

