/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm;

import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDirection;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDisplay;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaFlexDirection;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaNode;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaPositionType;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaWrap;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.BoundAxis;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.FlexDirectionUtil;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.FlexLineRunningLayout;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.node.LayoutableChildren;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.numeric.FloatOptional;
import java.util.ArrayList;
import java.util.List;

public class FlexLine {
    private final List<YogaNode> itemsInFlow;
    private final float sizeConsumed;
    private final int numberOfAutoMargins;
    private FlexLineRunningLayout layout;

    public FlexLine(List<YogaNode> itemsInFlow, float sizeConsumed, int numberOfAutoMargins, FlexLineRunningLayout layout) {
        this.itemsInFlow = itemsInFlow;
        this.sizeConsumed = sizeConsumed;
        this.numberOfAutoMargins = numberOfAutoMargins;
        this.layout = layout;
    }

    public List<YogaNode> getItemsInFlow() {
        return this.itemsInFlow;
    }

    public float getSizeConsumed() {
        return this.sizeConsumed;
    }

    public int getNumberOfAutoMargins() {
        return this.numberOfAutoMargins;
    }

    public FlexLineRunningLayout getLayout() {
        return this.layout;
    }

    public void setLayout(FlexLineRunningLayout layout) {
        this.layout = layout;
    }

    public static FlexLine calculateFlexLine(YogaNode node, YogaDirection ownerDirection, float ownerWidth, float mainAxisOwnerSize, float availableInnerWidth, float availableInnerMainDim, LayoutableChildren.LayoutIterator iterator, int lineCount) {
        ArrayList<YogaNode> itemsInFlow = new ArrayList<YogaNode>();
        float sizeConsumed = 0.0f;
        float totalFlexGrowFactors = 0.0f;
        float totalFlexShrinkScaledFactors = 0.0f;
        int numberOfAutoMargins = 0;
        YogaNode firstElementInLine = null;
        float sizeConsumedIncludingMinConstraint = 0.0f;
        YogaDirection direction = node.resolveDirection(ownerDirection);
        YogaFlexDirection mainAxis = FlexDirectionUtil.resolveDirection(node.getStyle().getFlexDirection(), direction);
        boolean isNodeFlexWrap = node.getStyle().getFlexWrap() != YogaWrap.NO_WRAP;
        float gap = node.getStyle().computeGapForAxis(mainAxis, availableInnerMainDim);
        while (iterator.hasNext()) {
            YogaNode child = iterator.current();
            if (child.getStyle().getDisplay() != YogaDisplay.NONE && child.getStyle().getPositionType() != YogaPositionType.ABSOLUTE) {
                if (firstElementInLine == null) {
                    firstElementInLine = child;
                }
                if (child.getStyle().flexStartMarginIsAuto(mainAxis, ownerDirection)) {
                    ++numberOfAutoMargins;
                }
                if (child.getStyle().flexEndMarginIsAuto(mainAxis, ownerDirection)) {
                    ++numberOfAutoMargins;
                }
                child.setLineIndex(lineCount);
                float childMarginMainAxis = child.getStyle().computeMarginForAxis(mainAxis, availableInnerWidth);
                float childLeadingGapMainAxis = child == firstElementInLine ? 0.0f : gap;
                FloatOptional flexBasisWithMinAndMaxConstraints = BoundAxis.boundAxisWithinMinAndMax(child, direction, mainAxis, child.getLayout().computedFlexBasis, mainAxisOwnerSize, ownerWidth);
                if (sizeConsumedIncludingMinConstraint + flexBasisWithMinAndMaxConstraints.unwrap() + childMarginMainAxis + childLeadingGapMainAxis > availableInnerMainDim && isNodeFlexWrap && !itemsInFlow.isEmpty()) break;
                sizeConsumedIncludingMinConstraint += flexBasisWithMinAndMaxConstraints.unwrap() + childMarginMainAxis + childLeadingGapMainAxis;
                sizeConsumed += flexBasisWithMinAndMaxConstraints.unwrap() + childMarginMainAxis + childLeadingGapMainAxis;
                if (child.isNodeFlexible()) {
                    totalFlexGrowFactors += child.resolveFlexGrow();
                    totalFlexShrinkScaledFactors += -child.resolveFlexShrink() * child.getLayout().computedFlexBasis.unwrap();
                }
                itemsInFlow.add(child);
            }
            iterator.next();
        }
        if (totalFlexGrowFactors > 0.0f && totalFlexGrowFactors < 1.0f) {
            totalFlexGrowFactors = 1.0f;
        }
        if (totalFlexShrinkScaledFactors > 0.0f && totalFlexShrinkScaledFactors < 1.0f) {
            totalFlexShrinkScaledFactors = 1.0f;
        }
        FlexLineRunningLayout layout = new FlexLineRunningLayout(totalFlexGrowFactors, totalFlexShrinkScaledFactors, 0.0f, 0.0f, 0.0f);
        return new FlexLine(itemsInFlow, sizeConsumed, numberOfAutoMargins, layout);
    }
}

