/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.gui;

import io.homo.superresolution.api.registry.AlgorithmDescription;
import io.homo.superresolution.api.registry.AlgorithmRegistry;
import io.homo.superresolution.common.config.Config;
import io.homo.superresolution.common.config.ConfigFile;
import io.homo.superresolution.common.config.enums.CaptureMode;
import io.homo.superresolution.common.config.special.SpecialConfig;
import io.homo.superresolution.common.config.special.SpecialConfigDescription;
import io.homo.superresolution.common.debug.PerformanceInfo;
import io.homo.superresolution.common.gui.ConfigScreenBuilder;
import io.homo.superresolution.common.gui.InfoBuilder;
import io.homo.superresolution.common.gui.entries.ClothButtonEntry;
import io.homo.superresolution.common.gui.entries.ClothTextListEntry;
import io.homo.superresolution.common.gui.entries.ClothTextListListEntry;
import io.homo.superresolution.common.gui.widgets.Line;
import io.homo.superresolution.common.minecraft.MinecraftRenderHandle;
import io.homo.superresolution.common.platform.OSType;
import io.homo.superresolution.common.platform.Platform;
import io.homo.superresolution.common.upscale.AlgorithmDescriptions;
import io.homo.superresolution.common.upscale.AlgorithmManager;
import io.homo.superresolution.core.GraphicsCapabilities;
import io.homo.superresolution.core.impl.Pair;
import io.homo.superresolution.core.interop.GlVkInteropManager;
import io.homo.superresolution.core.utils.ColorUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.api.Requirement;
import me.shedaniel.clothconfig2.api.ValueHolder;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.gui.entries.SelectionListEntry;
import me.shedaniel.clothconfig2.impl.ConfigEntryBuilderImpl;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.StringFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.TextDescriptionBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class ClothConfig {
    private static int getInt(float v) {
        return (int)((double)v * 10000.0);
    }

    private static int getInt(double v) {
        return (int)(v * 10000.0);
    }

    private static float getFloat(int v) {
        return (float)((double)v / 10000.0);
    }

    public static void addSpecialConfig(ConfigBuilder builder, ConfigEntryBuilder entryBuilder, String key) {
        Pair<SpecialConfig, String> specialConfigDescription = Config.getInstance().getSpecial().description.get(key);
        Map<String, SpecialConfigDescription<?>> configDescriptions = specialConfigDescription.left().getDescriptions();
        Set<String> keys = configDescriptions.keySet();
        if (keys.isEmpty()) {
            return;
        }
        ConfigCategory category = builder.getOrCreateCategory((Component)Component.literal((String)specialConfigDescription.right()));
        for (String configKey : keys) {
            StringFieldBuilder fieldBuilder;
            SpecialConfigDescription<?> configDescription = configDescriptions.get(configKey);
            switch (configDescription.getType()) {
                default: {
                    throw new MatchException(null, null);
                }
                case ENUM: {
                    StringFieldBuilder stringFieldBuilder = entryBuilder.startEnumSelector(configDescription.getName(), configDescription.getClazz(), (Enum)configDescription.getValue()).setDefaultValue((Enum)configDescription.getDefaultValue()).setSaveConsumer(configDescription.getSaveConsumer_()).setEnumNameProvider(configDescription.isNameIsSupplier() ? anEnum -> configDescription.getNameSupplier().apply(anEnum).orElse((Component)Component.empty()) : null);
                    break;
                }
                case FLOAT: {
                    StringFieldBuilder stringFieldBuilder = entryBuilder.startIntSlider(configDescription.getName(), ClothConfig.getInt(((Float)configDescription.getValue()).floatValue()), ClothConfig.getInt(((Float)configDescription.getValueRange().left()).floatValue()), ClothConfig.getInt(((Float)configDescription.getValueRange().right()).floatValue())).setTextGetter(configDescription.isNameIsSupplier() ? integer -> configDescription.getNameSupplier().apply(integer).orElse((Component)Component.empty()) : integer -> Component.literal((String)String.format("%.2f", Float.valueOf(ClothConfig.getFloat(integer))))).setDefaultValue(ClothConfig.getInt(((Float)configDescription.getDefaultValue()).floatValue())).setSaveConsumer(integer -> configDescription.getSaveConsumer().accept(integer));
                    break;
                }
                case STRING: {
                    StringFieldBuilder stringFieldBuilder = entryBuilder.startStrField(configDescription.getName(), (String)configDescription.getValue()).setDefaultValue((String)configDescription.getDefaultValue()).setSaveConsumer(configDescription.getSaveConsumer_());
                    break;
                }
                case BOOLEAN: {
                    StringFieldBuilder stringFieldBuilder = ((BooleanToggleBuilder)entryBuilder.startBooleanToggle(configDescription.getName(), ((Boolean)configDescription.getValue()).booleanValue()).setYesNoTextSupplier(configDescription.isNameIsSupplier() ? aBoolean -> configDescription.getNameSupplier().apply(aBoolean).orElse((Component)Component.empty()) : null).setDefaultValue((Object)((Boolean)configDescription.getDefaultValue()))).setSaveConsumer(configDescription.getSaveConsumer_());
                    break;
                }
                case OBJECT: {
                    StringFieldBuilder stringFieldBuilder = fieldBuilder = null;
                }
            }
            if (configDescription.getTooltip() != null && fieldBuilder != null) {
                fieldBuilder.setTooltip(new Component[]{configDescription.getTooltip()});
            }
            if (fieldBuilder == null) continue;
            category.addEntry(fieldBuilder.build());
        }
    }

    public static void addDebug(ConfigBuilder builder, ConfigEntryBuilder entryBuilder) {
        ConfigCategory debugCategory = builder.getOrCreateCategory((Component)Component.translatable((String)"superresolution.screen.config.category.debug"));
        debugCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"superresolution.screen.config.options.label.debug_dump_shader"), Config.getInstance().isDebugDumpShader()).setDefaultValue(false).setTooltip(new Component[]{Component.translatable((String)"superresolution.screen.config.options.tooltip.debug_dump_shader")}).setSaveConsumer(Config.getInstance()::setDebugDumpShader).build());
        debugCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"superresolution.screen.config.options.label.enable_renderdoc"), Config.getInstance().isEnableRenderDoc()).setDefaultValue(true).setTooltip(new Component[]{Component.translatable((String)"superresolution.screen.config.options.tooltip.enable_renderdoc")}).setSaveConsumer(Config.getInstance()::setEnableRenderDoc).build());
        debugCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"superresolution.screen.config.options.label.enable_imgui"), Config.getInstance().isEnableImgui()).setDefaultValue(true).setTooltip(new Component[]{Component.translatable((String)"superresolution.screen.config.options.tooltip.enable_imgui")}).setSaveConsumer(Config.getInstance()::setEnableImgui).build());
        ClothTextListEntry debugInfo = new ClothTextListEntry((Component)Component.translatable((String)"superresolution.screen.debug.performance_info"), () -> Component.translatable((String)"superresolution.screen.debug.performance_data", (Object[])new Object[]{BigDecimal.valueOf(PerformanceInfo.getAsMillis("runTick")).setScale(3, RoundingMode.HALF_UP), Minecraft.getInstance().level != null ? BigDecimal.valueOf(PerformanceInfo.getAsMillis("world") - PerformanceInfo.getAsMillis("upscale")).setScale(3, RoundingMode.HALF_UP) : "?", Minecraft.getInstance().level != null ? BigDecimal.valueOf(PerformanceInfo.getAsMillis("upscale")).setScale(3, RoundingMode.HALF_UP) : "?"}), ColorUtil.color(255, 255, 255, 255), null);
        debugCategory.addEntry((AbstractConfigListEntry)debugInfo);
    }

    public static void add(ConfigBuilder builder) {
        ConfigCategory commonCategory = builder.getOrCreateCategory((Component)Component.translatable((String)"superresolution.screen.config.category.general"));
        ConfigEntryBuilderImpl entryBuilder = ConfigEntryBuilderImpl.create();
        if (Platform.currentPlatform.getOS().type == OSType.ANDROID) {
            commonCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.translatable((String)"superresolution.screen.config.warn.mobile_device")).setColor(ColorUtil.color(255, 255, 0, 0)).build());
        }
        commonCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"superresolution.screen.config.options.label.enable_upscale"), Config.isEnableUpscale()).setTooltip(new Component[]{Component.translatable((String)"superresolution.screen.config.options.tooltip.enable_upscale")}).setDefaultValue(true).setSaveConsumer(Config::setEnableUpscale).build());
        commonCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.translatable((String)"superresolution.screen.config.options.label.upscale_ratio"), ClothConfig.getInt(Config.getUpscaleRatio()), ClothConfig.getInt(Config.getMinUpscaleRatio()), ClothConfig.getInt(4.0f)).setDefaultValue(ClothConfig.getInt(1.7)).setTextGetter(integer -> Component.literal((String)String.format("%.2f", Float.valueOf(ClothConfig.getFloat(integer))))).setTooltipSupplier(integer -> {
            float value = ClothConfig.getFloat(integer);
            return Optional.of(new Component[]{Component.literal((String)Component.translatable((String)"superresolution.screen.config.options.tooltip.upscale_ratio").getString().formatted((int)((float)MinecraftRenderHandle.getScreenWidth() / value), (int)((float)MinecraftRenderHandle.getScreenHeight() / value), (int)(1.0f / value * 100.0f) + "%"))});
        }).setSaveConsumer(i -> Config.setUpscaleRatio(ClothConfig.getFloat(i))).build());
        commonCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.translatable((String)"superresolution.screen.config.options.label.sharpness"), ClothConfig.getInt(Config.getSharpness()), ClothConfig.getInt(0.0), ClothConfig.getInt(1.0)).setTooltip(new Component[]{Component.translatable((String)"superresolution.screen.config.options.tooltip.sharpness")}).setDefaultValue(ClothConfig.getInt(0.55)).setTextGetter(integer -> Component.literal((String)String.format("%.2f", Float.valueOf(ClothConfig.getFloat(integer))))).setSaveConsumer(i -> Config.setSharpness(ClothConfig.getFloat(i))).build());
        SelectionListEntry algorithmSelector = entryBuilder.startSelector((Component)Component.translatable((String)"superresolution.screen.config.options.label.algo_type"), AlgorithmRegistry.getAlgorithmMap().values().toArray(), Config.getUpscaleAlgo()).setDefaultValue(AlgorithmDescriptions.FSR1).setNameProvider(anEnum -> Component.literal((String)((AlgorithmDescription)anEnum).getBriefName())).setErrorSupplier(algorithmType -> {
            if (Platform.currentPlatform.isDevelopmentEnvironment() || Platform.currentPlatform.getModVersionString("super_resolution").contains("dev")) {
                return Optional.empty();
            }
            if (!((AlgorithmDescription)algorithmType).getRequirement().check().support()) {
                return Optional.of(Component.literal((String)"\u5f53\u524d\u73af\u5883\u4e0d\u652f\u6301\u8be5\u7b97\u6cd5"));
            }
            return Optional.empty();
        }).setSaveConsumer(o -> Config.setUpscaleAlgo((AlgorithmDescription)o)).build();
        commonCategory.addEntry((AbstractConfigListEntry)algorithmSelector);
        commonCategory.addEntry((AbstractConfigListEntry)((TextDescriptionBuilder)entryBuilder.startTextDescription((Component)Component.translatable((String)"superresolution.screen.config.warn.algorithm_unstable")).setColor(ColorUtil.color(255, 255, 128, 0)).setDisplayRequirement(Requirement.isValue((ValueHolder)algorithmSelector, AlgorithmDescriptions.FSR2, (Object[])new Object[]{AlgorithmDescriptions.NIS, AlgorithmDescriptions.SGSR2}))).build());
        commonCategory.addEntry((AbstractConfigListEntry)((TextDescriptionBuilder)entryBuilder.startTextDescription((Component)Component.translatable((String)"superresolution.screen.config.warn.algorithm_incomplete")).setColor(ColorUtil.color(255, 255, 0, 0)).setDisplayRequirement(Requirement.isValue((ValueHolder)algorithmSelector, AlgorithmDescriptions.NIS, (Object[])new Object[0]))).build());
        EnumListEntry captureModeEnumSelector = entryBuilder.startEnumSelector((Component)Component.translatable((String)"superresolution.screen.config.options.label.capture_mode"), CaptureMode.class, (Enum)Config.getCaptureMode()).setDefaultValue((Enum)CaptureMode.A).setErrorSupplier(captureMode -> {
            if (Platform.currentPlatform.getMinecraftVersion().equals("1.21.4") && captureMode == CaptureMode.B || Platform.currentPlatform.getMinecraftVersion().equals("1.21.5") && captureMode == CaptureMode.C) {
                return Optional.of(Component.literal((String)"\u5f53\u524d\u7684\u6355\u83b7\u65b9\u5f0f\u5728 %s \u65e0\u6cd5\u4f7f\u7528".formatted(Platform.currentPlatform.getMinecraftVersion())));
            }
            return Optional.empty();
        }).setTooltipSupplier(captureMode -> Optional.of(new Component[]{captureMode.get()})).setSaveConsumer(Config::setCaptureMode).build();
        commonCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"superresolution.screen.config.options.label.generate_motion_vectors"), Config.isGenerateMotionVectors()).setTooltip(new Component[]{Component.translatable((String)"superresolution.screen.config.options.tooltip.generate_motion_vectors")}).setDefaultValue(false).setSaveConsumer(Config::setGenerateMotionVectors).build());
        commonCategory.addEntry((AbstractConfigListEntry)captureModeEnumSelector);
        commonCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"superresolution.screen.config.options.label.skip_init_vulkan"), Config.isSkipInitVulkan()).setTooltip(new Component[]{Component.translatable((String)"superresolution.screen.config.options.tooltip.skip_init_vulkan")}).setSaveConsumer(Config::setSkipInitVulkan).requireRestart().build());
        commonCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"superresolution.screen.config.options.label.pause_game_on_gui"), Config.isPauseGameOnGui()).setSaveConsumer(Config::setPauseGameOnGui).build());
        commonCategory.addEntry((AbstractConfigListEntry)new ClothButtonEntry((Component)Component.translatable((String)"superresolution.screen.config.button.label.info"), button -> Minecraft.getInstance().setScreen(ConfigScreenBuilder.create().buildInfoScreen(Minecraft.getInstance().screen)), true));
        for (String key : Config.getInstance().getSpecial().description.keySet()) {
            ClothConfig.addSpecialConfig(builder, (ConfigEntryBuilder)entryBuilder, key);
        }
        ClothConfig.addDebug(builder, (ConfigEntryBuilder)entryBuilder);
        builder.setSavingRunnable(ConfigFile::write);
    }

    public static void addInfos(ConfigBuilder builder) {
        ConfigCategory envInfoCategory = builder.getOrCreateCategory((Component)Component.translatable((String)"superresolution.screen.info.title.env_info"));
        ClothTextListListEntry envInfoEntry = new ClothTextListListEntry((Component)Component.empty(), null, false).setTop(4).setBottom(7);
        InfoBuilder.of(envInfoEntry).addEnvInfo();
        ClothTextListListEntry glExtInfoEntry = new ClothTextListListEntry((Component)Component.translatable((String)"superresolution.screen.info.button.label.opengl_ext_info").append(" ").append(Component.translatable((String)"superresolution.screen.info.text.opengl_ext_count").getString().formatted(GraphicsCapabilities.getGLExtensions().size())), null, true).setTop(4).setBottom(7);
        InfoBuilder.of(glExtInfoEntry).addGlExt();
        ClothTextListListEntry vkExtInfoEntry = null;
        if (GlVkInteropManager.isSupportVulkan()) {
            vkExtInfoEntry = new ClothTextListListEntry((Component)Component.translatable((String)"superresolution.screen.info.button.label.vulkan_ext_info").append(" ").append(Component.translatable((String)"superresolution.screen.info.text.vulkan_ext_count").getString().formatted(GraphicsCapabilities.getVulkanDeviceExtensions().size())), null, true).setTop(4).setBottom(7);
            InfoBuilder.of(vkExtInfoEntry).addVkExt();
        }
        envInfoCategory.addEntry((AbstractConfigListEntry)envInfoEntry);
        envInfoCategory.addEntry((AbstractConfigListEntry)glExtInfoEntry);
        if (GlVkInteropManager.isSupportVulkan()) {
            envInfoCategory.addEntry(vkExtInfoEntry);
        }
        ConfigCategory algoInfoCategory = builder.getOrCreateCategory((Component)Component.translatable((String)"superresolution.screen.info.text.algo_support_status"));
        for (AlgorithmDescription<?> algorithmDescription : AlgorithmRegistry.getAlgorithmMap().values()) {
            if (algorithmDescription.equals(AlgorithmDescriptions.NONE)) continue;
            ClothTextListListEntry algoInfoEntry = new ClothTextListListEntry((Component)MutableComponent.create((ComponentContents)Component.literal((String)algorithmDescription.getDisplayName()).getContents()).withStyle(Style.EMPTY.withColor(AlgorithmManager.isSupportAlgorithm(algorithmDescription) ? ColorUtil.color(255, 255, 255, 255) : ColorUtil.color(255, 255, 0, 0))), null, true).setTop(4).setBottom(7);
            InfoBuilder.of(algoInfoEntry).addAlgoInfo(algorithmDescription);
            algoInfoCategory.addEntry((AbstractConfigListEntry)algoInfoEntry);
        }
        ConfigCategory projectInfoCategory = builder.getOrCreateCategory((Component)Component.translatable((String)"superresolution.screen.info.title.project_info"));
        ClothTextListListEntry contributorsEntry = new ClothTextListListEntry((Component)Component.translatable((String)"superresolution.screen.info.text.contributors"), null, true).setTop(4).setBottom(7);
        String[] contributors = new String[]{"187J3X1 - \u6838\u5fc3\u5f00\u53d1+\u9020\u997c\u5927\u738b", "\u5f02\u4e16\u754c\u7f8e\u897f\u8788 - \u6d4b\u8bd5\u53cd\u9988+\u5409\u7965\u7269+\u5927\u997c\u89c4\u5212\u8005", "yu - \u7ed8\u5236\u56fe\u6807"};
        LinkedHashMap<String, String> libraries = new LinkedHashMap<String, String>(){
            {
                this.put("Cloth Config", "https://github.com/shedaniel/cloth-config");
                this.put("Architectury API", "https://github.com/architectury/architectury-api");
                this.put("SpongePowered Mixin", "https://github.com/SpongePowered/Mixin");
                this.put("Dear ImGui", "https://github.com/ocornut/imgui");
                this.put("Snapdragon\u2122 Game Super Resolution 2(1)", "https://github.com/SnapdragonStudios/snapdragon-gsr");
                this.put("FidelityFX Super Resolution 1.0", "https://github.com/GPUOpen-Effects/FidelityFX-FSR");
                this.put("FidelityFX Super Resolution 2.2", "https://github.com/GPUOpen-Effects/FidelityFX-FSR2");
                this.put("NVIDIA Image Scaling SDK v1.0.3", "https://github.com/NVIDIAGameWorks/NVIDIAImageScaling");
                this.put("Java OpenGL Math Library(JOML)", "https://github.com/JOML-CI/JOML");
                this.put("RenderDoc", "https://github.com/baldurk/renderdoc");
                this.put("Lightweight Java Game Library 3(LWJGL3)", "https://github.com/LWJGL/lwjgl3");
                this.put("Glslang", "https://github.com/KhronosGroup/glslang");
            }
        };
        LinkedHashMap<String, String> officialLinks = new LinkedHashMap<String, String>(){
            {
                this.put(Component.translatable((String)"superresolution.screen.info.link.official_website").getString(), "https://minecraft-superresolution.netlify.app/");
                this.put(Component.translatable((String)"superresolution.screen.info.link.github_repo").getString(), "https://github.com/187J3X1-114514/superresolution");
                this.put(Component.translatable((String)"superresolution.screen.info.link.issue_tracker").getString(), "https://github.com/187J3X1-114514/superresolution/issues");
                this.put(Component.translatable((String)"superresolution.screen.info.link.mcmod_homepage").getString(), "https://www.mcmod.cn/class/17888.html");
            }
        };
        ClothTextListListEntry webLinksEntry = new ClothTextListListEntry((Component)Component.translatable((String)"superresolution.screen.info.text.website_links"), null, true).setTop(4).setBottom(7);
        webLinksEntry.addLine(new Line().text((Component)Component.translatable((String)"superresolution.screen.info.text.website_links")).color(0, 122, 204, 255).center(true));
        officialLinks.forEach((title, url) -> webLinksEntry.addLine(new Line().text((Component)Component.literal((String)title).withStyle(Style.EMPTY.withColor(-12409355).withClickEvent(ClothConfig.createURLClickEvent(url))).append((Component)Component.literal((String)" - ")).append((Component)Component.literal((String)url).withStyle(Style.EMPTY.withColor(ColorUtil.color(255, 150, 150, 150)).withUnderlined(Boolean.valueOf(true)).withClickEvent(ClothConfig.createURLClickEvent(url)))))));
        contributorsEntry.addLine(new Line().text((Component)Component.translatable((String)"superresolution.screen.info.text.contributors")).color(255, 200, 100, 255).center(true));
        for (String contributor : contributors) {
            contributorsEntry.addLine(new Line().text("\u2022 " + contributor).color(255, 255, 255, 255));
        }
        ClothTextListListEntry librariesEntry = new ClothTextListListEntry((Component)Component.translatable((String)"superresolution.screen.info.text.open_source"), null, true).setTop(4).setBottom(7);
        librariesEntry.addLine(new Line().text((Component)Component.translatable((String)"superresolution.screen.info.text.open_source")).color(100, 200, 255, 255).center(true));
        librariesEntry.addLine(new Line().text((Component)Component.translatable((String)"superresolution.screen.info.text.open_source_thank")).color(100, 200, 255, 255).center(true));
        libraries.forEach((name, url) -> {
            librariesEntry.addLine(new Line().text((Component)Component.literal((String)name).withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true)).withColor(-16711936).withClickEvent(ClothConfig.createURLClickEvent(url)))));
            librariesEntry.addLine(new Line().text((Component)Component.literal((String)url).withStyle(Style.EMPTY.withColor(ColorUtil.color(255, 150, 150, 150)).withClickEvent(ClothConfig.createURLClickEvent(url)))));
        });
        projectInfoCategory.addEntry((AbstractConfigListEntry)webLinksEntry);
        projectInfoCategory.addEntry((AbstractConfigListEntry)contributorsEntry);
        projectInfoCategory.addEntry((AbstractConfigListEntry)librariesEntry);
    }

    private static ClickEvent createURLClickEvent(String url) {
        return new ClickEvent(ClickEvent.Action.OPEN_URL, url);
    }
}

