/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft;

import io.homo.superresolution.common.minecraft.HandRenderTarget;
import io.homo.superresolution.common.minecraft.MinecraftRenderTargetWrapper;
import io.homo.superresolution.common.mixin.core.accessor.LevelRendererAccessor;
import io.homo.superresolution.core.impl.framebuffer.IFrameBuffer;
import java.util.function.Function;
import net.minecraft.client.renderer.LevelRenderer;

public enum MinecraftRenderTargetType {
    ENTITY(levelRenderer -> MinecraftRenderTargetWrapper.of(((LevelRendererAccessor)levelRenderer).getEntityRenderTarget())),
    TRANSLUCENT(levelRenderer -> MinecraftRenderTargetWrapper.of(levelRenderer.getTranslucentTarget())),
    ITEM_ENTITY(levelRenderer -> MinecraftRenderTargetWrapper.of(levelRenderer.getItemEntityTarget())),
    PARTICLES(levelRenderer -> MinecraftRenderTargetWrapper.of(levelRenderer.getParticlesTarget())),
    WEATHER(levelRenderer -> MinecraftRenderTargetWrapper.of(levelRenderer.getWeatherTarget())),
    CLOUDS(levelRenderer -> MinecraftRenderTargetWrapper.of(levelRenderer.getCloudsTarget())),
    HAND(levelRenderer -> HandRenderTarget.getHandRenderTarget());

    private final Function<LevelRenderer, IFrameBuffer> callback;

    private MinecraftRenderTargetType(Function<LevelRenderer, IFrameBuffer> callback) {
        this.callback = callback;
    }

    public IFrameBuffer get(LevelRenderer levelRenderer) {
        return this.callback.apply(levelRenderer);
    }
}

