/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.mixin.core;

import com.mojang.blaze3d.pipeline.RenderTarget;
import io.homo.superresolution.common.minecraft.CallType;
import io.homo.superresolution.common.minecraft.MinecraftRenderHandle;
import io.homo.superresolution.common.upscale.AlgorithmManager;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.PostChain;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    @Inject(at={@At(value="HEAD")}, method={"initOutline()V"})
    private void onInitOutline(CallbackInfo ci) {
        MinecraftRenderHandle.onInitEntityEffectBegin();
    }

    @Inject(at={@At(value="RETURN")}, method={"initOutline()V"})
    private void onInitOutlineEnd(CallbackInfo ci) {
        MinecraftRenderHandle.onInitEntityEffectEnd();
    }

    @Redirect(at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/pipeline/RenderTarget;blitToScreen(IIZ)V"), method={"doEntityOutline()V"})
    private void fixEntityOutlineEffect(RenderTarget instance, int width, int height, boolean disableBlend) {
        MinecraftRenderHandle.onBlitEntityEffect();
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/PostChain;resize(II)V"), method={"resize(II)V"})
    private void onResizePostChain(PostChain instance, int w, int h) {
        instance.resize(MinecraftRenderHandle.getRenderWidth(), MinecraftRenderHandle.getRenderHeight());
    }

    @Inject(at={@At(value="HEAD")}, method={"renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"})
    private void renderLevel_MC_1_21_1(DeltaTracker deltaTracker, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f frustumMatrix, Matrix4f projectionMatrix, CallbackInfo ci) {
        AlgorithmManager.setMatrix(projectionMatrix, frustumMatrix);
    }

    @Inject(at={@At(value="HEAD")}, method={"renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"})
    private void onRenderWorldBegin(CallbackInfo ci) {
        if (Minecraft.getInstance().level != null) {
            MinecraftRenderHandle.onRenderWorldBegin(CallType.LEVEL_RENDERER);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"})
    private void onRenderWorldEnd(CallbackInfo ci) {
        if (Minecraft.getInstance().level != null) {
            MinecraftRenderHandle.onRenderWorldEnd(CallType.LEVEL_RENDERER);
        }
    }
}

