/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.mixin.core;

import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.debug.PerformanceInfo;
import io.homo.superresolution.common.minecraft.MinecraftRenderHandle;
import net.minecraft.client.Minecraft;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public class MinecraftMixin {
    @Unique
    private int super_resolution$cacheWidth = 0;
    @Unique
    private int super_resolution$cacheHeight = 0;

    @Inject(at={@At(value="RETURN")}, method={"onGameLoadFinished(Lnet/minecraft/client/Minecraft$GameLoadCookie;)V"})
    private void onLoadDone(CallbackInfo ci) {
        SuperResolution.check();
        SuperResolution.gameIsLoad = true;
    }

    @Inject(at={@At(value="HEAD")}, method={"runTick(Z)V"})
    private void onRenderBegin(CallbackInfo ci) {
        if (this.super_resolution$cacheWidth != MinecraftRenderHandle.getScreenWidth() || this.super_resolution$cacheHeight != MinecraftRenderHandle.getScreenHeight()) {
            this.super_resolution$cacheWidth = MinecraftRenderHandle.getScreenWidth();
            this.super_resolution$cacheHeight = MinecraftRenderHandle.getScreenHeight();
            Minecraft.getInstance().resizeDisplay();
        }
        PerformanceInfo.begin("runTick");
    }

    @Inject(at={@At(value="RETURN")}, method={"runTick(Z)V"})
    private void onRenderEnd(CallbackInfo ci) {
        PerformanceInfo.end("runTick");
    }

    @Inject(at={@At(value="HEAD")}, method={"destroy()V"})
    private void onExit(CallbackInfo ci) {
        SuperResolution.getInstance().destroy();
    }
}

