/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.mixin.core;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import io.homo.superresolution.common.minecraft.MinecraftRenderHandle;
import io.homo.superresolution.common.mixin.core.accessor.PostChainAccessor;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PostChain.class})
public abstract class PostChainMixin {
    @Shadow
    @Final
    private List<PostPass> passes;
    @Shadow
    @Final
    private Map<String, RenderTarget> customRenderTargets;
    @Shadow
    @Final
    private RenderTarget screenTarget;

    @Inject(method={"<init>(Lnet/minecraft/client/renderer/texture/TextureManager;Lnet/minecraft/server/packs/resources/ResourceProvider;Lcom/mojang/blaze3d/pipeline/RenderTarget;Lnet/minecraft/resources/ResourceLocation;)V"}, at={@At(value="TAIL")})
    public void onInitPostChain(TextureManager textureManager, ResourceProvider resourceProvider, RenderTarget screenTarget, ResourceLocation resourceLocation, CallbackInfo ci) throws IOException, JsonSyntaxException {
        if (!screenTarget.equals(MinecraftRenderHandle.getOriginRenderTarget().asMcRenderTarget())) {
            return;
        }
        this.passes.forEach(PostPass::close);
        this.passes.clear();
        this.customRenderTargets.values().forEach(RenderTarget::destroyBuffers);
        this.customRenderTargets.clear();
        ((PostChainAccessor)((Object)this)).setScreenTarget(MinecraftRenderHandle.getRenderTarget().asMcRenderTarget());
        this.updateOrthoMatrix();
        this.load(textureManager, resourceLocation);
    }

    @Shadow
    public abstract void resize(int var1, int var2);

    @Shadow
    protected abstract void updateOrthoMatrix();

    @Shadow
    protected abstract void load(TextureManager var1, ResourceLocation var2) throws IOException, JsonSyntaxException;

    @Inject(method={"resize(II)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onResize(int width, int height, CallbackInfo ci) {
        if (width != MinecraftRenderHandle.getRenderWidth() || height != MinecraftRenderHandle.getRenderHeight()) {
            this.resize(MinecraftRenderHandle.getRenderWidth(), MinecraftRenderHandle.getRenderHeight());
            ci.cancel();
        }
    }

    @Inject(method={"process(F)V"}, at={@At(value="HEAD")})
    public void onProcess(float partialTicks, CallbackInfo ci) {
        MinecraftRenderHandle.fixPostChain((PostChain)this);
    }
}

