/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.interop;

import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.config.Config;
import io.homo.superresolution.core.impl.Destroyable;
import io.homo.superresolution.core.utils.FileReadHelper;
import io.homo.superresolution.core.vulkan.VkApplication;
import io.homo.superresolution.core.vulkan.VkException;
import io.homo.superresolution.core.vulkan.shader.VkComputeShader;
import io.homo.superresolution.core.vulkan.shader.VkShaderUniform;
import io.homo.superresolution.core.vulkan.shader.VkShaderUniformType;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VkDevice;

public class GlVkInteropManager
implements Destroyable {
    public VkApplication vulkanApp;
    public boolean supportVulkan = false;

    public static void main(String[] args) {
        GLFW.glfwInit();
        GLFW.glfwWindowHint((int)139265, (int)0);
        GlVkInteropManager a = new GlVkInteropManager();
        a.init();
        GLFW.glfwWindowHint((int)139265, (int)196609);
        long window = GLFW.glfwCreateWindow((int)854, (int)480, (CharSequence)"test", (long)0L, (long)0L);
        VkComputeShader s = new VkComputeShader(a.vulkanApp.deviceManager);
        VkShaderUniform bufferUni = new VkShaderUniform().binding(0).type(VkShaderUniformType.buffer).size(256);
        s.addUniform(bufferUni);
        s.addUniform(new VkShaderUniform().binding(1).type(VkShaderUniformType.sampler).sampler(a.vulkanApp.deviceManager.textureSampler));
        s.addUniform(new VkShaderUniform().binding(2).type(VkShaderUniformType.sampledImage));
        s.addUniform(new VkShaderUniform().binding(3).type(VkShaderUniformType.storageImage));
        s.addUniform(new VkShaderUniform().binding(4).type(VkShaderUniformType.sampledImage));
        s.addUniform(new VkShaderUniform().binding(5).type(VkShaderUniformType.sampledImage));
        s.setShaderBin(FileReadHelper.readSpvFile("/shader/nis_scaler_glsl.spv"));
        s.build();
        while (!GLFW.glfwWindowShouldClose((long)window)) {
            VK10.vkDeviceWaitIdle((VkDevice)a.vulkanApp.deviceManager.device);
            GLFW.glfwPollEvents();
        }
    }

    public static boolean isSupportVulkan() {
        if (SuperResolution.interopManager != null && !Config.isSkipInitVulkan() && SuperResolution.interopManager.supportVulkan) {
            return SuperResolution.interopManager.vulkanApp != null;
        }
        return false;
    }

    public void init() {
        block6: {
            if (Config.isSkipInitVulkan()) {
                return;
            }
            try {
                VK.create();
            }
            catch (Error | Exception e) {
                if (e.getMessage().contains("Vulkan has already been created")) break block6;
                this.supportVulkan = false;
                VkApplication.LOGGER.error("Vulkan\u521d\u59cb\u5316\u5931\u8d25\uff0c\u4f3c\u4e4e\u7f3a\u5c11Vulkan\u8fd0\u884c\u5e93\uff0c\u9519\u8bef {}", (Object)e.getMessage());
                return;
            }
        }
        this.vulkanApp = VkApplication.create().addInstanceRequiredExtensions("VK_KHR_external_semaphore_capabilities").addInstanceRequiredExtensions("VK_KHR_external_memory_capabilities").addInstanceRequiredExtensions("VK_EXT_debug_utils").addDeviceRequiredExtensions("VK_KHR_external_semaphore").addDeviceRequiredExtensions("VK_KHR_external_memory").addDeviceRequiredExtensions("VK_KHR_external_memory_win32").addDeviceRequiredExtensions("VK_KHR_external_semaphore_win32").addDeviceRequiredExtensions("VK_KHR_dedicated_allocation");
        try {
            this.vulkanApp.init();
            this.supportVulkan = true;
            return;
        }
        catch (VkException vkException) {
            VkApplication.LOGGER.error("Vulkan\u521d\u59cb\u5316\u5931\u8d25\uff0c\u5df2\u7981\u7528Vulkan\uff0c\u9519\u8bef {}", (Object)vkException.getMessage());
        }
        catch (Exception e) {
            VkApplication.LOGGER.error("Vulkan\u521d\u59cb\u5316\u5931\u8d25\uff0c\u53d1\u751f\u672a\u77e5\u9519\u8bef\uff0c\u5df2\u7981\u7528Vulkan\uff0c\u9519\u8bef {}", (Object)e.getMessage());
        }
        this.supportVulkan = false;
    }

    @Override
    public void destroy() {
        if (this.vulkanApp != null) {
            this.vulkanApp.destroy();
        }
    }
}

