/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.fsr2.struct;

import io.homo.superresolution.core.impl.IUniformStruct;
import io.homo.superresolution.fsr2.Fsr2Context;
import io.homo.superresolution.fsr2.Fsr2Dimensions;
import io.homo.superresolution.fsr2.Fsr2DispatchDescription;
import io.homo.superresolution.fsr2.Fsr2Utils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.system.MemoryStack;

public class Fsr2CBRcas
implements IUniformStruct {
    private final ByteBuffer container = MemoryStack.stackCalloc((int)this.sizeof());

    public Fsr2CBRcas() {
        this.container.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void update(Fsr2Context context, Fsr2DispatchDescription desc, Fsr2Dimensions dims) {
        this.container.clear();
        int[] rcasConfig = new int[4];
        float sharpness = -2.0f * desc.sharpness + 2.0f;
        Fsr2Utils.rcasCon(rcasConfig, sharpness);
        for (int i = 0; i < 4; ++i) {
            this.container.putInt(rcasConfig[i]);
        }
        this.container.position(this.sizeof());
        this.container.flip();
    }

    @Override
    public ByteBuffer container() {
        return this.container.duplicate().rewind();
    }

    @Override
    public int sizeof() {
        return 16;
    }
}

