/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.api.platform;

import com.sun.jna.Platform;
import net.minecraft.class_2561;

public enum SystemArchitecture {
    AARCH64("aarch64"),
    ARM32("arm"),
    X86_64("x86-64"),
    X86("x86"),
    ANY("&^*");

    private final String platformArch;

    private SystemArchitecture(String platformArch) {
        this.platformArch = platformArch;
    }

    public static SystemArchitecture get() {
        String arch = Platform.ARCH;
        for (SystemArchitecture a : SystemArchitecture.values()) {
            if (a == ANY || !a.platformArch.equals(arch)) continue;
            return a;
        }
        return ANY;
    }

    public boolean equals(SystemArchitecture arch) {
        return arch == ANY || SystemArchitecture.get() == arch;
    }

    public String getString() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case AARCH64 -> "aarch64";
            case ARM32 -> "arm32";
            case X86_64 -> "x64";
            case X86 -> "x32";
            case ANY -> class_2561.method_43471((String)"superresolution.requirement.os.any").getString();
        };
    }
}

