/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.sun.jna.Pointer;
import io.homo.superresolution.api.event.LevelRenderEndEvent;
import io.homo.superresolution.api.event.LevelRenderStartEvent;
import io.homo.superresolution.api.platform.Platform;
import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.config.SuperResolutionConfig;
import io.homo.superresolution.common.config.enums.CaptureMode;
import io.homo.superresolution.common.minecraft.CallType;
import io.homo.superresolution.common.minecraft.MinecraftRenderTargetWrapper;
import io.homo.superresolution.common.minecraft.MinecraftWindow;
import io.homo.superresolution.common.minecraft.handler.IMinecraftRenderHandler;
import io.homo.superresolution.common.minecraft.handler.MinecraftRenderHandler;
import io.homo.superresolution.common.minecraft.handler.ShaderCompatHandler;
import io.homo.superresolution.common.mixin.core.accessor.MinecraftAccessor;
import io.homo.superresolution.common.perf.PerformanceRecoder;
import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.impl.framebuffer.IBindableFrameBuffer;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.opengl.GlDebug;
import io.homo.superresolution.core.graphics.renderdoc.RenderDoc;
import net.minecraft.class_276;
import net.minecraft.class_279;
import net.minecraft.class_310;

public class RenderHandlerManager {
    public static boolean needCapture = false;
    public static boolean needCaptureVulkan = false;
    public static boolean needCaptureUpscale = false;
    private static boolean isRenderingWorld;
    private static boolean shouldApplyScale;
    private static class_310 minecraft;
    private static IMinecraftRenderHandler handler;
    public static int frameCount;
    private static IBindableFrameBuffer originRenderTarget;

    public static void initialize() {
        RenderSystem.assertOnRenderThread();
        minecraft = class_310.method_1551();
        originRenderTarget = MinecraftRenderTargetWrapper.of(minecraft.method_1522());
        PerformanceRecoder.initialize();
        RenderHandlerManager.updateHandler();
    }

    public static void resize() {
        RenderHandlerManager.updateHandler();
        handler.resize();
    }

    private static boolean needUpdateHandler() {
        if (handler == null) {
            return true;
        }
        if (handler instanceof MinecraftRenderHandler && ShaderCompatHandler.isShaderPackCompatSuperResolution()) {
            return true;
        }
        return handler instanceof ShaderCompatHandler && !ShaderCompatHandler.isShaderPackCompatSuperResolution();
    }

    private static void updateHandler() {
        if (RenderHandlerManager.needUpdateHandler()) {
            if (handler != null) {
                handler.destroy();
                handler = null;
            }
            handler = ShaderCompatHandler.isShaderPackCompatSuperResolution() ? new ShaderCompatHandler() : new MinecraftRenderHandler();
            minecraft.method_15993();
            handler.initialize();
        }
    }

    public static void onRenderBegin() {
        PerformanceRecoder.beginFrame();
    }

    public static void onRenderEnd() {
        PerformanceRecoder.endFrame();
        ++frameCount;
    }

    public static void onRenderWorldBegin(CallType type) {
        RenderHandlerManager.updateHandler();
        GlDebug.pushGroup(74108435, "MinecraftLevelRender");
        if (SuperResolution.cachedWidth != RenderHandlerManager.getScreenWidth() || SuperResolution.cachedHeight != RenderHandlerManager.getScreenHeight()) {
            SuperResolution.getInstance().resize(RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight());
        }
        if (type == CallType.LEVEL_RENDERER) {
            isRenderingWorld = true;
        }
        if (!RenderHandlerManager.checkRenderWorldCallPos(type)) {
            return;
        }
        PerformanceRecoder.beginWorld();
        shouldApplyScale = true;
        if (needCapture && RenderDoc.renderdoc != null) {
            RenderDoc.renderdoc.StartFrameCapture.call(null, null);
        }
        if (needCaptureVulkan && RenderDoc.renderdoc != null && RenderSystems.vulkan() != null) {
            RenderDoc.renderdoc.StartFrameCapture.call(new Pointer(RenderSystems.vulkan().getVulkanInstance().address()), null);
        }
        if (LevelRenderStartEvent.EVENT.hasEvent()) {
            LevelRenderStartEvent.EVENT.invoker().onLevelRenderStart();
        }
        handler.onRenderWorldBegin(type);
    }

    public static void onRenderWorldEnd(CallType type) {
        if (type == CallType.LEVEL_RENDERER) {
            isRenderingWorld = false;
        }
        if (RenderHandlerManager.checkRenderWorldCallPos(type)) {
            PerformanceRecoder.endWorld();
            handler.onRenderWorldEnd(type);
            if (LevelRenderEndEvent.EVENT.hasEvent()) {
                LevelRenderEndEvent.EVENT.invoker().onLevelRenderEnd();
            }
            if (needCapture && RenderDoc.renderdoc != null) {
                needCapture = false;
                RenderDoc.renderdoc.EndFrameCapture.call(null, null);
            }
            if (needCaptureVulkan && RenderDoc.renderdoc != null && RenderSystems.vulkan() != null) {
                needCaptureVulkan = false;
                RenderDoc.renderdoc.EndFrameCapture.call(new Pointer(RenderSystems.vulkan().getVulkanInstance().address()), null);
            }
            shouldApplyScale = false;
        }
        GlDebug.popGroup();
    }

    public static void onRenderHandBegin() {
        if (RenderHandlerManager.checkRenderHandCallPos()) {
            handler.onRenderHandBegin();
        }
    }

    public static void onRenderHandEnd() {
        if (RenderHandlerManager.checkRenderHandCallPos()) {
            handler.onRenderHandEnd();
        }
    }

    public static void onProcessPostChain(class_279 postChain) {
        RenderHandlerManager.updateHandler();
        handler.onProcessPostChain(postChain);
    }

    public static void needCapture() {
        needCapture = true;
    }

    public static void needCaptureVulkan() {
        needCaptureVulkan = true;
    }

    public static void needCaptureUpscale() {
        needCaptureUpscale = true;
    }

    public static int getFrameCount() {
        return frameCount;
    }

    private static boolean checkRenderWorldCallPos(CallType type) {
        return switch (SuperResolutionConfig.getCaptureMode()) {
            default -> throw new IncompatibleClassChangeError();
            case CaptureMode.A, CaptureMode.C -> {
                if (type == CallType.GAME_RENDERER) {
                    yield true;
                }
                yield false;
            }
            case CaptureMode.B -> type == CallType.LEVEL_RENDERER;
        };
    }

    private static boolean checkRenderHandCallPos() {
        boolean bl;
        block4: {
            switch (SuperResolutionConfig.getCaptureMode()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case A: 
                case B: {
                    break;
                }
                case C: {
                    if (Platform.currentPlatform.iris().isShaderPackInUse()) break;
                    bl = true;
                    break block4;
                }
            }
            bl = false;
        }
        return bl;
    }

    public static void setClientRenderTarget(class_276 renderTarget) {
        if (renderTarget == null) {
            throw new RuntimeException();
        }
        ((MinecraftAccessor)class_310.method_1551()).setRenderTarget(renderTarget);
    }

    public static float getCurrentScaleFactor() {
        return shouldApplyScale && RenderHandlerManager.minecraft.field_1687 != null ? RenderHandlerManager.getScaleFactor() : 1.0f;
    }

    public static float getScaleFactor() {
        return SuperResolutionConfig.isEnableUpscale() ? SuperResolutionConfig.getRenderScaleFactor() : 1.0f;
    }

    public static int getRenderHeight() {
        return (int)Math.max((float)RenderHandlerManager.getScreenHeight() * RenderHandlerManager.getScaleFactor(), 1.0f);
    }

    public static int getRenderWidth() {
        return (int)Math.max((float)RenderHandlerManager.getScreenWidth() * RenderHandlerManager.getScaleFactor(), 1.0f);
    }

    public static int getScreenHeight() {
        return Math.max(MinecraftWindow.getWindowHeight(), 1);
    }

    public static int getScreenWidth() {
        return Math.max(MinecraftWindow.getWindowWidth(), 1);
    }

    public static IBindableFrameBuffer getOriginRenderTarget() {
        return originRenderTarget;
    }

    public static IBindableFrameBuffer getRenderTarget() {
        return handler.getScaledRenderTarget();
    }

    public static ITexture getColorTexture() {
        return handler.getColorTexture();
    }

    public static ITexture getDepthTexture() {
        return handler.getDepthTexture();
    }

    static {
        frameCount = 0;
    }
}

