/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.icyllis.modernui.animation;

import io.homo.superresolution.thirdparty.icyllis.modernui.animation.BezierInterpolator;
import io.homo.superresolution.thirdparty.icyllis.modernui.animation.TimeInterpolator;
import io.homo.superresolution.thirdparty.icyllis.modernui.annotation.NonNull;

public final class MotionEasingUtils {
    @NonNull
    public static final TimeInterpolator FAST_OUT_SLOW_IN = new BezierInterpolator(0.4f, 0.0f, 0.2f, 1.0f);
    @NonNull
    public static final TimeInterpolator FAST_OUT_LINEAR_IN = new BezierInterpolator(0.4f, 0.0f, 1.0f, 1.0f);
    @NonNull
    public static final TimeInterpolator LINEAR_OUT_SLOW_IN = new BezierInterpolator(0.0f, 0.0f, 0.2f, 1.0f);
    @NonNull
    public static final TimeInterpolator MOTION_EASING_STANDARD = new BezierInterpolator(0.2f, 0.0f, 0.0f, 1.0f);
    @NonNull
    public static final TimeInterpolator MOTION_EASING_STANDARD_ACCELERATE = new BezierInterpolator(0.3f, 0.0f, 1.0f, 1.0f);
    @NonNull
    public static final TimeInterpolator MOTION_EASING_STANDARD_DECELERATE = new BezierInterpolator(0.0f, 0.0f, 0.0f, 1.0f);
    @NonNull
    public static final TimeInterpolator MOTION_EASING_EMPHASIZED = BezierInterpolator.createTwoCubic(0.05f, 0.0f, 0.133333f, 0.06f, 0.166666f, 0.4f, 0.208333f, 0.82f, 0.25f, 1.0f);
    @NonNull
    public static final TimeInterpolator MOTION_EASING_EMPHASIZED_ACCELERATE = new BezierInterpolator(0.3f, 0.0f, 0.8f, 0.15f);
    @NonNull
    public static final TimeInterpolator MOTION_EASING_EMPHASIZED_DECELERATE = new BezierInterpolator(0.05f, 0.7f, 0.1f, 1.0f);

    public static float lerp(float startValue, float endValue, float fraction) {
        return startValue + fraction * (endValue - startValue);
    }

    public static int lerp(int startValue, int endValue, float fraction) {
        return startValue + Math.round(fraction * (float)(endValue - startValue));
    }

    public static float lerp(float outputMin, float outputMax, float inputMin, float inputMax, float value) {
        if (value <= inputMin) {
            return outputMin;
        }
        if (value >= inputMax) {
            return outputMax;
        }
        return MotionEasingUtils.lerp(outputMin, outputMax, (value - inputMin) / (inputMax - inputMin));
    }
}

