/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm;

import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaAlign;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDimension;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDirection;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDisplay;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaErrata;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaFlexDirection;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaJustify;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaNode;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaPhysicalEdge;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaPositionType;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaWrap;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.AlignUtil;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.BoundAxis;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.CalculateLayout;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.FlexDirectionUtil;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.SizingMode;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.TrailingPosition;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.event.LayoutData;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.event.LayoutPassReason;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.numeric.Comparison;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.style.YogaStyle;

public class AbsoluteLayout {
    private static void setFlexStartLayoutPosition(YogaNode parent, YogaNode child, YogaDirection direction, YogaFlexDirection axis, float containingBlockWidth) {
        float position = child.getStyle().computeFlexStartMargin(axis, direction, containingBlockWidth) + parent.getLayout().border(FlexDirectionUtil.flexStartEdge(axis));
        if (!child.hasErrata(YogaErrata.ABSOLUTE_POSITION_WITHOUT_INSETS_EXCLUDES_PADDING)) {
            position += parent.getLayout().padding(FlexDirectionUtil.flexStartEdge(axis));
        }
        child.setLayoutPosition(position, FlexDirectionUtil.flexStartEdge(axis));
    }

    private static void setFlexEndLayoutPosition(YogaNode parent, YogaNode child, YogaDirection direction, YogaFlexDirection axis, float containingBlockWidth) {
        float flexEndPosition = parent.getLayout().border(FlexDirectionUtil.flexEndEdge(axis)) + child.getStyle().computeFlexEndMargin(axis, direction, containingBlockWidth);
        if (!child.hasErrata(YogaErrata.ABSOLUTE_POSITION_WITHOUT_INSETS_EXCLUDES_PADDING)) {
            flexEndPosition += parent.getLayout().padding(FlexDirectionUtil.flexEndEdge(axis));
        }
        child.setLayoutPosition(TrailingPosition.getPositionOfOppositeEdge(flexEndPosition, axis, parent, child), FlexDirectionUtil.flexStartEdge(axis));
    }

    private static void setCenterLayoutPosition(YogaNode parent, YogaNode child, YogaDirection direction, YogaFlexDirection axis, float containingBlockWidth) {
        float parentContentBoxSize = parent.getLayout().measuredDimension(FlexDirectionUtil.dimension(axis)) - parent.getLayout().border(FlexDirectionUtil.flexStartEdge(axis)) - parent.getLayout().border(FlexDirectionUtil.flexEndEdge(axis));
        if (!child.hasErrata(YogaErrata.ABSOLUTE_POSITION_WITHOUT_INSETS_EXCLUDES_PADDING)) {
            parentContentBoxSize -= parent.getLayout().padding(FlexDirectionUtil.flexStartEdge(axis));
            parentContentBoxSize -= parent.getLayout().padding(FlexDirectionUtil.flexEndEdge(axis));
        }
        float childOuterSize = child.getLayout().measuredDimension(FlexDirectionUtil.dimension(axis)) + child.getStyle().computeMarginForAxis(axis, containingBlockWidth);
        float position = (parentContentBoxSize - childOuterSize) / 2.0f + parent.getLayout().border(FlexDirectionUtil.flexStartEdge(axis)) + child.getStyle().computeFlexStartMargin(axis, direction, containingBlockWidth);
        if (!child.hasErrata(YogaErrata.ABSOLUTE_POSITION_WITHOUT_INSETS_EXCLUDES_PADDING)) {
            position += parent.getLayout().padding(FlexDirectionUtil.flexStartEdge(axis));
        }
        child.setLayoutPosition(position, FlexDirectionUtil.flexStartEdge(axis));
    }

    private static void justifyAbsoluteChild(YogaNode parent, YogaNode child, YogaDirection direction, YogaFlexDirection mainAxis, float containingBlockWidth) {
        YogaJustify parentJustifyContent = parent.getStyle().getJustifyContent();
        switch (parentJustifyContent) {
            case FLEX_START: 
            case SPACE_BETWEEN: {
                AbsoluteLayout.setFlexStartLayoutPosition(parent, child, direction, mainAxis, containingBlockWidth);
                break;
            }
            case FLEX_END: {
                AbsoluteLayout.setFlexEndLayoutPosition(parent, child, direction, mainAxis, containingBlockWidth);
                break;
            }
            case CENTER: 
            case SPACE_AROUND: 
            case SPACE_EVENLY: {
                AbsoluteLayout.setCenterLayoutPosition(parent, child, direction, mainAxis, containingBlockWidth);
            }
        }
    }

    private static void alignAbsoluteChild(YogaNode parent, YogaNode child, YogaDirection direction, YogaFlexDirection crossAxis, float containingBlockWidth) {
        YogaAlign itemAlign = AlignUtil.resolveChildAlignment(parent, child);
        YogaWrap parentWrap = parent.getStyle().getFlexWrap();
        if (parentWrap == YogaWrap.WRAP_REVERSE) {
            if (itemAlign == YogaAlign.FLEX_END) {
                itemAlign = YogaAlign.FLEX_START;
            } else if (itemAlign != YogaAlign.CENTER) {
                itemAlign = YogaAlign.FLEX_END;
            }
        }
        switch (itemAlign) {
            case AUTO: 
            case FLEX_START: 
            case BASELINE: 
            case SPACE_AROUND: 
            case SPACE_BETWEEN: 
            case STRETCH: 
            case SPACE_EVENLY: {
                AbsoluteLayout.setFlexStartLayoutPosition(parent, child, direction, crossAxis, containingBlockWidth);
                break;
            }
            case FLEX_END: {
                AbsoluteLayout.setFlexEndLayoutPosition(parent, child, direction, crossAxis, containingBlockWidth);
                break;
            }
            case CENTER: {
                AbsoluteLayout.setCenterLayoutPosition(parent, child, direction, crossAxis, containingBlockWidth);
            }
        }
    }

    private static void positionAbsoluteChild(YogaNode containingNode, YogaNode parent, YogaNode child, YogaDirection direction, YogaFlexDirection axis, boolean isMainAxis, float containingBlockWidth, float containingBlockHeight) {
        float containingBlockSize;
        boolean isAxisRow = FlexDirectionUtil.isRow(axis);
        float f = containingBlockSize = isAxisRow ? containingBlockWidth : containingBlockHeight;
        if (child.getStyle().isInlineStartPositionDefined(axis, direction) && !child.getStyle().isInlineStartPositionAuto(axis, direction)) {
            float positionRelativeToInlineStart = child.getStyle().computeInlineStartPosition(axis, direction, containingBlockSize) + containingNode.getStyle().computeInlineStartBorder(axis, direction) + child.getStyle().computeInlineStartMargin(axis, direction, containingBlockSize);
            float positionRelativeToFlexStart = FlexDirectionUtil.inlineStartEdge(axis, direction) != FlexDirectionUtil.flexStartEdge(axis) ? TrailingPosition.getPositionOfOppositeEdge(positionRelativeToInlineStart, axis, containingNode, child) : positionRelativeToInlineStart;
            child.setLayoutPosition(positionRelativeToFlexStart, FlexDirectionUtil.flexStartEdge(axis));
        } else if (child.getStyle().isInlineEndPositionDefined(axis, direction) && !child.getStyle().isInlineEndPositionAuto(axis, direction)) {
            float positionRelativeToInlineStart = containingNode.getLayout().measuredDimension(FlexDirectionUtil.dimension(axis)) - child.getLayout().measuredDimension(FlexDirectionUtil.dimension(axis)) - containingNode.getStyle().computeInlineEndBorder(axis, direction) - child.getStyle().computeInlineEndMargin(axis, direction, containingBlockSize) - child.getStyle().computeInlineEndPosition(axis, direction, containingBlockSize);
            float positionRelativeToFlexStart = FlexDirectionUtil.inlineStartEdge(axis, direction) != FlexDirectionUtil.flexStartEdge(axis) ? TrailingPosition.getPositionOfOppositeEdge(positionRelativeToInlineStart, axis, containingNode, child) : positionRelativeToInlineStart;
            child.setLayoutPosition(positionRelativeToFlexStart, FlexDirectionUtil.flexStartEdge(axis));
        } else if (isMainAxis) {
            AbsoluteLayout.justifyAbsoluteChild(parent, child, direction, axis, containingBlockWidth);
        } else {
            AbsoluteLayout.alignAbsoluteChild(parent, child, direction, axis, containingBlockWidth);
        }
    }

    public static void layoutAbsoluteChild(YogaNode containingNode, YogaNode node, YogaNode child, float containingBlockWidth, float containingBlockHeight, SizingMode widthMode, YogaDirection direction, LayoutData layoutMarkerData, int depth, int generationCount) {
        YogaFlexDirection mainAxis = FlexDirectionUtil.resolveDirection(node.getStyle().getFlexDirection(), direction);
        YogaFlexDirection crossAxis = FlexDirectionUtil.resolveCrossDirection(mainAxis, direction);
        boolean isMainAxisRow = FlexDirectionUtil.isRow(mainAxis);
        float childWidth = Float.NaN;
        float childHeight = Float.NaN;
        SizingMode childWidthSizingMode = SizingMode.MAX_CONTENT;
        SizingMode childHeightSizingMode = SizingMode.MAX_CONTENT;
        float marginRow = child.getStyle().computeMarginForAxis(YogaFlexDirection.ROW, containingBlockWidth);
        float marginColumn = child.getStyle().computeMarginForAxis(YogaFlexDirection.COLUMN, containingBlockWidth);
        if (child.hasDefiniteLength(YogaDimension.WIDTH, containingBlockWidth)) {
            childWidth = child.getResolvedDimension(direction, YogaDimension.WIDTH, containingBlockWidth, containingBlockWidth).unwrap() + marginRow;
        } else if (child.getStyle().isFlexStartPositionDefined(YogaFlexDirection.ROW, direction) && child.getStyle().isFlexEndPositionDefined(YogaFlexDirection.ROW, direction) && !child.getStyle().isFlexStartPositionAuto(YogaFlexDirection.ROW, direction) && !child.getStyle().isFlexEndPositionAuto(YogaFlexDirection.ROW, direction)) {
            childWidth = containingNode.getLayout().measuredDimension(YogaDimension.WIDTH) - (containingNode.getStyle().computeFlexStartBorder(YogaFlexDirection.ROW, direction) + containingNode.getStyle().computeFlexEndBorder(YogaFlexDirection.ROW, direction)) - (child.getStyle().computeFlexStartPosition(YogaFlexDirection.ROW, direction, containingBlockWidth) + child.getStyle().computeFlexEndPosition(YogaFlexDirection.ROW, direction, containingBlockWidth));
            childWidth = BoundAxis.boundAxis(child, YogaFlexDirection.ROW, direction, childWidth, containingBlockWidth, containingBlockWidth);
        }
        if (child.hasDefiniteLength(YogaDimension.HEIGHT, containingBlockHeight)) {
            childHeight = child.getResolvedDimension(direction, YogaDimension.HEIGHT, containingBlockHeight, containingBlockWidth).unwrap() + marginColumn;
        } else if (child.getStyle().isFlexStartPositionDefined(YogaFlexDirection.COLUMN, direction) && child.getStyle().isFlexEndPositionDefined(YogaFlexDirection.COLUMN, direction) && !child.getStyle().isFlexStartPositionAuto(YogaFlexDirection.COLUMN, direction) && !child.getStyle().isFlexEndPositionAuto(YogaFlexDirection.COLUMN, direction)) {
            childHeight = containingNode.getLayout().measuredDimension(YogaDimension.HEIGHT) - (containingNode.getStyle().computeFlexStartBorder(YogaFlexDirection.COLUMN, direction) + containingNode.getStyle().computeFlexEndBorder(YogaFlexDirection.COLUMN, direction)) - (child.getStyle().computeFlexStartPosition(YogaFlexDirection.COLUMN, direction, containingBlockHeight) + child.getStyle().computeFlexEndPosition(YogaFlexDirection.COLUMN, direction, containingBlockHeight));
            childHeight = BoundAxis.boundAxis(child, YogaFlexDirection.COLUMN, direction, childHeight, containingBlockHeight, containingBlockWidth);
        }
        YogaStyle childStyle = child.getStyle();
        if (Comparison.isUndefined(childWidth) ^ Comparison.isUndefined(childHeight) && childStyle.getAspectRatio().isDefined()) {
            if (Comparison.isUndefined(childWidth)) {
                childWidth = marginRow + (childHeight - marginColumn) * childStyle.getAspectRatio().unwrap();
            } else if (Comparison.isUndefined(childHeight)) {
                childHeight = marginColumn + (childWidth - marginRow) / childStyle.getAspectRatio().unwrap();
            }
        }
        if (Comparison.isUndefined(childWidth) || Comparison.isUndefined(childHeight)) {
            childWidthSizingMode = Comparison.isUndefined(childWidth) ? SizingMode.MAX_CONTENT : SizingMode.STRETCH_FIT;
            SizingMode sizingMode = childHeightSizingMode = Comparison.isUndefined(childHeight) ? SizingMode.MAX_CONTENT : SizingMode.STRETCH_FIT;
            if (!isMainAxisRow && Comparison.isUndefined(childWidth) && widthMode != SizingMode.MAX_CONTENT && Comparison.isDefined(containingBlockWidth) && containingBlockWidth > 0.0f) {
                childWidth = containingBlockWidth;
                childWidthSizingMode = SizingMode.FIT_CONTENT;
            }
            CalculateLayout.calculateLayoutInternal(child, childWidth, childHeight, direction, childWidthSizingMode, childHeightSizingMode, containingBlockWidth, containingBlockHeight, false, LayoutPassReason.ABS_MEASURE_CHILD, layoutMarkerData, depth, generationCount);
            childWidth = child.getLayout().measuredDimension(YogaDimension.WIDTH) + child.getStyle().computeMarginForAxis(YogaFlexDirection.ROW, containingBlockWidth);
            childHeight = child.getLayout().measuredDimension(YogaDimension.HEIGHT) + child.getStyle().computeMarginForAxis(YogaFlexDirection.COLUMN, containingBlockWidth);
        }
        CalculateLayout.calculateLayoutInternal(child, childWidth, childHeight, direction, SizingMode.STRETCH_FIT, SizingMode.STRETCH_FIT, containingBlockWidth, containingBlockHeight, true, LayoutPassReason.ABS_LAYOUT, layoutMarkerData, depth, generationCount);
        AbsoluteLayout.positionAbsoluteChild(containingNode, node, child, direction, mainAxis, true, containingBlockWidth, containingBlockHeight);
        AbsoluteLayout.positionAbsoluteChild(containingNode, node, child, direction, crossAxis, false, containingBlockWidth, containingBlockHeight);
    }

    public static boolean layoutAbsoluteDescendants(YogaNode containingNode, YogaNode currentNode, SizingMode widthSizingMode, YogaDirection currentNodeDirection, LayoutData layoutMarkerData, int currentDepth, int generationCount, float currentNodeLeftOffsetFromContainingBlock, float currentNodeTopOffsetFromContainingBlock, float containingNodeAvailableInnerWidth, float containingNodeAvailableInnerHeight) {
        boolean hasNewLayout = false;
        for (YogaNode child : currentNode.getLayoutChildren()) {
            float childTopOffsetFromContainingBlock;
            float childLeftOffsetFromContainingBlock;
            if (child.getStyle().getDisplay() == YogaDisplay.NONE) continue;
            if (child.getStyle().getPositionType() == YogaPositionType.ABSOLUTE) {
                boolean absoluteErrata = currentNode.hasErrata(YogaErrata.ABSOLUTE_PERCENT_AGAINST_INNER_SIZE);
                float containingBlockWidth = absoluteErrata ? containingNodeAvailableInnerWidth : containingNode.getLayout().measuredDimension(YogaDimension.WIDTH) - containingNode.getStyle().computeBorderForAxis(YogaFlexDirection.ROW);
                float containingBlockHeight = absoluteErrata ? containingNodeAvailableInnerHeight : containingNode.getLayout().measuredDimension(YogaDimension.HEIGHT) - containingNode.getStyle().computeBorderForAxis(YogaFlexDirection.COLUMN);
                AbsoluteLayout.layoutAbsoluteChild(containingNode, currentNode, child, containingBlockWidth, containingBlockHeight, widthSizingMode, currentNodeDirection, layoutMarkerData, currentDepth, generationCount);
                hasNewLayout = hasNewLayout || child.hasNewLayout();
                YogaFlexDirection parentMainAxis = FlexDirectionUtil.resolveDirection(currentNode.getStyle().getFlexDirection(), currentNodeDirection);
                YogaFlexDirection parentCrossAxis = FlexDirectionUtil.resolveCrossDirection(parentMainAxis, currentNodeDirection);
                if (TrailingPosition.needsTrailingPosition(parentMainAxis)) {
                    boolean mainInsetsDefined = FlexDirectionUtil.isRow(parentMainAxis) ? child.getStyle().horizontalInsetsDefined() : child.getStyle().verticalInsetsDefined();
                    TrailingPosition.setChildTrailingPosition(mainInsetsDefined ? containingNode : currentNode, child, parentMainAxis);
                }
                if (TrailingPosition.needsTrailingPosition(parentCrossAxis)) {
                    boolean crossInsetsDefined = FlexDirectionUtil.isRow(parentCrossAxis) ? child.getStyle().horizontalInsetsDefined() : child.getStyle().verticalInsetsDefined();
                    TrailingPosition.setChildTrailingPosition(crossInsetsDefined ? containingNode : currentNode, child, parentCrossAxis);
                }
                float childLeftPosition = child.getLayout().position(YogaPhysicalEdge.LEFT);
                float childTopPosition = child.getLayout().position(YogaPhysicalEdge.TOP);
                float childLeftOffsetFromParent = child.getStyle().horizontalInsetsDefined() ? childLeftPosition - currentNodeLeftOffsetFromContainingBlock : childLeftPosition;
                float childTopOffsetFromParent = child.getStyle().verticalInsetsDefined() ? childTopPosition - currentNodeTopOffsetFromContainingBlock : childTopPosition;
                child.setLayoutPosition(childLeftOffsetFromParent, YogaPhysicalEdge.LEFT);
                child.setLayoutPosition(childTopOffsetFromParent, YogaPhysicalEdge.TOP);
                continue;
            }
            if (child.getStyle().getPositionType() != YogaPositionType.STATIC || child.alwaysFormsContainingBlock()) continue;
            child.cloneChildrenIfNeeded();
            YogaDirection childDirection = child.resolveDirection(currentNodeDirection);
            hasNewLayout = AbsoluteLayout.layoutAbsoluteDescendants(containingNode, child, widthSizingMode, childDirection, layoutMarkerData, currentDepth + 1, generationCount, childLeftOffsetFromContainingBlock = currentNodeLeftOffsetFromContainingBlock + child.getLayout().position(YogaPhysicalEdge.LEFT), childTopOffsetFromContainingBlock = currentNodeTopOffsetFromContainingBlock + child.getLayout().position(YogaPhysicalEdge.TOP), containingNodeAvailableInnerWidth, containingNodeAvailableInnerHeight) || hasNewLayout;
            if (!hasNewLayout) continue;
            child.setHasNewLayout(hasNewLayout);
        }
        return hasNewLayout;
    }
}

