/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.style;

import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.numeric.FloatOptional;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.style.SmallValueBuffer;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.style.StyleLength;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.style.StyleSizeLength;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.style.StyleValueHandle;

public class StyleValuePool {
    private final SmallValueBuffer buffer = new SmallValueBuffer();

    public void store(StyleValueHandle handle, StyleLength length) {
        if (length.isUndefined()) {
            handle.setType((byte)0);
        } else if (length.isAuto()) {
            handle.setType((byte)4);
        } else {
            byte type = length.isPoints() ? (byte)1 : 2;
            this.storeValue(handle, length.value().unwrap(), type);
        }
    }

    public void store(StyleValueHandle handle, StyleSizeLength sizeValue) {
        if (sizeValue.isUndefined()) {
            handle.setType((byte)0);
        } else if (sizeValue.isAuto()) {
            handle.setType((byte)4);
        } else if (sizeValue.isMaxContent()) {
            this.storeKeyword(handle, StyleValueHandle.Keyword.MAX_CONTENT);
        } else if (sizeValue.isStretch()) {
            this.storeKeyword(handle, StyleValueHandle.Keyword.STRETCH);
        } else if (sizeValue.isFitContent()) {
            this.storeKeyword(handle, StyleValueHandle.Keyword.FIT_CONTENT);
        } else {
            byte type = sizeValue.isPoints() ? (byte)1 : 2;
            this.storeValue(handle, sizeValue.value().unwrap(), type);
        }
    }

    public void store(StyleValueHandle handle, FloatOptional number) {
        if (number.isUndefined()) {
            handle.setType((byte)0);
        } else {
            this.storeValue(handle, number.unwrap(), (byte)3);
        }
    }

    public StyleLength getLength(StyleValueHandle handle) {
        if (handle.isUndefined()) {
            return StyleLength.undefined();
        }
        if (handle.isAuto()) {
            return StyleLength.ofAuto();
        }
        assert (handle.type() == 1 || handle.type() == 2);
        float value = handle.isValueIndexed() ? Float.intBitsToFloat(this.buffer.get32(handle.value())) : StyleValuePool.unpackInlineInteger(handle.value());
        return handle.type() == 1 ? StyleLength.points(value) : StyleLength.percent(value);
    }

    public StyleSizeLength getSize(StyleValueHandle handle) {
        if (handle.isUndefined()) {
            return StyleSizeLength.undefined();
        }
        if (handle.isAuto()) {
            return StyleSizeLength.ofAuto();
        }
        if (handle.isKeyword(StyleValueHandle.Keyword.MAX_CONTENT)) {
            return StyleSizeLength.ofMaxContent();
        }
        if (handle.isKeyword(StyleValueHandle.Keyword.FIT_CONTENT)) {
            return StyleSizeLength.ofFitContent();
        }
        if (handle.isKeyword(StyleValueHandle.Keyword.STRETCH)) {
            return StyleSizeLength.ofStretch();
        }
        assert (handle.type() == 1 || handle.type() == 2);
        float value = handle.isValueIndexed() ? Float.intBitsToFloat(this.buffer.get32(handle.value())) : StyleValuePool.unpackInlineInteger(handle.value());
        return handle.type() == 1 ? StyleSizeLength.points(value) : StyleSizeLength.percent(value);
    }

    public FloatOptional getNumber(StyleValueHandle handle) {
        if (handle.isUndefined()) {
            return FloatOptional.of();
        }
        assert (handle.type() == 3);
        float value = handle.isValueIndexed() ? Float.intBitsToFloat(this.buffer.get32(handle.value())) : StyleValuePool.unpackInlineInteger(handle.value());
        return FloatOptional.of(value);
    }

    private void storeValue(StyleValueHandle handle, float value, byte type) {
        handle.setType(type);
        if (handle.isValueIndexed()) {
            short newIndex = this.buffer.replace(handle.value(), Float.floatToRawIntBits(value));
            handle.setValue(newIndex);
        } else if (StyleValuePool.isIntegerPackable(value)) {
            handle.setValue(StyleValuePool.packInlineInteger(value));
        } else {
            short newIndex = this.buffer.push(Float.floatToRawIntBits(value));
            handle.setValue(newIndex);
            handle.setValueIsIndexed();
        }
    }

    private void storeKeyword(StyleValueHandle handle, StyleValueHandle.Keyword keyword) {
        handle.setType((byte)5);
        if (handle.isValueIndexed()) {
            short newIndex = this.buffer.replace(handle.value(), keyword.ordinal());
            handle.setValue(newIndex);
        } else {
            handle.setValue((short)keyword.ordinal());
        }
    }

    private static boolean isIntegerPackable(float f) {
        int MAX_INLINE_ABS_VALUE = 2047;
        int i = (int)f;
        return (float)i == f && i >= -2047 && i <= 2047;
    }

    private static short packInlineInteger(float value) {
        int isNegative = value < 0.0f ? 1 : 0;
        return (short)(isNegative << 11 | (int)value * (isNegative != 0 ? -1 : 1));
    }

    private static float unpackInlineInteger(short value) {
        int VALUE_SIGN_MASK = 2048;
        int VALUE_MAGNITUDE_MASK = 2047;
        boolean isNegative = (value & 0x800) != 0;
        return (value & 0x7FF) * (isNegative ? -1 : 1);
    }
}

