/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.gui;

import io.homo.superresolution.api.event.ConfigChangedEvent;
import io.homo.superresolution.api.platform.OperatingSystemType;
import io.homo.superresolution.api.platform.Platform;
import io.homo.superresolution.api.registry.AlgorithmDescription;
import io.homo.superresolution.api.registry.AlgorithmRegistry;
import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.config.SuperResolutionConfig;
import io.homo.superresolution.common.config.enums.CaptureMode;
import io.homo.superresolution.common.config.enums.InternalTextureFormat;
import io.homo.superresolution.common.config.special.SpecialConfig;
import io.homo.superresolution.common.config.special.SpecialConfigDescription;
import io.homo.superresolution.common.debug.PerformanceInfo;
import io.homo.superresolution.common.gui.ConfigScreenBuilder;
import io.homo.superresolution.common.gui.InfoBuilder;
import io.homo.superresolution.common.gui.TestOptionBuilder;
import io.homo.superresolution.common.gui.entries.ClothButtonEntry;
import io.homo.superresolution.common.gui.entries.ClothChartEntry;
import io.homo.superresolution.common.gui.entries.ClothTextListEntry;
import io.homo.superresolution.common.gui.entries.ClothTextListListEntry;
import io.homo.superresolution.common.gui.widgets.Line;
import io.homo.superresolution.common.minecraft.handler.RenderHandlerManager;
import io.homo.superresolution.common.minecraft.handler.ShaderCompatHandler;
import io.homo.superresolution.common.perf.PerformanceRecoder;
import io.homo.superresolution.common.upscale.AlgorithmDescriptions;
import io.homo.superresolution.common.upscale.AlgorithmManager;
import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.GraphicsCapabilities;
import io.homo.superresolution.core.gui.WidgetDesignScreen;
import io.homo.superresolution.core.impl.Pair;
import io.homo.superresolution.core.utils.ColorUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.api.Requirement;
import me.shedaniel.clothconfig2.api.ValueHolder;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.gui.entries.SelectionListEntry;
import me.shedaniel.clothconfig2.impl.ConfigEntryBuilderImpl;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.StringFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.TextDescriptionBuilder;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7417;

public class ClothConfig {
    public static void add(ConfigBuilder builder) {
        ConfigCategory commonCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"superresolution.screen.config.category.general"));
        ConfigEntryBuilderImpl entryBuilder = ConfigEntryBuilderImpl.create();
        if (Platform.currentPlatform.getOS().type == OperatingSystemType.ANDROID) {
            commonCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43471((String)"superresolution.screen.config.warn.mobile_device")).setColor(ColorUtil.color(255, 255, 0, 0)).build());
        }
        commonCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"superresolution.screen.config.options.label.enable_upscale"), SuperResolutionConfig.isEnableUpscaleOriginal()).setTooltip(new class_2561[]{class_2561.method_43471((String)"superresolution.screen.config.options.tooltip.enable_upscale")}).setDefaultValue(true).setSaveConsumer(newValue -> {
            boolean oldValue = SuperResolutionConfig.isEnableUpscale();
            SuperResolutionConfig.setEnableUpscale(newValue);
            if (!ShaderCompatHandler.isShaderPackCompatSuperResolution()) {
                return;
            }
            if (oldValue != newValue) {
                ShaderCompatHandler.irisApiReloadShader();
            }
        }).build());
        commonCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"superresolution.screen.config.options.label.disable_upscale_on_vanilla"), SuperResolutionConfig.isDisableUpscaleOnVanilla()).setTooltip(new class_2561[]{class_2561.method_43471((String)"superresolution.screen.config.options.tooltip.disable_upscale_on_vanilla")}).setDefaultValue(false).setSaveConsumer(SuperResolutionConfig::setDisableUpscaleOnVanilla).build());
        commonCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)class_2561.method_43471((String)"superresolution.screen.config.options.label.upscale_ratio"), ClothConfig.getInt(SuperResolutionConfig.getUpscaleRatio()), ClothConfig.getInt(SuperResolutionConfig.getMinUpscaleRatio()), ClothConfig.getInt(4.0f)).setDefaultValue(ClothConfig.getInt(1.7)).setTextGetter(integer -> class_2561.method_43470((String)String.format("%.2f", Float.valueOf(ClothConfig.getFloat(integer))))).setTooltipSupplier(integer -> {
            float value = ClothConfig.getFloat(integer);
            return Optional.of(new class_2561[]{class_2561.method_43470((String)class_2561.method_43471((String)"superresolution.screen.config.options.tooltip.upscale_ratio").getString().formatted((int)((float)RenderHandlerManager.getScreenWidth() / value), (int)((float)RenderHandlerManager.getScreenHeight() / value), (int)(1.0f / value * 100.0f) + "%"))});
        }).setSaveConsumer(i -> SuperResolutionConfig.setUpscaleRatio(ClothConfig.getFloat(i))).build());
        commonCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)class_2561.method_43471((String)"superresolution.screen.config.options.label.sharpness"), ClothConfig.getInt(SuperResolutionConfig.getSharpness()), ClothConfig.getInt(0.0), ClothConfig.getInt(1.0)).setTooltip(new class_2561[]{class_2561.method_43471((String)"superresolution.screen.config.options.tooltip.sharpness")}).setDefaultValue(ClothConfig.getInt(0.55)).setTextGetter(integer -> class_2561.method_43470((String)String.format("%.2f", Float.valueOf(ClothConfig.getFloat(integer))))).setSaveConsumer(i -> SuperResolutionConfig.setSharpness(ClothConfig.getFloat(i))).build());
        SelectionListEntry algorithmSelector = entryBuilder.startSelector((class_2561)class_2561.method_43471((String)"superresolution.screen.config.options.label.algo_type"), AlgorithmRegistry.getAlgorithmMap().values().toArray(), SuperResolutionConfig.getUpscaleAlgorithm()).setDefaultValue(AlgorithmDescriptions.FSR1).setNameProvider(anEnum -> class_2561.method_43470((String)((AlgorithmDescription)anEnum).getBriefName())).setErrorSupplier(algorithmType -> {
            if (Platform.currentPlatform.isDevelopmentEnvironment() || Platform.currentPlatform.getModVersionString("super_resolution").contains("dev") || System.getenv().containsKey("SR_TEST")) {
                return Optional.empty();
            }
            if (!((AlgorithmDescription)algorithmType).getRequirement().check().support()) {
                return Optional.of(class_2561.method_43471((String)"superresolution.screen.config.error.unsupported_algorithm"));
            }
            return Optional.empty();
        }).setSaveConsumer(o -> SuperResolutionConfig.setUpscaleAlgorithm((AlgorithmDescription)o)).build();
        commonCategory.addEntry((AbstractConfigListEntry)algorithmSelector);
        commonCategory.addEntry((AbstractConfigListEntry)((TextDescriptionBuilder)entryBuilder.startTextDescription((class_2561)class_2561.method_43471((String)"superresolution.screen.config.warn.algorithm_unstable")).setColor(ColorUtil.color(255, 255, 128, 0)).setDisplayRequirement(Requirement.isValue((ValueHolder)algorithmSelector, AlgorithmDescriptions.FSR2, (Object[])new Object[]{AlgorithmDescriptions.SGSR2}))).build());
        commonCategory.addEntry((AbstractConfigListEntry)((TextDescriptionBuilder)entryBuilder.startTextDescription((class_2561)class_2561.method_43471((String)"superresolution.screen.config.warn.algorithm_incomplete")).setColor(ColorUtil.color(255, 255, 0, 0)).setDisplayRequirement(Requirement.isTrue(() -> false))).build());
        EnumListEntry captureModeEnumSelector = entryBuilder.startEnumSelector((class_2561)class_2561.method_43471((String)"superresolution.screen.config.options.label.capture_mode"), CaptureMode.class, (Enum)SuperResolutionConfig.getCaptureMode()).setDefaultValue((Enum)CaptureMode.A).setErrorSupplier(captureMode -> {
            if (Platform.currentPlatform.getMinecraftVersion().equals("1.21.4") && captureMode == CaptureMode.B || Platform.currentPlatform.getMinecraftVersion().equals("1.21.5") && captureMode == CaptureMode.C || Platform.currentPlatform.getMinecraftVersion().equals("1.21.6") && captureMode == CaptureMode.C || Platform.currentPlatform.getMinecraftVersion().equals("1.21.7") && captureMode == CaptureMode.C || Platform.currentPlatform.getMinecraftVersion().equals("1.21.8") && captureMode == CaptureMode.C) {
                return Optional.of(class_2561.method_43469((String)"superresolution.screen.config.error.capture_mode_unsupported", (Object[])new Object[]{Platform.currentPlatform.getMinecraftVersion()}));
            }
            return Optional.empty();
        }).setTooltipSupplier(captureMode -> Optional.of(new class_2561[]{captureMode.get()})).setSaveConsumer(SuperResolutionConfig::setCaptureMode).build();
        commonCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"superresolution.screen.config.options.label.generate_motion_vectors"), SuperResolutionConfig.isGenerateMotionVectors()).setTooltip(new class_2561[]{class_2561.method_43471((String)"superresolution.screen.config.options.tooltip.generate_motion_vectors")}).setDefaultValue(false).setSaveConsumer(SuperResolutionConfig::setGenerateMotionVectors).build());
        commonCategory.addEntry((AbstractConfigListEntry)captureModeEnumSelector);
        commonCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"superresolution.screen.config.options.label.skip_init_vulkan"), SuperResolutionConfig.isSkipInitVulkan()).setTooltip(new class_2561[]{class_2561.method_43471((String)"superresolution.screen.config.options.tooltip.skip_init_vulkan")}).setSaveConsumer(SuperResolutionConfig::setSkipInitVulkan).requireRestart().build());
        commonCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"superresolution.screen.config.options.label.enable_compat_shader_compiler"), SuperResolutionConfig.isEnableCompatShaderCompiler()).setTooltip(new class_2561[]{class_2561.method_43471((String)"superresolution.screen.config.options.tooltip.enable_compat_shader_compiler")}).setSaveConsumer(SuperResolutionConfig::setEnableCompatShaderCompiler).requireRestart().build());
        commonCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"superresolution.screen.config.options.label.pause_game_on_gui"), SuperResolutionConfig.isPauseGameOnGui()).setSaveConsumer(SuperResolutionConfig::setPauseGameOnGui).build());
        commonCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"superresolution.screen.config.options.label.enable_detailed_profiling"), SuperResolutionConfig.isEnableDetailedProfiling()).setTooltip(new class_2561[]{class_2561.method_43471((String)"superresolution.screen.config.options.tooltip.enable_detailed_profiling")}).setDefaultValue(false).setSaveConsumer(SuperResolutionConfig::setEnableDetailedProfiling).build());
        commonCategory.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector((class_2561)class_2561.method_43471((String)"superresolution.screen.config.options.label.internal_texture_format"), InternalTextureFormat.class, (Enum)((InternalTextureFormat)((Object)SuperResolutionConfig.INTERNAL_TEXTURE_FORMAT.get()))).setTooltip(new class_2561[]{class_2561.method_43471((String)"superresolution.screen.config.options.tooltip.internal_texture_format")}).setDefaultValue((Enum)((InternalTextureFormat)((Object)SuperResolutionConfig.INTERNAL_TEXTURE_FORMAT.getDefault()))).setSaveConsumer(newValue -> {
            if (SuperResolutionConfig.INTERNAL_TEXTURE_FORMAT.get() != newValue) {
                SuperResolutionConfig.setInternalTextureFormat(newValue);
                SuperResolution.recreateAlgorithm();
            }
        }).build());
        commonCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"superresolution.screen.config.options.label.force_disable_shader_compat"), SuperResolutionConfig.isForceDisableShaderCompat()).setTooltip(new class_2561[]{class_2561.method_43471((String)"superresolution.screen.config.options.tooltip.force_disable_shader_compat")}).setDefaultValue(false).setSaveConsumer(newValue -> {
            SuperResolutionConfig.setForceDisableShaderCompat(newValue);
            if (!ShaderCompatHandler.isShaderPackCompatSuperResolution()) {
                return;
            }
            ShaderCompatHandler.irisApiReloadShader();
        }).build());
        ArrayList injectPostChainBlackList = new ArrayList();
        commonCategory.addEntry((AbstractConfigListEntry)entryBuilder.startStrList((class_2561)class_2561.method_43471((String)"superresolution.screen.config.options.label.inject_postChain_black_list"), SuperResolutionConfig.getInjectPostChainBlackList()).setDefaultValue(injectPostChainBlackList).requireRestart().setTooltip(new class_2561[]{class_2561.method_43471((String)"superresolution.screen.config.options.tooltip.inject_postChain_black_list")}).setSaveConsumer(SuperResolutionConfig::setInjectPostChainBlackList).build());
        commonCategory.addEntry((AbstractConfigListEntry)new ClothButtonEntry((class_2561)class_2561.method_43471((String)"superresolution.screen.config.button.label.info"), button -> class_310.method_1551().method_1507(ConfigScreenBuilder.create().buildInfoScreen(class_310.method_1551().field_1755)), true));
        if (Platform.currentPlatform.isDevelopmentEnvironment()) {
            commonCategory.addEntry((AbstractConfigListEntry)new ClothButtonEntry((class_2561)class_2561.method_43470((String)"UI Design"), button -> class_310.method_1551().method_1507((class_437)new WidgetDesignScreen((class_2561)class_2561.method_43470((String)""))), true));
            commonCategory.addEntry((AbstractConfigListEntry)new ClothButtonEntry((class_2561)class_2561.method_43470((String)"UI Test"), button -> class_310.method_1551().method_1507((class_437)TestOptionBuilder.build(class_310.method_1551().field_1755)), true));
        }
        for (String key : SuperResolutionConfig.SPECIAL.description.keySet()) {
            ClothConfig.addSpecialConfig(builder, (ConfigEntryBuilder)entryBuilder, key);
        }
        ClothConfig.addDebug(builder, (ConfigEntryBuilder)entryBuilder);
        builder.setSavingRunnable(() -> {
            SuperResolutionConfig.SPEC.save();
            ConfigChangedEvent.EVENT.invoker().onConfigReload();
        });
    }

    private static int getInt(float v) {
        return (int)((double)v * 10000.0);
    }

    private static int getInt(double v) {
        return (int)(v * 10000.0);
    }

    private static float getFloat(int v) {
        return (float)((double)v / 10000.0);
    }

    public static void addSpecialConfig(ConfigBuilder builder, ConfigEntryBuilder entryBuilder, String key) {
        Pair<SpecialConfig, String> specialConfigDescription = SuperResolutionConfig.SPECIAL.description.get(key);
        Map<String, SpecialConfigDescription<?>> configDescriptions = specialConfigDescription.left().getDescriptions();
        Set<String> keys = configDescriptions.keySet();
        if (keys.isEmpty()) {
            return;
        }
        ConfigCategory category = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)specialConfigDescription.right()));
        for (String configKey : keys) {
            StringFieldBuilder fieldBuilder;
            SpecialConfigDescription<?> configDescription = configDescriptions.get(configKey);
            switch (configDescription.getType()) {
                default: {
                    throw new MatchException(null, null);
                }
                case ENUM: {
                    StringFieldBuilder stringFieldBuilder = entryBuilder.startEnumSelector(configDescription.getName(), configDescription.getClazz(), (Enum)configDescription.getValue()).setDefaultValue((Enum)configDescription.getDefaultValue()).setSaveConsumer(configDescription.getSaveConsumer()).setEnumNameProvider(configDescription.isValueNameIsSupplier() ? anEnum -> configDescription.getValueNameSupplierAsObject().apply(anEnum).orElse((class_2561)class_2561.method_43473()) : null);
                    break;
                }
                case FLOAT: {
                    StringFieldBuilder stringFieldBuilder = entryBuilder.startIntSlider(configDescription.getName(), ClothConfig.getInt(((Float)configDescription.getValue()).floatValue()), ClothConfig.getInt(((Float)configDescription.getValueRange().left()).floatValue()), ClothConfig.getInt(((Float)configDescription.getValueRange().right()).floatValue())).setTextGetter(configDescription.isValueNameIsSupplier() ? integer -> configDescription.getValueNameSupplierAsObject().apply(integer).orElse((class_2561)class_2561.method_43473()) : integer -> class_2561.method_43470((String)String.format("%.2f", Float.valueOf(ClothConfig.getFloat(integer))))).setDefaultValue(ClothConfig.getInt(((Float)configDescription.getDefaultValue()).floatValue())).setSaveConsumer(integer -> configDescription.getSaveConsumerAsObject().accept(integer));
                    break;
                }
                case STRING: {
                    StringFieldBuilder stringFieldBuilder = entryBuilder.startStrField(configDescription.getName(), (String)configDescription.getValue()).setDefaultValue((String)configDescription.getDefaultValue()).setSaveConsumer(configDescription.getSaveConsumer());
                    break;
                }
                case BOOLEAN: {
                    StringFieldBuilder stringFieldBuilder = ((BooleanToggleBuilder)entryBuilder.startBooleanToggle(configDescription.getName(), ((Boolean)configDescription.getValue()).booleanValue()).setYesNoTextSupplier(configDescription.isValueNameIsSupplier() ? aBoolean -> configDescription.getValueNameSupplierAsObject().apply(aBoolean).orElse((class_2561)class_2561.method_43473()) : null).setDefaultValue((Object)((Boolean)configDescription.getDefaultValue()))).setSaveConsumer(configDescription.getSaveConsumer());
                    break;
                }
                case OBJECT: {
                    StringFieldBuilder stringFieldBuilder = fieldBuilder = null;
                }
            }
            if (configDescription.getTooltip().isPresent() && fieldBuilder != null) {
                fieldBuilder.setTooltip(new class_2561[]{configDescription.getTooltip().orElse((class_2561)class_2561.method_43473())});
            }
            if (fieldBuilder == null) continue;
            category.addEntry(fieldBuilder.build());
        }
    }

    public static void addDebug(ConfigBuilder builder, ConfigEntryBuilder entryBuilder) {
        ConfigCategory debugCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"superresolution.screen.config.category.debug"));
        debugCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"superresolution.screen.config.options.label.enable_debug"), SuperResolutionConfig.isEnableDebug()).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43471((String)"superresolution.screen.config.options.tooltip.enable_debug")}).setSaveConsumer(SuperResolutionConfig::setEnableDebug).build());
        debugCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"superresolution.screen.config.options.label.debug_dump_shader"), SuperResolutionConfig.isDebugDumpShader()).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43471((String)"superresolution.screen.config.options.tooltip.debug_dump_shader")}).setSaveConsumer(SuperResolutionConfig::setDebugDumpShader).build());
        debugCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"superresolution.screen.config.options.label.enable_renderdoc"), SuperResolutionConfig.isEnableRenderDoc()).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43471((String)"superresolution.screen.config.options.tooltip.enable_renderdoc")}).setSaveConsumer(SuperResolutionConfig::setEnableRenderDoc).build());
        debugCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"superresolution.screen.config.options.label.enable_imgui"), SuperResolutionConfig.isEnableImgui()).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43471((String)"superresolution.screen.config.options.tooltip.enable_imgui")}).setSaveConsumer(SuperResolutionConfig::setEnableImgui).build());
    }

    public static void addInfos(ConfigBuilder builder) {
        ConfigCategory performanceInfoCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"superresolution.screen.info.title.performance_info"));
        ConfigCategory algoInfoCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"superresolution.screen.info.text.algo_support_status"));
        ConfigCategory envInfoCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"superresolution.screen.info.title.env_info"));
        ConfigCategory projectInfoCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"superresolution.screen.info.title.project_info"));
        ClothTextListListEntry envInfoEntry = new ClothTextListListEntry((class_2561)class_2561.method_43473(), null, false).setTop(4).setBottom(7);
        InfoBuilder.of(envInfoEntry).addEnvInfo();
        ClothTextListListEntry glExtInfoEntry = new ClothTextListListEntry((class_2561)class_2561.method_43471((String)"superresolution.screen.info.button.label.opengl_ext_info").method_27693(" ").method_27693(class_2561.method_43471((String)"superresolution.screen.info.text.opengl_ext_count").getString().formatted(GraphicsCapabilities.getGLExtensions().size())), null, true).setTop(4).setBottom(7);
        InfoBuilder.of(glExtInfoEntry).addGlExt();
        ClothTextListListEntry vkExtInfoEntry = null;
        if (RenderSystems.isSupportVulkan()) {
            vkExtInfoEntry = new ClothTextListListEntry((class_2561)class_2561.method_43471((String)"superresolution.screen.info.button.label.vulkan_ext_info").method_27693(" ").method_27693(class_2561.method_43471((String)"superresolution.screen.info.text.vulkan_ext_count").getString().formatted(GraphicsCapabilities.getVulkanDeviceExtensions().size())), null, true).setTop(4).setBottom(7);
            InfoBuilder.of(vkExtInfoEntry).addVkExt();
        }
        envInfoCategory.addEntry((AbstractConfigListEntry)envInfoEntry);
        envInfoCategory.addEntry((AbstractConfigListEntry)glExtInfoEntry);
        if (RenderSystems.isSupportVulkan()) {
            envInfoCategory.addEntry(vkExtInfoEntry);
        }
        for (AlgorithmDescription<?> algorithmDescription : AlgorithmRegistry.getAlgorithmMap().values()) {
            if (algorithmDescription.equals(AlgorithmDescriptions.NONE)) continue;
            ClothTextListListEntry algoInfoEntry = new ClothTextListListEntry((class_2561)class_5250.method_43477((class_7417)class_2561.method_43470((String)algorithmDescription.getDisplayName()).method_10851()).method_27696(class_2583.field_24360.method_36139(AlgorithmManager.isSupportAlgorithm(algorithmDescription) ? ColorUtil.color(255, 255, 255, 255) : ColorUtil.color(255, 255, 0, 0))), null, true).setTop(4).setBottom(7);
            InfoBuilder.of(algoInfoEntry).addAlgoInfo(algorithmDescription);
            algoInfoCategory.addEntry((AbstractConfigListEntry)algoInfoEntry);
        }
        ClothTextListListEntry contributorsEntry = new ClothTextListListEntry((class_2561)class_2561.method_43471((String)"superresolution.screen.info.text.contributors"), null, true).setTop(4).setBottom(7);
        String[] contributors = new String[]{"187J3X1", "\u5f02\u4e16\u754c\u7f8e\u897f\u8788", "yu", "Enaium", "rrtt217", "qwertyuiop"};
        LinkedHashMap<String, String> libraries = new LinkedHashMap<String, String>(){
            {
                this.put("Cloth Config", "https://github.com/shedaniel/cloth-config");
                this.put("Architectury API", "https://github.com/architectury/architectury-api");
                this.put("Night Config", "https://github.com/TheElectronWill/night-config");
                this.put("SpongePowered Mixin", "https://github.com/SpongePowered/Mixin");
                this.put("Manifold", "https://github.com/manifold-systems/manifold");
                this.put("Dear ImGui", "https://github.com/ocornut/imgui");
                this.put("Snapdragon\u2122 Game Super Resolution 2(1)", "https://github.com/SnapdragonStudios/snapdragon-gsr");
                this.put("FidelityFX Super Resolution 1.0", "https://github.com/GPUOpen-Effects/FidelityFX-FSR");
                this.put("FidelityFX Super Resolution 2.2", "https://github.com/GPUOpen-Effects/FidelityFX-FSR2");
                this.put("AMD FidelityFX\u2122 SDK", "https://github.com/GPUOpen-LibrariesAndSDKs/FidelityFX-SDK");
                this.put("NVIDIA Image Scaling SDK v1.0.3", "https://github.com/NVIDIAGameWorks/NVIDIAImageScaling");
                this.put("Java OpenGL Math Library(JOML)", "https://github.com/JOML-CI/JOML");
                this.put("RenderDoc", "https://github.com/baldurk/renderdoc");
                this.put("Lightweight Java Game Library 3(LWJGL3)", "https://github.com/LWJGL/lwjgl3");
                this.put("Glslang", "https://github.com/KhronosGroup/glslang");
            }
        };
        LinkedHashMap<String, String> officialLinks = new LinkedHashMap<String, String>(){
            {
                this.put(class_2561.method_43471((String)"superresolution.screen.info.link.official_website").getString(), "https://minecraft-superresolution.netlify.app/");
                this.put(class_2561.method_43471((String)"superresolution.screen.info.link.github_repo").getString(), "https://github.com/187J3X1-114514/superresolution");
                this.put(class_2561.method_43471((String)"superresolution.screen.info.link.issue_tracker").getString(), "https://github.com/187J3X1-114514/superresolution/issues");
                this.put(class_2561.method_43471((String)"superresolution.screen.info.link.mcmod_homepage").getString(), "https://www.mcmod.cn/class/17888.html");
                this.put("Modrinth", "https://modrinth.com/mod/superresolution");
            }
        };
        ClothTextListListEntry webLinksEntry = new ClothTextListListEntry((class_2561)class_2561.method_43471((String)"superresolution.screen.info.text.website_links"), null, true).setTop(4).setBottom(7);
        webLinksEntry.addLine(new Line().text((class_2561)class_2561.method_43471((String)"superresolution.screen.info.text.website_links")).color(0, 122, 204, 255).center(true));
        officialLinks.forEach((title, url) -> webLinksEntry.addLine(new Line().text((class_2561)class_2561.method_43470((String)title).method_27696(class_2583.field_24360.method_36139(-12409355).method_10958(ClothConfig.createURLClickEvent(url))).method_10852((class_2561)class_2561.method_43470((String)" - ")).method_10852((class_2561)class_2561.method_43470((String)url).method_27696(class_2583.field_24360.method_36139(ColorUtil.color(255, 150, 150, 150)).method_30938(Boolean.valueOf(true)).method_10958(ClothConfig.createURLClickEvent(url)))))));
        contributorsEntry.addLine(new Line().text((class_2561)class_2561.method_43471((String)"superresolution.screen.info.text.contributors")).color(255, 200, 100, 255).center(true));
        for (String contributor : contributors) {
            contributorsEntry.addLine(new Line().text("\u2022 " + contributor).color(255, 255, 255, 255));
        }
        ClothTextListListEntry librariesEntry = new ClothTextListListEntry((class_2561)class_2561.method_43471((String)"superresolution.screen.info.text.open_source"), null, true).setTop(4).setBottom(7);
        librariesEntry.addLine(new Line().text((class_2561)class_2561.method_43471((String)"superresolution.screen.info.text.open_source")).color(100, 200, 255, 255).center(true));
        librariesEntry.addLine(new Line().text((class_2561)class_2561.method_43471((String)"superresolution.screen.info.text.open_source_thank")).color(100, 200, 255, 255).center(true));
        libraries.forEach((name, url) -> {
            librariesEntry.addLine(new Line().text((class_2561)class_2561.method_43470((String)name).method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_36139(-16711936).method_10958(ClothConfig.createURLClickEvent(url)))));
            librariesEntry.addLine(new Line().text((class_2561)class_2561.method_43470((String)url).method_27696(class_2583.field_24360.method_36139(ColorUtil.color(255, 150, 150, 150)).method_10958(ClothConfig.createURLClickEvent(url)))));
        });
        projectInfoCategory.addEntry((AbstractConfigListEntry)webLinksEntry);
        projectInfoCategory.addEntry((AbstractConfigListEntry)contributorsEntry);
        projectInfoCategory.addEntry((AbstractConfigListEntry)librariesEntry);
        ClothTextListEntry debugInfo = new ClothTextListEntry((class_2561)class_2561.method_43471((String)"superresolution.screen.debug.performance_info"), () -> {
            String stringBuilder = class_2561.method_43469((String)"superresolution.screen.info.performance_info.frame_time", (Object[])new Object[]{BigDecimal.valueOf(PerformanceInfo.getAsMillis("runTick")).setScale(3, RoundingMode.HALF_UP)}).getString() + "\n" + class_2561.method_43469((String)"superresolution.screen.info.performance_info.world_time", (Object[])new Object[]{class_310.method_1551().field_1687 != null && SuperResolutionConfig.isEnableDetailedProfiling() ? BigDecimal.valueOf(PerformanceInfo.getAsMillis("world")).setScale(3, RoundingMode.HALF_UP) : "?"}).getString() + "\n" + class_2561.method_43469((String)"superresolution.screen.info.performance_info.upscale_time", (Object[])new Object[]{class_310.method_1551().field_1687 != null && SuperResolutionConfig.isEnableDetailedProfiling() ? BigDecimal.valueOf(PerformanceInfo.getAsMillis("upscale")).setScale(3, RoundingMode.HALF_UP) : "?"}).getString();
            return class_2561.method_43470((String)stringBuilder);
        }, ColorUtil.color(255, 255, 255, 255), null);
        ClothChartEntry frameTimeChart = new ClothChartEntry(class_2561.method_43469((String)"superresolution.screen.info.performance_info.frame_time", (Object[])new Object[]{BigDecimal.valueOf(PerformanceRecoder.getCpuFrameTimeMs()).setScale(3, RoundingMode.HALF_UP)}).getString(), (class_2561)class_2561.method_43469((String)"superresolution.screen.info.performance_info.frame_time", (Object[])new Object[]{BigDecimal.valueOf(PerformanceRecoder.getCpuFrameTimeMs()).setScale(3, RoundingMode.HALF_UP)}), null);
        frameTimeChart.setRenderCallback(chart -> {
            chart.setName(class_2561.method_43469((String)"superresolution.screen.info.performance_info.frame_time", (Object[])new Object[]{BigDecimal.valueOf(PerformanceRecoder.getCpuFrameTimeMs()).setScale(3, RoundingMode.HALF_UP)}).getString());
            chart.push(PerformanceRecoder.getCpuFrameTimeMs(), 1000);
        });
        frameTimeChart.setDisplayRange(0.0f, 100.0f);
        ClothChartEntry worldTimeChartCPU = new ClothChartEntry("CPU " + class_2561.method_43469((String)"superresolution.screen.info.performance_info.world_time", (Object[])new Object[]{BigDecimal.valueOf(PerformanceRecoder.getCpuWorldTimeMs()).setScale(3, RoundingMode.HALF_UP)}).getString(), (class_2561)class_2561.method_43473().method_27693("CPU ").method_10852((class_2561)class_2561.method_43469((String)"superresolution.screen.info.performance_info.world_time", (Object[])new Object[]{BigDecimal.valueOf(PerformanceRecoder.getCpuWorldTimeMs()).setScale(3, RoundingMode.HALF_UP)})), null);
        worldTimeChartCPU.setRenderCallback(chart -> {
            if (class_310.method_1551().field_1687 != null) {
                chart.setName("CPU " + class_2561.method_43469((String)"superresolution.screen.info.performance_info.world_time", (Object[])new Object[]{BigDecimal.valueOf(PerformanceRecoder.getCpuWorldTimeMs()).setScale(3, RoundingMode.HALF_UP)}).getString());
                chart.push(PerformanceRecoder.getCpuWorldTimeMs(), 1000);
            }
        });
        worldTimeChartCPU.setDisplayRange(0.0f, 80.0f);
        ClothChartEntry srUpscaleTimeChartCPU = new ClothChartEntry("CPU " + class_2561.method_43469((String)"superresolution.screen.info.performance_info.upscale_time", (Object[])new Object[]{BigDecimal.valueOf(PerformanceRecoder.getCpuUpscaleTimeMs()).setScale(3, RoundingMode.HALF_UP)}).getString(), (class_2561)class_2561.method_43473().method_27693("CPU ").method_10852((class_2561)class_2561.method_43469((String)"superresolution.screen.info.performance_info.upscale_time", (Object[])new Object[]{BigDecimal.valueOf(PerformanceRecoder.getCpuUpscaleTimeMs()).setScale(3, RoundingMode.HALF_UP)})), null);
        srUpscaleTimeChartCPU.setRenderCallback(chart -> {
            if (class_310.method_1551().field_1687 != null) {
                chart.setName("CPU " + class_2561.method_43469((String)"superresolution.screen.info.performance_info.upscale_time", (Object[])new Object[]{BigDecimal.valueOf(PerformanceRecoder.getCpuUpscaleTimeMs()).setScale(3, RoundingMode.HALF_UP)}).getString());
                chart.push(PerformanceRecoder.getCpuUpscaleTimeMs(), 1000);
            }
        });
        srUpscaleTimeChartCPU.setDisplayRange(0.0f, 40.0f);
        performanceInfoCategory.addEntry((AbstractConfigListEntry)debugInfo);
        performanceInfoCategory.addEntry((AbstractConfigListEntry)frameTimeChart);
        performanceInfoCategory.addEntry((AbstractConfigListEntry)worldTimeChartCPU);
        performanceInfoCategory.addEntry((AbstractConfigListEntry)srUpscaleTimeChartCPU);
        if (SuperResolutionConfig.isEnableDetailedProfiling()) {
            ClothChartEntry worldTimeChart = new ClothChartEntry(class_2561.method_43469((String)"superresolution.screen.info.performance_info.world_time", (Object[])new Object[]{BigDecimal.valueOf(PerformanceRecoder.getWorldTimeMs()).setScale(3, RoundingMode.HALF_UP)}).getString(), (class_2561)class_2561.method_43469((String)"superresolution.screen.info.performance_info.world_time", (Object[])new Object[]{BigDecimal.valueOf(PerformanceRecoder.getWorldTimeMs()).setScale(3, RoundingMode.HALF_UP)}), null);
            worldTimeChart.setRenderCallback(chart -> {
                if (class_310.method_1551().field_1687 != null) {
                    chart.setName(class_2561.method_43469((String)"superresolution.screen.info.performance_info.world_time", (Object[])new Object[]{BigDecimal.valueOf(PerformanceRecoder.getWorldTimeMs()).setScale(3, RoundingMode.HALF_UP)}).getString());
                    chart.push(PerformanceRecoder.getWorldTimeMs(), 1000);
                }
            });
            worldTimeChart.setDisplayRange(0.0f, 80.0f);
            ClothChartEntry upscaleTimeChart = new ClothChartEntry(class_2561.method_43469((String)"superresolution.screen.info.performance_info.upscale_time", (Object[])new Object[]{BigDecimal.valueOf(PerformanceRecoder.getUpscaleTimeMs()).setScale(3, RoundingMode.HALF_UP)}).getString(), (class_2561)class_2561.method_43469((String)"superresolution.screen.info.performance_info.upscale_time", (Object[])new Object[]{BigDecimal.valueOf(PerformanceRecoder.getUpscaleTimeMs()).setScale(3, RoundingMode.HALF_UP)}), null);
            upscaleTimeChart.setRenderCallback(chart -> {
                if (class_310.method_1551().field_1687 != null) {
                    chart.setName(class_2561.method_43469((String)"superresolution.screen.info.performance_info.upscale_time", (Object[])new Object[]{BigDecimal.valueOf(PerformanceRecoder.getUpscaleTimeMs()).setScale(3, RoundingMode.HALF_UP)}).getString());
                    chart.push(PerformanceRecoder.getUpscaleTimeMs(), 1000);
                }
            });
            upscaleTimeChart.setDisplayRange(0.0f, 40.0f);
            performanceInfoCategory.addEntry((AbstractConfigListEntry)worldTimeChart);
            performanceInfoCategory.addEntry((AbstractConfigListEntry)upscaleTimeChart);
        }
    }

    private static class_2558 createURLClickEvent(String url) {
        return new class_2558(class_2558.class_2559.field_11749, url);
    }
}

