/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.gui;

import io.homo.superresolution.api.platform.OperatingSystem;
import io.homo.superresolution.api.platform.Platform;
import io.homo.superresolution.api.registry.AlgorithmDescription;
import io.homo.superresolution.api.utils.Requirement;
import io.homo.superresolution.common.gui.widgets.Line;
import io.homo.superresolution.common.upscale.AlgorithmDescriptions;
import io.homo.superresolution.core.NativeLibManager;
import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.SuperResolutionNative;
import io.homo.superresolution.core.graphics.GraphicsCapabilities;
import io.homo.superresolution.core.utils.ColorUtil;
import java.util.List;
import net.minecraft.class_2561;

public class InfoBuilder {
    private static final int COLOR_WHITE = ColorUtil.color(255, 255, 255, 255);
    private static final int COLOR_RED = ColorUtil.color(255, 255, 0, 0);
    private final LineContainer lineContainer;

    InfoBuilder(LineContainer lineContainer) {
        this.lineContainer = lineContainer;
    }

    public static InfoBuilder of(LineContainer lineContainer) {
        return new InfoBuilder(lineContainer);
    }

    public InfoBuilder addGlExt() {
        this.addCenteredLine("superresolution.screen.info.text.opengl_ext_count", GraphicsCapabilities.getGLExtensions().size());
        for (String ext : GraphicsCapabilities.getGLExtensions()) {
            this.addLine(ext);
        }
        return this;
    }

    public InfoBuilder addVkExt() {
        this.addCenteredLine("superresolution.screen.info.text.vulkan_ext_count", GraphicsCapabilities.getVulkanDeviceExtensions().size());
        for (String ext : GraphicsCapabilities.getVulkanDeviceExtensions()) {
            this.addLine(ext);
        }
        return this;
    }

    public InfoBuilder addEnvInfo() {
        this.addLine("superresolution.screen.info.text.mod_version", Platform.currentPlatform.getModVersionString("super_resolution"));
        this.addLine("superresolution.screen.info.text.native_lib_version", NativeLibManager.nativeApiAvailable() ? SuperResolutionNative.getVersionInfo() : "???");
        this.addLine("superresolution.screen.info.text.opengl_version", GraphicsCapabilities.getGLVersion()[0], GraphicsCapabilities.getGLVersion()[1]);
        this.addLine("superresolution.screen.info.text.vulkan_available", this.getYesNo(RenderSystems.isSupportVulkan()));
        this.addLine("superresolution.screen.info.text.vulkan_version", GraphicsCapabilities.getVulkanVersion()[0], GraphicsCapabilities.getVulkanVersion()[1], GraphicsCapabilities.getVulkanVersion()[2]);
        this.addLine("superresolution.screen.info.text.os_name", Platform.currentPlatform.getOS().type.getString());
        this.addLine("superresolution.screen.info.text.os_arch", Platform.currentPlatform.getOS().arch.getString());
        return this;
    }

    public InfoBuilder addAlgoInfo(AlgorithmDescription<?> algo) {
        if (algo.equals(AlgorithmDescriptions.NONE)) {
            return this;
        }
        this.lineContainer.addLine(new Line().text(algo.getDisplayName()).center(true).color(COLOR_WHITE));
        Requirement req = algo.getRequirement();
        Requirement.Result result = req.check();
        List<String> missingGlExt = req.getMissingGlExtensions();
        List<String> missingVkExt = req.getMissingVkExtensions();
        this.addLine("superresolution.screen.info.text.min_opengl_version", this.formatVersion(req.getGlMajorVersion()), this.formatVersion(req.getGlMinorVersion()));
        this.addLine("superresolution.screen.info.text.min_vulkan_version", this.formatVersion(req.getVulkanMajorVersion()), this.formatVersion(req.getVulkanMinorVersion()), this.formatVersion(req.getVulkanPatchVersion()));
        this.addRequirementList("superresolution.screen.info.text_need_opengl_ext", req.getRequiredGlExtensions(), missingGlExt);
        this.addRequirementList("superresolution.screen.info.text_need_vulkan_ext", req.getRequiredVulkanDeviceExtensions(), missingVkExt);
        this.addOsRequirement(req);
        this.addLine("superresolution.screen.info.text.only_in_dev_env", this.getYesNo(req.isRequiresDevEnv()));
        this.addLine("superresolution.screen.info.text.need_vulkan", this.getYesNo(req.isRequiresVulkan()));
        this.addAvailabilityStatus("superresolution.screen.info.text.is_available", result.support());
        this.addCheckLine("superresolution.screen.info.text.requirement.os", result.osSupported());
        this.addCheckLine("superresolution.screen.info.text.requirement.env", result.environmentValid());
        this.addCheckLine("superresolution.screen.info.text.requirement.opengl_ext", result.glExtensionsPresent());
        this.addCheckLine("superresolution.screen.info.text.requirement.opengl_version", result.glVersionMet());
        this.addCheckLine("superresolution.screen.info.text.requirement.vulkan", result.vulkanAvailable());
        this.addCheckLine("superresolution.screen.info.text.requirement.vulkan_ext", result.vulkanDeviceExtensionsMet());
        this.addCheckLine("superresolution.screen.info.text.requirement.vulkan_version", result.vulkanVersionMet());
        this.addCheckLine("superresolution.screen.info.text.requirement.additional_conditions", result.additionalConditionsMet());
        return this;
    }

    private void addOsRequirement(Requirement req) {
        this.addLine(class_2561.method_43471((String)"superresolution.screen.info.text.req_os_name_and_os_arch").getString());
        if (req.getSupportedOS().isEmpty()) {
            this.addIndentedLine(class_2561.method_43471((String)"superresolution.screen.text.any").getString());
        } else {
            for (OperatingSystem operatingSystem : req.getSupportedOS()) {
                this.addIndentedLine("%s %s".formatted(operatingSystem.type.getString(), operatingSystem.arch.getString()));
            }
        }
    }

    private void addRequirementList(String headerKey, Iterable<String> extensions, List<String> missing) {
        this.addLine(class_2561.method_43471((String)headerKey).getString());
        if (!extensions.iterator().hasNext()) {
            this.addIndentedLine(class_2561.method_43471((String)"superresolution.screen.text.none").getString());
            return;
        }
        for (String ext : extensions) {
            boolean exists = !missing.contains(ext);
            this.addIndentedLine("%s (%s)".formatted(ext, exists ? class_2561.method_43471((String)"superresolution.screen.text.exist").getString() : class_2561.method_43471((String)"superresolution.screen.text.missing").getString()), exists ? COLOR_WHITE : COLOR_RED);
        }
    }

    private void addCheckLine(String key, boolean condition) {
        this.addIndentedLine(class_2561.method_43471((String)key).getString().formatted(this.getYesNo(condition)), condition ? COLOR_WHITE : COLOR_RED);
    }

    private void addAvailabilityStatus(String key, boolean condition) {
        this.addLine(class_2561.method_43471((String)key).getString().formatted(this.getYesNo(condition)), condition ? COLOR_WHITE : COLOR_RED);
    }

    private void addCenteredLine(String key, Object ... args) {
        this.lineContainer.addLine(new Line().text(class_2561.method_43471((String)key).getString().formatted(args)).center(true).color(COLOR_WHITE));
    }

    private void addLine(String key, Object ... args) {
        this.lineContainer.addLine(new Line().text(class_2561.method_43471((String)key).getString().formatted(args)).color(COLOR_WHITE));
    }

    private void addLine(String text) {
        this.lineContainer.addLine(new Line().text(text).color(COLOR_WHITE));
    }

    private void addLine(String text, int color) {
        this.lineContainer.addLine(new Line().text(text).color(color));
    }

    private void addIndentedLine(String text) {
        this.addIndentedLine(text, COLOR_WHITE);
    }

    private void addIndentedLine(String text, int color) {
        this.lineContainer.addLine(new Line().text(text).left(0.02f).color(color));
    }

    private String getYesNo(boolean condition) {
        return class_2561.method_43471((String)(condition ? "superresolution.screen.text.yes" : "superresolution.screen.text.no")).getString();
    }

    private String formatVersion(int ver) {
        return ver == -1 ? "*" : String.valueOf(ver);
    }

    private String formatVersion(int major, int minor, int patch) {
        return "%s.%s.%s".formatted(major == -1 ? "*" : Integer.valueOf(major), minor == -1 ? "*" : Integer.valueOf(minor), patch == -1 ? "*" : Integer.valueOf(patch));
    }

    public static interface LineContainer {
        public void addLine(Line var1);
    }
}

