/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.gui.options;

import io.homo.superresolution.common.gui.impl.OptionRequirement;
import io.homo.superresolution.common.gui.impl.Text;
import io.homo.superresolution.common.gui.impl.ValueHolder;
import io.homo.superresolution.common.gui.options.OptionContainerWidget;
import io.homo.superresolution.core.gui.MaterialScheme;
import io.homo.superresolution.core.gui.core.event.GuiEventListener;
import io.homo.superresolution.core.gui.core.impl.Renderable;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractOptionEntry<VT, SELF>
implements Renderable,
ValueHolder<VT>,
GuiEventListener {
    protected Text name;
    protected boolean requiresRestartGame;
    @Nullable
    protected Supplier<VT> defaultValue = null;
    @Nullable
    protected Function<VT, Optional<Text>> errorSupplier;
    @Nullable
    protected OptionRequirement enableRequirement = null;
    @Nullable
    protected OptionRequirement displayRequirement = null;
    protected Consumer<VT> saveConsumer = null;
    protected Function<VT, Optional<Text[]>> tooltipSupplier = list -> Optional.empty();
    protected VT value;
    protected OptionContainerWidget container;
    protected MaterialScheme scheme = MaterialScheme.defaultLight;

    protected SELF setScheme(MaterialScheme scheme) {
        this.scheme = scheme;
        return (SELF)this;
    }

    public AbstractOptionEntry(Text name, VT value) {
        this.name = name;
        this.value = value;
    }

    protected abstract void init();

    protected abstract void initLayout();

    protected abstract void initWidget();

    public Text getName() {
        return this.name;
    }

    public SELF setName(Text name) {
        this.name = name;
        return (SELF)this;
    }

    @Override
    public VT value() {
        return this.value;
    }

    public Consumer<VT> getSaveConsumer() {
        return this.saveConsumer;
    }

    public SELF setSaveConsumer(Consumer<VT> saveConsumer) {
        this.saveConsumer = saveConsumer;
        return (SELF)this;
    }

    public Function<VT, Optional<Text[]>> getTooltipSupplier() {
        return this.tooltipSupplier;
    }

    public SELF setTooltipSupplier(Function<VT, Optional<Text[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return (SELF)this;
    }

    public boolean isRequiresRestartGame() {
        return this.requiresRestartGame;
    }

    public SELF setRequiresRestartGame(boolean requiresRestartGame) {
        this.requiresRestartGame = requiresRestartGame;
        return (SELF)this;
    }

    public Optional<VT> getDefaultValue() {
        return this.defaultValue == null ? Optional.empty() : Optional.ofNullable(this.defaultValue.get());
    }

    public SELF setDefaultValue(@Nullable Supplier<VT> defaultValue) {
        this.defaultValue = defaultValue;
        return (SELF)this;
    }

    @Nullable
    public Function<VT, Optional<Text>> getErrorSupplier() {
        return this.errorSupplier;
    }

    public SELF setErrorSupplier(@Nullable Function<VT, Optional<Text>> errorSupplier) {
        this.errorSupplier = errorSupplier;
        return (SELF)this;
    }

    @Nullable
    public OptionRequirement getEnableRequirement() {
        return this.enableRequirement;
    }

    public SELF setEnableRequirement(@Nullable OptionRequirement enableRequirement) {
        this.enableRequirement = enableRequirement;
        return (SELF)this;
    }

    @Nullable
    public OptionRequirement getDisplayRequirement() {
        return this.displayRequirement;
    }

    public SELF setDisplayRequirement(@Nullable OptionRequirement displayRequirement) {
        this.displayRequirement = displayRequirement;
        return (SELF)this;
    }

    @Override
    public void mousePress(float x, float y, int button) {
        this.container.mousePress(x, y, button);
    }

    @Override
    public void mouseRelease(float x, float y, int button) {
        this.container.mouseRelease(x, y, button);
    }

    @Override
    public void mouseMove(float x, float y) {
        this.container.mouseMove(x, y);
    }

    @Override
    public void mouseDrag(float mouseX, float mouseY, float dragX, float dragY, int button) {
        this.container.mouseDrag(mouseX, mouseY, dragX, dragY, button);
    }

    @Override
    public void mouseScroll(float x, float y, double scrollX) {
        this.container.mouseScroll(x, y, scrollX);
    }

    @Override
    public void keyPress(int keyCode, int scancode, int modifiers) {
        this.container.keyPress(keyCode, scancode, modifiers);
    }

    @Override
    public void keyRelease(int keyCode, int scancode, int modifiers) {
        this.container.keyRelease(keyCode, scancode, modifiers);
    }

    @Override
    public void charTyped(char codePoint, int modifiers) {
        this.container.charTyped(codePoint, modifiers);
    }

    public OptionContainerWidget getContainer() {
        return this.container;
    }

    public float getEntryHeight() {
        return 48.0f;
    }
}

