/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft.handler;

import io.homo.superresolution.common.minecraft.handler.RenderHandlerManager;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureDescription;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsages;
import io.homo.superresolution.core.graphics.opengl.texture.GlTexture2D;
import java.util.List;
import java.util.function.Supplier;
import org.lwjgl.opengl.GL43;

public class TextureInfo {
    private final Supplier<ITexture> sourceTextureSupplier;
    private final List<Integer> region;
    private final boolean isOutput;
    private GlTexture2D internalTexture;
    private String name;

    public TextureInfo(Supplier<ITexture> sourceTextureSupplier, List<Integer> region, boolean isOutput, String name) {
        this.sourceTextureSupplier = sourceTextureSupplier;
        this.region = region;
        this.isOutput = isOutput;
        this.name = name;
    }

    public ITexture getSourceTexture() {
        return this.sourceTextureSupplier.get();
    }

    public ITexture getInternalTexture() {
        return this.internalTexture;
    }

    public void updateTexture() {
        ITexture sourceTexture = this.sourceTextureSupplier.get();
        if (sourceTexture == null) {
            return;
        }
        int width = this.resolveRegionValue(this.region.get(2), true);
        int height = this.resolveRegionValue(this.region.get(3), false);
        if (this.internalTexture == null) {
            this.createInternalTexture(width, height);
        } else if (this.internalTexture.getWidth() != width || this.internalTexture.getHeight() != height || this.internalTexture.getTextureFormat() != sourceTexture.getTextureFormat()) {
            this.internalTexture.destroy();
            this.createInternalTexture(width, height);
        }
        if (this.isOutput) {
            this.copyTextureRegion(this.internalTexture, 0, 0, width, height, sourceTexture, this.region.get(0), this.region.get(1));
        } else {
            this.copyTextureRegion(sourceTexture, this.region.get(0), this.region.get(1), width, height, this.internalTexture, 0, 0);
        }
    }

    public void createInternalTexture(int width, int height) {
        ITexture sourceTexture = this.sourceTextureSupplier.get();
        if (sourceTexture == null) {
            return;
        }
        this.internalTexture = GlTexture2D.create(TextureDescription.create().width(width).height(height).type(TextureType.Texture2D).mipmapsDisabled().usages(TextureUsages.create().sampler()).format(sourceTexture.getTextureFormat()).label("SRIrisCompatInternalTexture-%s".formatted(this.name)).build());
    }

    public int resolveRegionValue(int value, boolean isWidth) {
        if (value == -1) {
            return isWidth ? RenderHandlerManager.getRenderWidth() : RenderHandlerManager.getRenderHeight();
        }
        if (value == -2) {
            return isWidth ? RenderHandlerManager.getScreenWidth() : RenderHandlerManager.getScreenHeight();
        }
        return value;
    }

    public void copyTextureRegion(ITexture src, int srcX, int srcY, int srcWidth, int srcHeight, ITexture dest, int destX, int destY) {
        GL43.glCopyImageSubData((int)((int)src.handle()), (int)3553, (int)0, (int)srcX, (int)srcY, (int)0, (int)((int)dest.handle()), (int)3553, (int)0, (int)destX, (int)destY, (int)0, (int)srcWidth, (int)srcHeight, (int)1);
    }
}

