/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl.pipeline;

import io.homo.superresolution.core.graphics.impl.buffer.BufferUsage;
import io.homo.superresolution.core.graphics.impl.buffer.IBuffer;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineResourceAccess;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineResourceType;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsage;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class PipelineJobResource<RT> {
    protected final PipelineResourceAccess access;
    protected final PipelineResourceType type;
    protected Supplier<Optional<RT>> resource;
    private final Predicate<RT> validator;

    public PipelineJobResource(PipelineResourceAccess access, PipelineResourceType type, Supplier<Optional<RT>> resource, Predicate<RT> validator) {
        this.access = access;
        this.type = type;
        this.validator = validator != null ? validator : rt -> true;
        this.resource = () -> {
            if (!this.validator.test(((Optional)resource.get()).orElse(null))) {
                throw new IllegalArgumentException("Invalid resource provided for " + this.getClass().getSimpleName());
            }
            return (Optional)resource.get();
        };
    }

    public PipelineResourceAccess getAccess() {
        return this.access;
    }

    public PipelineResourceType getType() {
        return this.type;
    }

    public Optional<RT> getResource() {
        if (!this.validator.test(this.resource.get().orElse(null))) {
            throw new IllegalArgumentException("Invalid resource provided for " + this.getClass().getSimpleName());
        }
        return this.resource.get();
    }

    public void setResource(RT resource) {
        if (!this.validator.test(resource)) {
            throw new IllegalArgumentException("Invalid resource provided for " + this.getClass().getSimpleName());
        }
        this.resource = () -> Optional.of(resource);
    }

    public static class UniformBuffer
    extends PipelineJobResource<IBuffer> {
        protected UniformBuffer(PipelineResourceAccess access, PipelineResourceType type, Supplier<Optional<IBuffer>> resource) {
            super(access, type, resource, buffer -> buffer == null || buffer.getUsage() == BufferUsage.Ubo);
        }

        public static UniformBuffer create(Supplier<Optional<IBuffer>> ubo) {
            return new UniformBuffer(PipelineResourceAccess.Read, PipelineResourceType.UniformBuffer, ubo);
        }

        public static UniformBuffer create(IBuffer ubo) {
            if (ubo.getUsage() != BufferUsage.Ubo) {
                throw new IllegalArgumentException("Buffer must have UBO usage");
            }
            return UniformBuffer.create(() -> Optional.of(ubo));
        }
    }

    public static class StorageTexture
    extends PipelineJobResource<ITexture> {
        protected StorageTexture(PipelineResourceAccess access, PipelineResourceType type, Supplier<Optional<ITexture>> resource) {
            super(access, type, resource, texture -> texture == null || texture.getTextureUsages().getUsages().contains((Object)TextureUsage.Storage));
        }

        public static StorageTexture create(Supplier<Optional<ITexture>> texture, PipelineResourceAccess access) {
            return new StorageTexture(access, PipelineResourceType.StorageTexture, texture);
        }

        public static StorageTexture create(ITexture texture, PipelineResourceAccess access) {
            return StorageTexture.create(() -> Optional.of(texture), access);
        }
    }

    public static class SamplerTexture
    extends PipelineJobResource<ITexture> {
        protected SamplerTexture(PipelineResourceAccess access, PipelineResourceType type, Supplier<Optional<ITexture>> resource) {
            super(access, type, resource, texture -> texture == null || texture.getTextureUsages().getUsages().contains((Object)TextureUsage.Sampler));
        }

        public static SamplerTexture create(Supplier<Optional<ITexture>> texture) {
            return new SamplerTexture(PipelineResourceAccess.Read, PipelineResourceType.SamplerTexture, texture);
        }

        public static SamplerTexture create(ITexture texture) {
            return SamplerTexture.create(() -> Optional.of(texture));
        }
    }
}

