/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.opengl.vertex;

import io.homo.superresolution.core.graphics.impl.vertex.IVertexBuffer;
import io.homo.superresolution.core.graphics.impl.vertex.VertexBufferDescription;
import io.homo.superresolution.core.graphics.opengl.Gl;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryUtil;

public class GlVertexBuffer
implements IVertexBuffer {
    private final int id;
    private final int size;
    private final boolean dynamic;
    private final ByteBuffer buffer;

    private GlVertexBuffer(int id, int size, boolean dynamic, ByteBuffer buffer) {
        this.id = id;
        this.size = size;
        this.dynamic = dynamic;
        this.buffer = buffer;
    }

    public static GlVertexBuffer create(VertexBufferDescription description) {
        int bufferId = Gl.DSA.createBuffer();
        int usage = description.isDynamic() ? 35048 : 35044;
        ByteBuffer buffer = MemoryUtil.memAlloc((int)description.getSizeInBytes());
        Gl.DSA.bufferData(bufferId, 34962, buffer, usage);
        return new GlVertexBuffer(bufferId, description.getSizeInBytes(), description.isDynamic(), buffer);
    }

    @Override
    public long handle() {
        return this.id;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    @Override
    public void updateData(float[] data, int offset, int length) {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)length);
        buffer.put(data, offset, length);
        buffer.flip();
        Gl.DSA.bufferSubData(this.id, 0, buffer);
    }

    @Override
    public void destroy() {
        Gl.DSA.deleteBuffer(this.id);
        MemoryUtil.memFree((Buffer)this.buffer);
    }
}

