/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.fsr2.common.struct;

import io.homo.superresolution.core.graphics.impl.buffer.IBufferData;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2Context;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2Dimensions;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2DispatchDescription;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2Utils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.system.MemoryUtil;

public class Fsr2CBRcas
implements IBufferData {
    private final ByteBuffer container = MemoryUtil.memCalloc((int)((int)this.size()));

    public Fsr2CBRcas() {
        this.container.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void free() {
        MemoryUtil.memFree((Buffer)this.container);
    }

    @Override
    public void put(byte[] src, long offset) {
        throw new RuntimeException();
    }

    @Override
    public void updatePartial(Buffer data, long offset, long length) {
        throw new RuntimeException();
    }

    @Override
    public void update(Buffer data) {
        throw new RuntimeException();
    }

    public void update(Fsr2Context context, Fsr2DispatchDescription desc, Fsr2Dimensions dims) {
        this.container.clear();
        int[] rcasConfig = new int[4];
        float sharpness = -2.0f * desc.sharpness + 2.0f;
        Fsr2Utils.rcasCon(rcasConfig, sharpness);
        for (int i = 0; i < 4; ++i) {
            this.container.putInt(rcasConfig[i]);
        }
        this.container.position((int)this.size());
        this.container.flip();
    }

    @Override
    public ByteBuffer container() {
        return this.container.duplicate().rewind();
    }

    @Override
    public long size() {
        return 16L;
    }
}

