/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.fsr2.v221;

import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineJobBuilders;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineJobResource;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineResourceAccess;
import io.homo.superresolution.core.graphics.impl.shader.ShaderDescription;
import io.homo.superresolution.core.graphics.impl.shader.ShaderSource;
import io.homo.superresolution.core.graphics.impl.shader.ShaderType;
import io.homo.superresolution.core.graphics.impl.shader.uniform.ShaderUniformAccess;
import io.homo.superresolution.core.graphics.opengl.shader.GlShaderProgram;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2Context;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2Dimensions;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2Pipeline;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2PipelineDispatchResource;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2PipelineResourceType;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2ShaderResource;
import java.util.HashMap;
import org.joml.Vector3i;

public class Fsr2v221LockPipeline
extends Fsr2Pipeline {
    private GlShaderProgram program;

    public Fsr2v221LockPipeline(Fsr2Context context) {
        super(context);
    }

    @Override
    public void resize(Fsr2Dimensions size) {
    }

    @Override
    public void destroy() {
        this.program.destroy();
    }

    @Override
    public void init() {
        this.program = RenderSystems.current().device().createShaderProgram(ShaderDescription.compute(new ShaderSource(ShaderType.Compute, "/shader/fsr2v221/ffx_fsr2_lock_pass.ogl.glsl", true)).addDefines(this.getShaderDefines(new HashMap<String, String>())).name("fsr2_lock").uniformBuffer("cbFSR2", 3, (int)this.context.fsr2ConstantsUBO.getSize()).uniformSamplerTexture("r_lock_input_luma", 0).uniformStorageTexture("rw_new_locks", ShaderUniformAccess.Both, 1).uniformStorageTexture("rw_reconstructed_previous_nearest_depth", ShaderUniformAccess.Both, 2).build());
        this.program.compile();
        PipelineJobBuilders.ComputeJobBuilder jobBuilder = PipelineJobBuilders.compute(this.program).workGroupSupplier(() -> new Vector3i((this.context.dimensions.renderWidth() + 7) / 8, (this.context.dimensions.renderHeight() + 7) / 8, 1));
        jobBuilder.resource("cbFSR2", PipelineJobResource.UniformBuffer.create(this.context.fsr2ConstantsUBO));
        jobBuilder.resource(Fsr2PipelineResourceType.LOCK_INPUT_LUMA.srvShaderName(), new Fsr2ShaderResource().resourceType(Fsr2PipelineResourceType.LOCK_INPUT_LUMA).binding(0).access(PipelineResourceAccess.Read).getResourceDescription(this.context));
        jobBuilder.resource(Fsr2PipelineResourceType.NEW_LOCKS.uavShaderName(), new Fsr2ShaderResource().resourceType(Fsr2PipelineResourceType.NEW_LOCKS).binding(1).access(PipelineResourceAccess.Both).getResourceDescription(this.context));
        jobBuilder.resource(Fsr2PipelineResourceType.RECONSTRUCTED_PREVIOUS_NEAREST_DEPTH.uavShaderName(), new Fsr2ShaderResource().resourceType(Fsr2PipelineResourceType.RECONSTRUCTED_PREVIOUS_NEAREST_DEPTH).binding(2).access(PipelineResourceAccess.Both).getResourceDescription(this.context));
        this.pipeline.job("fsr2_lock", jobBuilder.build());
    }

    @Override
    public void execute(Fsr2PipelineDispatchResource dispatchResource) {
        this.pipeline.execute(dispatchResource.commandBuffer());
    }
}

