/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.event;

import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaMeasureMode;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaNode;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.config.YogaConfig;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.event.LayoutData;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.event.LayoutPassReason;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.event.LayoutType;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.event.YogaEventType;
import java.util.concurrent.atomic.AtomicReference;

public class YogaEvent {
    private static final AtomicReference<SubscriberNode> subscribers = new AtomicReference();

    public static void reset() {
        SubscriberNode head = YogaEvent.pushSubscriber(null);
        while (head != null) {
            SubscriberNode current = head;
            head = head.next;
        }
    }

    public static void subscribe(Subscriber subscriber) {
        YogaEvent.pushSubscriber(new SubscriberNode(subscriber));
    }

    public static void publish(YogaEventType eventType, YogaNode node) {
        YogaEvent.publish(node, eventType);
    }

    public static void publish(YogaNode node, YogaEventType eventType) {
        TypedData emptyData = switch (eventType) {
            case YogaEventType.NODE_ALLOCATION -> new NodeAllocationData(null);
            case YogaEventType.NODE_DEALLOCATION -> new NodeDeallocationData(null);
            case YogaEventType.NODE_LAYOUT -> new NodeLayoutData(null);
            case YogaEventType.LAYOUT_PASS_END -> new LayoutPassEndData(null);
            case YogaEventType.MEASURE_CALLBACK_END -> new MeasureCallbackEndData(0.0f, null, 0.0f, null, 0.0f, 0.0f, null);
            default -> null;
        };
        YogaEvent.publish(node, eventType, emptyData);
    }

    public static void publish(YogaNode node, YogaEventType eventType, TypedData eventData) {
        SubscriberNode subscriber = subscribers.get();
        while (subscriber != null) {
            subscriber.subscriber.onEvent(node, eventType, eventData);
            subscriber = subscriber.next;
        }
    }

    private static SubscriberNode pushSubscriber(SubscriberNode newHead) {
        SubscriberNode oldHead;
        do {
            oldHead = subscribers.get();
            if (newHead == null) continue;
            newHead.next = oldHead;
        } while (!subscribers.compareAndSet(oldHead, newHead));
        return oldHead;
    }

    private static final class SubscriberNode {
        final Subscriber subscriber;
        SubscriberNode next;

        SubscriberNode(Subscriber subscriber) {
            this.subscriber = subscriber;
        }
    }

    @FunctionalInterface
    public static interface Subscriber {
        public void onEvent(YogaNode var1, YogaEventType var2, TypedData var3);
    }

    public static final class NodeAllocationData
    implements TypedData {
        public final YogaConfig config;

        public NodeAllocationData(YogaConfig config) {
            this.config = config;
        }
    }

    public static final class NodeDeallocationData
    implements TypedData {
        public final YogaConfig config;

        public NodeDeallocationData(YogaConfig config) {
            this.config = config;
        }
    }

    public static final class NodeLayoutData
    implements TypedData {
        public final LayoutType layoutType;

        public NodeLayoutData(LayoutType layoutType) {
            this.layoutType = layoutType;
        }
    }

    public static final class LayoutPassEndData
    implements TypedData {
        public final LayoutData layoutData;

        public LayoutPassEndData(LayoutData layoutData) {
            this.layoutData = layoutData;
        }
    }

    public static final class MeasureCallbackEndData
    implements TypedData {
        public final float width;
        public final YogaMeasureMode widthMeasureMode;
        public final float height;
        public final YogaMeasureMode heightMeasureMode;
        public final float measuredWidth;
        public final float measuredHeight;
        public final LayoutPassReason reason;

        public MeasureCallbackEndData(float width, YogaMeasureMode widthMeasureMode, float height, YogaMeasureMode heightMeasureMode, float measuredWidth, float measuredHeight, LayoutPassReason reason) {
            this.width = width;
            this.widthMeasureMode = widthMeasureMode;
            this.height = height;
            this.heightMeasureMode = heightMeasureMode;
            this.measuredWidth = measuredWidth;
            this.measuredHeight = measuredHeight;
            this.reason = reason;
        }
    }

    public static interface TypedData {
    }
}

