/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import io.homo.superresolution.common.minecraft.GpuTextureAdapter;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.graphics.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.opengl.Gl;
import io.homo.superresolution.core.graphics.opengl.GlState;
import io.homo.superresolution.core.graphics.opengl.utils.GlBlitRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameBufferRenderTargetAdapter
extends RenderTarget {
    private IFrameBuffer frameBuffer;

    FrameBufferRenderTargetAdapter(IFrameBuffer frameBuffer) {
        super(frameBuffer.handle() + "-IFrameBuffer-" + frameBuffer.getTextureId(FrameBufferAttachmentType.Color), frameBuffer.getDepthTextureFormat() != null);
        this.frameBuffer = frameBuffer;
        this.updateState();
    }

    protected static FrameBufferRenderTargetAdapter ofRenderTarget(IFrameBuffer frameBuffer) {
        return new FrameBufferRenderTargetAdapter(frameBuffer);
    }

    private void updateState() {
        this.width = this.frameBuffer.getWidth();
        this.height = this.frameBuffer.getHeight();
        this.viewWidth = this.frameBuffer.getWidth();
        this.viewHeight = this.frameBuffer.getHeight();
        this.colorTexture = GpuTextureAdapter.ofTexture(this.frameBuffer.getTexture(FrameBufferAttachmentType.Color));
        ((GpuTextureAdapter)this.colorTexture).bindFramebuffer(this.frameBuffer);
        ITexture texture = this.frameBuffer.getTexture(FrameBufferAttachmentType.DepthStencil);
        if (texture != null) {
            this.depthTexture = GpuTextureAdapter.ofTexture(texture);
        } else {
            texture = this.frameBuffer.getTexture(FrameBufferAttachmentType.Depth);
            if (texture != null) {
                this.depthTexture = GpuTextureAdapter.ofTexture(texture);
            }
        }
        if (this.depthTexture != null) {
            ((GpuTextureAdapter)this.depthTexture).bindFramebuffer(this.frameBuffer);
        }
    }

    public void resize(int i, int j) {
        this.updateState();
    }

    public void destroyBuffers() {
        this.updateState();
    }

    public void copyDepthFrom(@NotNull RenderTarget renderTarget) {
        this.updateState();
        super.copyDepthFrom(renderTarget);
    }

    public void createBuffers(int i, int j) {
        this.updateState();
    }

    public void setFilterMode(FilterMode filterMode) {
        this.updateState();
    }

    private void setFilterMode(FilterMode filterMode, boolean bl) {
        this.updateState();
    }

    public void blitToScreen() {
        this.updateState();
        Gl.DSA.blitFramebuffer((int)this.frameBuffer.handle(), new GlState((long)32L).wFbo, 0, 0, this.frameBuffer.getWidth(), this.frameBuffer.getHeight(), 0, 0, this.frameBuffer.getWidth(), this.frameBuffer.getHeight(), 16384, 9728);
    }

    public void blitAndBlendToTexture(GpuTexture gpuTexture) {
        this.updateState();
        GlBlitRenderer.blitToScreen(this.frameBuffer.getTexture(FrameBufferAttachmentType.Color), this.viewWidth, this.viewHeight);
    }

    @Nullable
    public GpuTexture getColorTexture() {
        this.updateState();
        return this.colorTexture;
    }

    @Nullable
    public GpuTexture getDepthTexture() {
        this.updateState();
        return this.depthTexture;
    }

    public FrameBufferRenderTargetAdapter bindFrameBuffer(IFrameBuffer frameBuffer) {
        this.frameBuffer = frameBuffer;
        return this;
    }
}

