/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import io.homo.superresolution.common.minecraft.MinecraftRenderTargetUtil;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferTextureAdapter;
import io.homo.superresolution.core.graphics.impl.framebuffer.IBindableFrameBuffer;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.opengl.framebuffer.GlFrameBuffer;
import io.homo.superresolution.core.utils.ColorUtil;
import java.util.Objects;
import org.lwjgl.opengl.GL30;

public class MinecraftRenderTargetWrapper
implements IBindableFrameBuffer {
    public RenderTarget renderTarget;
    private int clearColor = ColorUtil.color(255, 0, 0, 0);

    public MinecraftRenderTargetWrapper(RenderTarget renderTarget) {
        this.renderTarget = renderTarget;
    }

    public static MinecraftRenderTargetWrapper of(RenderTarget renderTarget) {
        if (renderTarget == null) {
            return null;
        }
        MinecraftRenderTargetWrapper wrapper = new MinecraftRenderTargetWrapper(renderTarget);
        wrapper.clearColor = ColorUtil.color(255, 0, 0, 0);
        return wrapper;
    }

    @Override
    public void clearFrameBuffer() {
        RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(Objects.requireNonNull(this.renderTarget.getColorTexture()), this.clearColor, Objects.requireNonNull(this.renderTarget.getDepthTexture()), 0.0);
    }

    @Override
    public void resizeFrameBuffer(int width, int height) {
        this.renderTarget.resize(width, height);
    }

    @Override
    public int getWidth() {
        return this.renderTarget.width;
    }

    @Override
    public int getHeight() {
        return this.renderTarget.height;
    }

    @Override
    public void destroy() {
        this.renderTarget.destroyBuffers();
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint, boolean setViewport) {
        GL30.glBindFramebuffer((int)GlFrameBuffer.resolveBindTarget(bindPoint), (int)MinecraftRenderTargetUtil.getFboId(this.renderTarget));
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint) {
        this.bind(bindPoint, true);
    }

    @Override
    public void unbind(FrameBufferBindPoint bindPoint) {
        GL30.glBindFramebuffer((int)GlFrameBuffer.resolveBindTarget(bindPoint), (int)0);
    }

    @Override
    public int getTextureId(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new MatchException(null, null);
            case FrameBufferAttachmentType.Color -> MinecraftRenderTargetUtil.getColorTexId(this.renderTarget);
            case FrameBufferAttachmentType.AnyDepth, FrameBufferAttachmentType.Depth, FrameBufferAttachmentType.DepthStencil -> MinecraftRenderTargetUtil.getDepthTexId(this.renderTarget);
        };
    }

    @Override
    public ITexture getTexture(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new MatchException(null, null);
            case FrameBufferAttachmentType.Color -> FrameBufferTextureAdapter.ofColor(this);
            case FrameBufferAttachmentType.AnyDepth, FrameBufferAttachmentType.Depth, FrameBufferAttachmentType.DepthStencil -> FrameBufferTextureAdapter.ofDepth(this);
        };
    }

    @Override
    public long handle() {
        return MinecraftRenderTargetUtil.getFboId(this.renderTarget);
    }

    @Override
    public void setClearColorRGBA(float red, float green, float blue, float alpha) {
        this.clearColor = ColorUtil.color((int)(alpha * 255.0f), (int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f));
    }

    @Override
    public TextureFormat getColorTextureFormat() {
        return TextureFormat.RGBA8;
    }

    @Override
    public TextureFormat getDepthTextureFormat() {
        return TextureFormat.DEPTH32F;
    }

    @Override
    public RenderTarget asMcRenderTarget() {
        return this.renderTarget;
    }
}

