/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core;

import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.vulkan.VulkanDevice;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VkDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuperResolutionNativeHelper {
    public static final Logger LOGGER_CPP = LoggerFactory.getLogger((String)"SuperResolution-Native");

    public static void CPP_Log(String msg, int level) {
        switch (level) {
            case 2: {
                LOGGER_CPP.info(msg);
                break;
            }
            case 1: {
                LOGGER_CPP.warn(msg);
                break;
            }
            case 0: {
                LOGGER_CPP.error(msg);
                break;
            }
            case 3: {
                LOGGER_CPP.debug(msg);
            }
        }
    }

    public static long CPP_glfwGetProcAddress(String name) {
        return GLFW.glfwGetProcAddress((CharSequence)name);
    }

    public static long CPP_vkGetDeviceProcAddr(String name) {
        if (name.equals("SuperResolution_GetInstance")) {
            return RenderSystems.vulkan().getVulkanInstance().address();
        }
        return VK10.vkGetDeviceProcAddr((VkDevice)((VulkanDevice)RenderSystems.vulkan().device()).getVkDevice(), (CharSequence)name);
    }
}

