/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl.pipeline;

import io.homo.superresolution.core.graphics.impl.buffer.IBuffer;
import io.homo.superresolution.core.graphics.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineClearTextureJob;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineComputeJob;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineCopyBufferJob;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineCopyTextureJob;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineGraphicsJob;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineJobResource;
import io.homo.superresolution.core.graphics.impl.shader.IShaderProgram;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.joml.Vector3i;
import org.joml.Vector4i;

public final class PipelineJobBuilders {
    private PipelineJobBuilders() {
    }

    public static CopyTextureJobBuilder copyTexture() {
        return new CopyTextureJobBuilder();
    }

    public static ClearTextureJobBuilder clearTexture() {
        return new ClearTextureJobBuilder();
    }

    public static ComputeJobBuilder compute(IShaderProgram<?> program) {
        return new ComputeJobBuilder(program);
    }

    public static GraphicsJobBuilder graphics(IShaderProgram<?> program) {
        return new GraphicsJobBuilder(program);
    }

    public static CopyBufferJobBuilder copyBuffer() {
        return new CopyBufferJobBuilder();
    }

    public static class CopyTextureJobBuilder {
        private ITexture source;
        private ITexture destination;
        private Vector4i srcDimensions;
        private Vector4i dstDimensions;

        public CopyTextureJobBuilder from(ITexture source) {
            this.source = source;
            return this;
        }

        public CopyTextureJobBuilder to(ITexture destination) {
            this.destination = destination;
            return this;
        }

        public CopyTextureJobBuilder sourceDimensions(Vector4i src) {
            this.srcDimensions = src;
            return this;
        }

        public CopyTextureJobBuilder destinationDimensions(Vector4i dst) {
            this.dstDimensions = dst;
            return this;
        }

        public PipelineCopyTextureJob build() {
            if (this.source == null || this.destination == null) {
                throw new IllegalStateException("Source and destination textures must be specified.");
            }
            return new PipelineCopyTextureJob(this.source, this.destination, this.srcDimensions, this.dstDimensions);
        }
    }

    public static class ClearTextureJobBuilder {
        private ITexture target;
        private float[] color;
        private Float depth;
        private Integer stencil;

        public ClearTextureJobBuilder target(ITexture texture) {
            this.target = texture;
            return this;
        }

        public ClearTextureJobBuilder color(float r, float g, float b, float a) {
            this.color = new float[]{r, g, b, a};
            return this;
        }

        public ClearTextureJobBuilder depth(float depth) {
            this.depth = Float.valueOf(depth);
            return this;
        }

        public ClearTextureJobBuilder stencil(int stencil) {
            this.stencil = stencil;
            return this;
        }

        public PipelineClearTextureJob build() {
            if (this.target == null) {
                throw new IllegalStateException("Clear target must be specified");
            }
            PipelineClearTextureJob job = new PipelineClearTextureJob();
            job.clearTarget(this.target);
            if (this.color != null) {
                job.clearColor(this.color[0], this.color[1], this.color[2], this.color[3]);
            }
            if (this.depth != null) {
                job.clearDepth(this.depth.floatValue());
            }
            if (this.stencil != null) {
                job.clearStencil(this.stencil);
            }
            return job;
        }
    }

    public static class ComputeJobBuilder
    extends GpuComputeJobBuilder<ComputeJobBuilder> {
        private final IShaderProgram<?> program;
        private Supplier<Vector3i> workGroupSizeSupplier = () -> new Vector3i(1, 1, 1);

        public ComputeJobBuilder(IShaderProgram<?> program) {
            if (program == null) {
                throw new IllegalArgumentException("Compute program cannot be null");
            }
            this.program = program;
        }

        public ComputeJobBuilder workGroup(int x, int y, int z) {
            this.workGroupSizeSupplier = () -> new Vector3i(x, y, z);
            return this;
        }

        public ComputeJobBuilder workGroupSupplier(Supplier<Vector3i> supplier) {
            this.workGroupSizeSupplier = supplier;
            return this;
        }

        public PipelineComputeJob build() {
            PipelineComputeJob job = new PipelineComputeJob();
            job.computeProgram(this.program);
            job.workGroupSizeSupplier(this.workGroupSizeSupplier);
            job.resources.putAll(this.resources);
            return job;
        }
    }

    public static class GraphicsJobBuilder
    extends GpuComputeJobBuilder<GraphicsJobBuilder> {
        private final IShaderProgram<?> program;
        private IFrameBuffer targetFbo;
        private float[] viewport = null;

        public GraphicsJobBuilder(IShaderProgram<?> program) {
            if (program == null) {
                throw new IllegalArgumentException("Graphics program cannot be null");
            }
            this.program = program;
        }

        public GraphicsJobBuilder targetFramebuffer(IFrameBuffer fbo) {
            this.targetFbo = fbo;
            return this;
        }

        public GraphicsJobBuilder viewport(float x, float y, float w, float h) {
            this.viewport = new float[]{x, y, w, h};
            return this;
        }

        public PipelineGraphicsJob build() {
            PipelineGraphicsJob job = new PipelineGraphicsJob();
            job.graphicsProgram(this.program);
            if (this.targetFbo != null) {
                job.targetFrameBuffer(this.targetFbo);
            }
            if (this.viewport != null) {
                job.viewport(this.viewport[0], this.viewport[1], this.viewport[2], this.viewport[3]);
            } else if (this.targetFbo != null) {
                job.viewport(0.0f, 0.0f, this.targetFbo.getWidth(), this.targetFbo.getHeight());
            }
            job.resources.putAll(this.resources);
            return job;
        }
    }

    public static class CopyBufferJobBuilder {
        private IBuffer source;
        private IBuffer destination;
        private long srcOffset = -1L;
        private long dstOffset = -1L;
        private long size = -1L;

        public CopyBufferJobBuilder from(IBuffer source) {
            this.source = source;
            return this;
        }

        public CopyBufferJobBuilder to(IBuffer destination) {
            this.destination = destination;
            return this;
        }

        public CopyBufferJobBuilder region(long srcOffset, long dstOffset, long size) {
            this.srcOffset = srcOffset;
            this.dstOffset = dstOffset;
            this.size = size;
            return this;
        }

        public PipelineCopyBufferJob build() {
            return new PipelineCopyBufferJob(this.source, this.destination, this.srcOffset, this.dstOffset, this.size);
        }
    }

    public static abstract class GpuComputeJobBuilder<SELF> {
        protected Map<String, PipelineJobResource<?>> resources = new HashMap();

        public SELF resource(String key, PipelineJobResource<?> resource) {
            this.resources.put(key, resource);
            return (SELF)this;
        }
    }
}

