/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.opengl.command;

import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.impl.DrawObject;
import io.homo.superresolution.core.graphics.impl.GpuObject;
import io.homo.superresolution.core.graphics.impl.buffer.IBuffer;
import io.homo.superresolution.core.graphics.impl.command.ICommandBuffer;
import io.homo.superresolution.core.graphics.impl.command.ICommandDecoder;
import io.homo.superresolution.core.graphics.impl.command.commands.DrawCommand;
import io.homo.superresolution.core.graphics.impl.device.IDevice;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.graphics.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.graphics.impl.shader.IShaderProgram;
import io.homo.superresolution.core.graphics.impl.shader.uniform.ShaderUniformAccess;
import io.homo.superresolution.core.graphics.impl.shader.uniform.ShaderUniformType;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.vertex.PrimitiveType;
import io.homo.superresolution.core.graphics.opengl.Gl;
import io.homo.superresolution.core.graphics.opengl.GlDebug;
import io.homo.superresolution.core.graphics.opengl.GlDevice;
import io.homo.superresolution.core.graphics.opengl.GlState;
import io.homo.superresolution.core.graphics.opengl.OpenGLException;
import io.homo.superresolution.core.graphics.opengl.command.GlCommandBuffer;
import io.homo.superresolution.core.graphics.opengl.command.GlCommandEncoder;
import io.homo.superresolution.core.graphics.opengl.framebuffer.GlFrameBuffer;
import io.homo.superresolution.core.graphics.opengl.shader.GlShaderProgram;
import io.homo.superresolution.core.graphics.opengl.shader.uniform.GlShaderBaseUniform;
import io.homo.superresolution.core.graphics.opengl.shader.uniform.GlShaderUniformBuffer;
import io.homo.superresolution.core.graphics.opengl.shader.uniform.GlShaderUniformSamplerTexture;
import io.homo.superresolution.core.graphics.opengl.shader.uniform.GlShaderUniformStorageTexture;
import io.homo.superresolution.core.graphics.system.IRenderState;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GL44;

public class GlCommandDecoder
implements ICommandDecoder {
    private final GlDevice device;
    private final GlCommandEncoder commandEncoder;

    public GlCommandDecoder(GlDevice device, GlCommandEncoder commandEncoder) {
        this.device = device;
        this.commandEncoder = commandEncoder;
    }

    private void putGlCommand(ICommandBuffer commandBuffer, Runnable glCalls) {
        if (!(commandBuffer instanceof GlCommandBuffer)) {
            throw new IllegalArgumentException();
        }
        ((GlCommandBuffer)commandBuffer)._addGlCalls(glCalls);
    }

    @Override
    public void clearTextureRGBA(ICommandBuffer commandBuffer, ITexture texture, float[] color) {
        if (texture == null) {
            throw new OpenGLException("clearTextureRGBA: \u8f93\u5165\u7684\u7eb9\u7406\u5bf9\u8c61\u4e3anull");
        }
        int debugId = GlDebug.nextClearId();
        String debugName = "clearTextureRGBA: " + String.valueOf((Object)texture.getTextureFormat());
        if (RenderSystems.opengl().supportsARBClearTexture) {
            TextureFormat format = texture.getTextureFormat();
            if (format.isInteger()) {
                int[] intColor = new int[color.length];
                for (int i = 0; i < color.length; ++i) {
                    intColor[i] = (int)(color[i] * 255.0f);
                }
                this.putGlCommand(commandBuffer, () -> {
                    GlDebug.pushGroup(debugId, debugName);
                    try {
                        GL44.glClearTexImage((int)((int)texture.handle()), (int)0, (int)format.gl(), (int)5125, (int[])intColor);
                    }
                    finally {
                        GlDebug.popGroup();
                    }
                });
            } else {
                this.putGlCommand(commandBuffer, () -> {
                    GlDebug.pushGroup(debugId, debugName);
                    try {
                        GL44.glClearTexImage((int)((int)texture.handle()), (int)0, (int)format.gl(), (int)5126, (float[])color);
                    }
                    finally {
                        GlDebug.popGroup();
                    }
                });
            }
        } else {
            this.putGlCommand(commandBuffer, () -> {
                GlDebug.pushGroup(debugId, debugName);
                try (GlState state = new GlState(66080L);){
                    int fbo = GL43.glGenFramebuffers();
                    GL43.glBindFramebuffer((int)36009, (int)fbo);
                    GL43.glFramebufferTexture2D((int)36009, (int)36064, (int)3553, (int)((int)texture.handle()), (int)0);
                    int status = GL43.glCheckFramebufferStatus((int)36009);
                    if (status != 36053) {
                        GL43.glDeleteFramebuffers((int)fbo);
                        throw new OpenGLException("clearTextureRGBA: FBO\u72b6\u6001\u4e0d\u5b8c\u6574, \u72b6\u6001\u7801: " + status);
                    }
                    GL43.glViewport((int)0, (int)0, (int)texture.getWidth(), (int)texture.getHeight());
                    GL43.glEnable((int)3089);
                    GL43.glScissor((int)0, (int)0, (int)texture.getWidth(), (int)texture.getHeight());
                    GL43.glClearColor((float)color[0], (float)color[1], (float)color[2], (float)color[3]);
                    GL43.glClear((int)16384);
                    GL43.glBindFramebuffer((int)36009, (int)0);
                    GL43.glDeleteFramebuffers((int)fbo);
                }
                finally {
                    GlDebug.popGroup();
                }
            });
        }
    }

    @Override
    public void clearTextureDepth(ICommandBuffer commandBuffer, ITexture texture, float depth) {
        if (texture == null) {
            throw new OpenGLException("clearTextureDepth: \u8f93\u5165\u7684\u7eb9\u7406\u5bf9\u8c61\u4e3anull");
        }
        int debugId = GlDebug.nextClearId();
        String debugName = "clearTextureDepth";
        if (RenderSystems.opengl().supportsARBClearTexture) {
            this.putGlCommand(commandBuffer, () -> {
                GlDebug.pushGroup(debugId, "clearTextureDepth");
                try {
                    float[] clearDepth = new float[]{depth};
                    GL44.glClearTexImage((int)((int)texture.handle()), (int)0, (int)6402, (int)5126, (float[])clearDepth);
                }
                finally {
                    GlDebug.popGroup();
                }
            });
        } else {
            this.putGlCommand(commandBuffer, () -> {
                GlDebug.pushGroup(debugId, "clearTextureDepth");
                try (GlState state = new GlState(66080L);){
                    int fbo = GL43.glGenFramebuffers();
                    GL43.glBindFramebuffer((int)36009, (int)fbo);
                    GL43.glFramebufferTexture2D((int)36009, (int)36096, (int)3553, (int)((int)texture.handle()), (int)0);
                    int status = GL43.glCheckFramebufferStatus((int)36009);
                    if (status != 36053) {
                        GL43.glDeleteFramebuffers((int)fbo);
                        throw new OpenGLException("clearTextureDepth: FBO\u72b6\u6001\u4e0d\u5b8c\u6574, \u72b6\u6001\u7801: " + status);
                    }
                    GL43.glViewport((int)0, (int)0, (int)texture.getWidth(), (int)texture.getHeight());
                    GL43.glEnable((int)3089);
                    GL43.glScissor((int)0, (int)0, (int)texture.getWidth(), (int)texture.getHeight());
                    GL43.glClearDepth((double)depth);
                    GL43.glClear((int)256);
                    GL43.glBindFramebuffer((int)36009, (int)0);
                    GL43.glDeleteFramebuffers((int)fbo);
                }
                finally {
                    GlDebug.popGroup();
                }
            });
        }
    }

    @Override
    public void clearTextureStencil(ICommandBuffer commandBuffer, ITexture texture, int stencil) {
        if (texture == null) {
            throw new OpenGLException("clearTextureStencil: \u8f93\u5165\u7684\u7eb9\u7406\u5bf9\u8c61\u4e3anull");
        }
        int debugId = GlDebug.nextClearId();
        String debugName = "clearTextureStencil";
        if (RenderSystems.opengl().supportsARBClearTexture) {
            this.putGlCommand(commandBuffer, () -> {
                GlDebug.pushGroup(debugId, "clearTextureStencil");
                try {
                    int[] clearStencil = new int[]{stencil};
                    GL44.glClearTexImage((int)((int)texture.handle()), (int)0, (int)6401, (int)5125, (int[])clearStencil);
                }
                finally {
                    GlDebug.popGroup();
                }
            });
        } else {
            this.putGlCommand(commandBuffer, () -> {
                GlDebug.pushGroup(debugId, "clearTextureStencil");
                try (GlState state = new GlState(66080L);){
                    int fbo = GL43.glGenFramebuffers();
                    GL43.glBindFramebuffer((int)36009, (int)fbo);
                    GL43.glFramebufferTexture2D((int)36009, (int)36128, (int)3553, (int)((int)texture.handle()), (int)0);
                    int status = GL43.glCheckFramebufferStatus((int)36009);
                    if (status != 36053) {
                        GL43.glDeleteFramebuffers((int)fbo);
                        throw new OpenGLException("clearTextureStencil: FBO\u72b6\u6001\u4e0d\u5b8c\u6574, \u72b6\u6001\u7801: " + status);
                    }
                    GL43.glViewport((int)0, (int)0, (int)texture.getWidth(), (int)texture.getHeight());
                    GL43.glEnable((int)3089);
                    GL43.glScissor((int)0, (int)0, (int)texture.getWidth(), (int)texture.getHeight());
                    GL43.glClearStencil((int)stencil);
                    GL43.glClear((int)1024);
                    GL43.glBindFramebuffer((int)36009, (int)0);
                    GL43.glDeleteFramebuffers((int)fbo);
                }
                finally {
                    GlDebug.popGroup();
                }
            });
        }
    }

    @Override
    public void copyTexture(ICommandBuffer commandBuffer, ITexture src, ITexture dst, int srcX0, int srcY0, int srcX1, int srcY1, int srcLevel, int dstX0, int dstY0, int dstX1, int dstY1, int dstLevel) {
        if (src == null || dst == null) {
            throw new OpenGLException("copyTexture: \u6e90\u6216\u76ee\u6807\u7eb9\u7406\u4e3anull");
        }
        if (src.getTextureFormat() != dst.getTextureFormat()) {
            throw new OpenGLException("copyTexture: \u6e90\u548c\u76ee\u6807\u7eb9\u7406\u683c\u5f0f\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u62f7\u8d1d\uff1a" + String.valueOf((Object)src.getTextureFormat()) + " -> " + String.valueOf((Object)dst.getTextureFormat()));
        }
        if (src.getTextureType() != dst.getTextureType()) {
            throw new OpenGLException("copyTexture: \u6e90\u548c\u76ee\u6807\u7eb9\u7406\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u62f7\u8d1d\uff1a" + String.valueOf((Object)src.getTextureType()) + " -> " + String.valueOf((Object)dst.getTextureType()));
        }
        int debugId = GlDebug.nextCopyId();
        String debugName = String.format("copyTexture: %s -> %s", new Object[]{src.getTextureFormat(), dst.getTextureFormat()});
        switch (src.getTextureType()) {
            case Texture1D: {
                this.putGlCommand(commandBuffer, () -> {
                    GlDebug.pushGroup(debugId, debugName);
                    try {
                        GL43.glCopyImageSubData((int)((int)src.handle()), (int)3552, (int)srcLevel, (int)srcX0, (int)0, (int)0, (int)((int)dst.handle()), (int)3552, (int)dstLevel, (int)dstX0, (int)0, (int)0, (int)(srcX1 - srcX0), (int)1, (int)1);
                    }
                    finally {
                        GlDebug.popGroup();
                    }
                });
                break;
            }
            case Texture2D: {
                this.putGlCommand(commandBuffer, () -> {
                    GlDebug.pushGroup(debugId, debugName);
                    try {
                        GL43.glCopyImageSubData((int)((int)src.handle()), (int)3553, (int)srcLevel, (int)srcX0, (int)srcY0, (int)0, (int)((int)dst.handle()), (int)3553, (int)dstLevel, (int)dstX0, (int)dstY0, (int)0, (int)(srcX1 - srcX0), (int)(srcY1 - srcY0), (int)1);
                    }
                    finally {
                        GlDebug.popGroup();
                    }
                });
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported texture type: " + String.valueOf((Object)src.getTextureType()));
            }
        }
    }

    @Override
    public void copyBuffer(ICommandBuffer commandBuffer, IBuffer src, IBuffer dst, long srcOffset, long dstOffset, long size) {
        int debugId = GlDebug.nextCopyId();
        String debugName = String.format("copyBuffer: %d bytes", size);
        this.putGlCommand(commandBuffer, () -> {
            GlDebug.pushGroup(debugId, debugName);
            try {
                GL43.glCopyBufferSubData((int)((int)src.handle()), (int)((int)dst.handle()), (long)srcOffset, (long)dstOffset, (long)size);
            }
            finally {
                GlDebug.popGroup();
            }
        });
    }

    @Override
    public void decodeDraw(ICommandBuffer commandBuffer, DrawCommand command) {
        IRenderState.StateSnapshot stateSnapshot = this.commandEncoder.renderState().get();
        ICommandDecoder.super.decodeDraw(commandBuffer, command);
        this.commandEncoder.renderState().apply(stateSnapshot);
    }

    @Override
    public void draw(ICommandBuffer commandBuffer, IShaderProgram<?> shaderProgram, IFrameBuffer frameBuffer, DrawObject drawObject, int firstVertex, int vertexCount) {
        if (shaderProgram == null) {
            throw new OpenGLException("draw: \u7740\u8272\u5668\u7a0b\u5e8f\u4e3anull");
        }
        int debugId = GlDebug.nextDrawId();
        String debugName = String.format("draw: %s (%d verts)", new Object[]{drawObject.getPrimitiveType(), vertexCount});
        List<ResourcesBindingSnapshot> resourcesSnapshot = this.createResourcesBindingSnapshot((GlShaderProgram)shaderProgram);
        this.putGlCommand(commandBuffer, () -> {
            GlDebug.pushGroup(debugId, debugName);
            try (GlState ig = new GlState(25166241L);){
                if (frameBuffer != null) {
                    if (frameBuffer instanceof GlFrameBuffer) {
                        ((GlFrameBuffer)frameBuffer).bind(FrameBufferBindPoint.All, true);
                    } else {
                        throw new OpenGLException("draw: \u76ee\u6807\u5e27\u7f13\u51b2\u533a\u4e0d\u662f\u7531OpenGL\u521b\u5efa\u7684");
                    }
                }
                this.setupShaderProgram(shaderProgram, resourcesSnapshot);
                GL43.glBindBuffer((int)34962, (int)((int)drawObject.getVertexBuffer().handle()));
                GL43.glBindVertexArray((int)((int)drawObject.getVertexArray().handle()));
                int glPrimitive = switch (drawObject.getPrimitiveType()) {
                    default -> throw new MatchException(null, null);
                    case PrimitiveType.Triangle -> 4;
                    case PrimitiveType.TriangleStrip -> 5;
                    case PrimitiveType.Lines -> 1;
                    case PrimitiveType.Points -> 0;
                };
                GL43.glDrawArrays((int)glPrimitive, (int)firstVertex, (int)vertexCount);
                if (drawObject.isOnce()) {
                    drawObject.destroy();
                }
            }
            finally {
                GlDebug.popGroup();
            }
        });
    }

    private List<ResourcesBindingSnapshot> createResourcesBindingSnapshot(GlShaderProgram shaderProgram) {
        ArrayList<ResourcesBindingSnapshot> resourcesBindingSnapshot = new ArrayList<ResourcesBindingSnapshot>();
        Map<String, GlShaderBaseUniform<?, ?>> uniformMap = shaderProgram.uniforms().getUniformMap();
        uniformMap.forEach((name, uniform) -> {
            if (uniform instanceof GlShaderUniformBuffer) {
                if (((GlShaderUniformBuffer)uniform).buffer() != null) {
                    resourcesBindingSnapshot.add(new ResourcesBindingSnapshot(uniform.name(), uniform.binding(), uniform.type(), uniform.access(), ((GlShaderUniformBuffer)uniform).buffer()));
                }
            } else if (uniform instanceof GlShaderUniformStorageTexture) {
                if (((GlShaderUniformStorageTexture)uniform).texture() != null) {
                    resourcesBindingSnapshot.add(new ResourcesBindingSnapshot(uniform.name(), uniform.binding(), uniform.type(), uniform.access(), ((GlShaderUniformStorageTexture)uniform).texture()));
                }
            } else if (uniform instanceof GlShaderUniformSamplerTexture && ((GlShaderUniformSamplerTexture)uniform).texture() != null) {
                resourcesBindingSnapshot.add(new ResourcesBindingSnapshot(uniform.name(), uniform.binding(), uniform.type(), uniform.access(), ((GlShaderUniformSamplerTexture)uniform).texture()));
            }
        });
        return resourcesBindingSnapshot;
    }

    private void setupShaderProgram(IShaderProgram<?> shaderProgram, List<ResourcesBindingSnapshot> resourcesBindingSnapshots) {
        GL43.glUseProgram((int)((int)shaderProgram.handle()));
        resourcesBindingSnapshots.forEach(uniform -> {
            switch (uniform.resourcesType()) {
                case UniformBuffer: {
                    if (Gl.isLegacy()) {
                        int blockIndex = GL43.glGetUniformBlockIndex((int)((int)shaderProgram.handle()), (CharSequence)uniform.name());
                        if (blockIndex == -1) {
                            throw new RuntimeException("Uniform block '%s' not found".formatted(uniform.name()));
                        }
                        GL43.glUniformBlockBinding((int)((int)shaderProgram.handle()), (int)blockIndex, (int)uniform.binding());
                        GL43.glBindBufferBase((int)35345, (int)uniform.binding(), (int)((int)uniform.object().handle()));
                        break;
                    }
                    Gl.DSA.bindBufferBase(35345, uniform.binding(), (int)uniform.object().handle());
                    break;
                }
                case StorageTexture: {
                    int n = uniform.binding();
                    int n2 = (int)uniform.object().handle();
                    Gl.DSA.bindImageTexture(n, n2, 0, false, 0, switch (uniform.access()) {
                        default -> throw new MatchException(null, null);
                        case ShaderUniformAccess.Read -> 35000;
                        case ShaderUniformAccess.Write -> 35001;
                        case ShaderUniformAccess.Both -> 35002;
                    }, ((ITexture)uniform.object()).getTextureFormat().gl());
                    break;
                }
                case SamplerTexture: {
                    ITexture texture = (ITexture)uniform.object();
                    GL43.glActiveTexture((int)(33984 + uniform.binding()));
                    if (texture.getTextureType() == TextureType.Texture1D) {
                        GL43.glBindTexture((int)3552, (int)((int)texture.handle()));
                    } else if (texture.getTextureType() == TextureType.Texture2D) {
                        GL43.glBindTexture((int)3553, (int)((int)texture.handle()));
                    } else {
                        GL43.glBindTexture((int)3553, (int)((int)texture.handle()));
                    }
                    GL43.glUniform1i((int)GL43.glGetUniformLocation((int)((int)shaderProgram.handle()), (CharSequence)uniform.name()), (int)uniform.binding());
                }
            }
        });
    }

    @Override
    public void dispatchCompute(ICommandBuffer commandBuffer, IShaderProgram<?> shaderProgram, int x, int y, int z) {
        if (shaderProgram == null) {
            throw new OpenGLException("dispatchCompute: \u7740\u8272\u5668\u7a0b\u5e8f\u4e3anull");
        }
        int debugId = GlDebug.nextComputeId();
        String debugName = String.format("dispatchCompute: %dx%dx%d", x, y, z);
        List<ResourcesBindingSnapshot> resourcesSnapshot = this.createResourcesBindingSnapshot((GlShaderProgram)shaderProgram);
        this.putGlCommand(commandBuffer, () -> {
            GlDebug.pushGroup(debugId, debugName);
            this.setupShaderProgram(shaderProgram, resourcesSnapshot);
            GL43.glDispatchCompute((int)x, (int)y, (int)z);
            GL43.glMemoryBarrier((int)8192);
            GlDebug.popGroup();
        });
    }

    @Override
    public void applyRenderState(ICommandBuffer commandBuffer, IRenderState.StateSnapshot stateSnapshot) {
        int debugId = GlDebug.nextStateId();
        String debugName = "applyRenderState";
        this.putGlCommand(commandBuffer, () -> {
            GlDebug.pushGroup(debugId, "applyRenderState");
            this.commandEncoder.renderState().apply(stateSnapshot);
            GlDebug.popGroup();
        });
    }

    @Override
    public IDevice getDevice() {
        return this.device;
    }

    private record ResourcesBindingSnapshot(String name, int binding, ShaderUniformType resourcesType, ShaderUniformAccess access, GpuObject object) {
    }
}

