/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.vulkan.texture;

import io.homo.superresolution.api.platform.OperatingSystemType;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureDescription;
import io.homo.superresolution.core.graphics.impl.texture.TextureFilterMode;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.impl.texture.TextureMipmapSettings;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsage;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsages;
import io.homo.superresolution.core.graphics.impl.texture.TextureWrapMode;
import io.homo.superresolution.core.graphics.vulkan.VulkanDevice;
import io.homo.superresolution.core.graphics.vulkan.VulkanInterop;
import io.homo.superresolution.core.graphics.vulkan.utils.VulkanException;
import io.homo.superresolution.core.graphics.vulkan.utils.VulkanUtils;
import java.nio.LongBuffer;
import java.util.Set;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.vulkan.VK11;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkExternalMemoryImageCreateInfo;
import org.lwjgl.vulkan.VkImageCreateInfo;
import org.lwjgl.vulkan.VkImageViewCreateInfo;
import org.lwjgl.vulkan.VkMemoryAllocateInfo;
import org.lwjgl.vulkan.VkMemoryRequirements;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkPhysicalDeviceMemoryProperties;

public class VulkanTexture
implements ITexture {
    private final VulkanDevice device;
    private final TextureDescription description;
    private final boolean isExternal;
    private final long memoryHandle;
    private final boolean exportable;
    private long exportedHandle = -1L;
    private long image;
    private long imageMemory;
    private long imageView;
    private int width;
    private int height;
    private long memorySize;

    public long getMemorySize() {
        return this.memorySize;
    }

    public VulkanTexture(VulkanDevice device, TextureDescription description) {
        this(device, description, false, -1L, false);
    }

    @Override
    public TextureMipmapSettings getMipmapSettings() {
        return this.description.getMipmapSettings();
    }

    public VulkanTexture(VulkanDevice device, TextureDescription description, long memoryHandle) {
        this(device, description, true, memoryHandle, false);
    }

    public VulkanDevice getDevice() {
        return this.device;
    }

    public VulkanTexture(VulkanDevice device, TextureDescription description, boolean isExternal, long memoryHandle, boolean exportable) {
        this.device = device;
        this.description = description;
        this.width = description.getWidth();
        this.height = description.getHeight();
        this.isExternal = isExternal;
        this.memoryHandle = memoryHandle;
        this.exportable = exportable;
        try (MemoryStack stack = MemoryStack.stackPush();){
            this.createImage(stack);
            if (isExternal) {
                this.importMemoryFromHandle(stack);
            } else {
                this.allocateMemory(stack);
                if (exportable) {
                    this.exportMemoryHandle(stack);
                }
            }
            this.createImageView(stack);
        }
    }

    private void exportMemoryHandle(MemoryStack stack) {
        this.exportedHandle = VulkanInterop.IMPL.vkGetMemoryHandle(stack, this.device.getVkDevice(), this.imageMemory);
    }

    private void createImage(MemoryStack stack) {
        VkImageCreateInfo imageInfo = VkImageCreateInfo.calloc((MemoryStack)stack);
        imageInfo.sType(14);
        imageInfo.imageType(1);
        imageInfo.extent().width(this.width);
        imageInfo.extent().height(this.height);
        imageInfo.extent().depth(1);
        imageInfo.mipLevels(this.description.getMipmapSettings().getLevels());
        imageInfo.arrayLayers(1);
        imageInfo.format(this.description.getFormat().vk());
        imageInfo.tiling(0);
        imageInfo.initialLayout(0);
        imageInfo.usage(this.translateUsages(Set.copyOf(this.description.getUsages().getUsages())));
        imageInfo.sharingMode(0);
        imageInfo.samples(1);
        if (this.isExternal || this.exportable) {
            VkExternalMemoryImageCreateInfo extInfo = OperatingSystemType.isCurrentOS(OperatingSystemType.WINDOWS) ? VkExternalMemoryImageCreateInfo.calloc((MemoryStack)stack).sType(1000072001).handleTypes(2) : VkExternalMemoryImageCreateInfo.calloc((MemoryStack)stack).sType(1000072001).handleTypes(1);
            imageInfo.pNext(extInfo);
        }
        LongBuffer pImage = stack.mallocLong(1);
        VulkanUtils.VK_CHECK(VK11.vkCreateImage((VkDevice)this.device.getVkDevice(), (VkImageCreateInfo)imageInfo, null, (LongBuffer)pImage), "Failed to create image");
        this.image = pImage.get(0);
    }

    private int translateUsages(Set<TextureUsage> usages) {
        int flags = 0;
        for (TextureUsage usage : usages) {
            switch (usage) {
                case Sampler: {
                    flags |= 4;
                    break;
                }
                case Storage: {
                    flags |= 8;
                    break;
                }
                case AttachmentColor: {
                    flags |= 0x10;
                    break;
                }
                case AttachmentDepth: {
                    flags |= 0x20;
                    break;
                }
                case TransferSource: {
                    flags |= 1;
                    break;
                }
                case TransferDestination: {
                    flags |= 2;
                }
            }
        }
        return flags;
    }

    private void allocateMemory(MemoryStack stack) {
        VkMemoryRequirements memRequirements = VkMemoryRequirements.calloc((MemoryStack)stack);
        VK11.vkGetImageMemoryRequirements((VkDevice)this.device.getVkDevice(), (long)this.image, (VkMemoryRequirements)memRequirements);
        this.memorySize = memRequirements.size();
        VkMemoryAllocateInfo allocInfo = VkMemoryAllocateInfo.calloc((MemoryStack)stack).sType(5).allocationSize(this.memorySize).memoryTypeIndex(this.findMemoryType(memRequirements.memoryTypeBits(), 1));
        if (this.exportable) {
            allocInfo.pNext(VulkanInterop.IMPL.createVkExportMemoryAllocateInfo(stack).address());
        }
        LongBuffer pMemory = stack.mallocLong(1);
        VulkanUtils.VK_CHECK(VK11.vkAllocateMemory((VkDevice)this.device.getVkDevice(), (VkMemoryAllocateInfo)allocInfo, null, (LongBuffer)pMemory), "Failed to allocate image memory");
        this.imageMemory = pMemory.get(0);
        VK11.vkBindImageMemory((VkDevice)this.device.getVkDevice(), (long)this.image, (long)this.imageMemory, (long)0L);
    }

    private void importMemoryFromHandle(MemoryStack stack) {
        VkMemoryRequirements memRequirements = VkMemoryRequirements.calloc((MemoryStack)stack);
        VK11.vkGetImageMemoryRequirements((VkDevice)this.device.getVkDevice(), (long)this.image, (VkMemoryRequirements)memRequirements);
        VkMemoryAllocateInfo allocInfo = VkMemoryAllocateInfo.calloc((MemoryStack)stack).sType(5).pNext(VulkanInterop.IMPL.createVkImportMemoryInfo(stack, this.memoryHandle).address()).allocationSize(memRequirements.size()).memoryTypeIndex(this.findMemoryType(memRequirements.memoryTypeBits(), 1));
        LongBuffer pMemory = stack.mallocLong(1);
        VulkanUtils.VK_CHECK(VK11.vkAllocateMemory((VkDevice)this.device.getVkDevice(), (VkMemoryAllocateInfo)allocInfo, null, (LongBuffer)pMemory), "Failed to import external memory");
        this.imageMemory = pMemory.get(0);
        VulkanUtils.VK_CHECK(VK11.vkBindImageMemory((VkDevice)this.device.getVkDevice(), (long)this.image, (long)this.imageMemory, (long)0L), "Failed to bind imported memory to image");
    }

    private int findMemoryType(int typeFilter, int properties) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkPhysicalDeviceMemoryProperties memProperties = VkPhysicalDeviceMemoryProperties.calloc((MemoryStack)stack);
            VK11.vkGetPhysicalDeviceMemoryProperties((VkPhysicalDevice)this.device.getPhysicalDevice(), (VkPhysicalDeviceMemoryProperties)memProperties);
            for (int i = 0; i < memProperties.memoryTypeCount(); ++i) {
                if ((typeFilter & 1 << i) == 0 || (memProperties.memoryTypes(i).propertyFlags() & properties) != properties) continue;
                int n = i;
                return n;
            }
        }
        throw new VulkanException("Failed to find suitable memory type");
    }

    private void createImageView(MemoryStack stack) {
        VkImageViewCreateInfo viewInfo = VkImageViewCreateInfo.calloc((MemoryStack)stack);
        viewInfo.sType(15);
        viewInfo.image(this.image);
        viewInfo.viewType(1);
        viewInfo.format(this.description.getFormat().vk());
        viewInfo.components().r(0).g(0).b(0).a(0);
        viewInfo.subresourceRange().aspectMask(this.getAspectMask()).baseMipLevel(0).levelCount(this.description.getMipmapSettings().getLevels()).baseArrayLayer(0).layerCount(1);
        LongBuffer pImageView = stack.mallocLong(1);
        VulkanUtils.VK_CHECK(VK11.vkCreateImageView((VkDevice)this.device.getVkDevice(), (VkImageViewCreateInfo)viewInfo, null, (LongBuffer)pImageView), "Failed to create image view");
        this.imageView = pImageView.get(0);
    }

    private int getAspectMask() {
        if (this.description.getFormat().isDepthStencil()) {
            return 6;
        }
        if (this.description.getFormat().isDepth()) {
            return 2;
        }
        return 1;
    }

    @Override
    public TextureFormat getTextureFormat() {
        return this.description.getFormat();
    }

    @Override
    public TextureUsages getTextureUsages() {
        return this.description.getUsages();
    }

    @Override
    public TextureType getTextureType() {
        return this.description.getType();
    }

    @Override
    public TextureFilterMode getTextureFilterMode() {
        return this.description.getFilterMode();
    }

    @Override
    public TextureWrapMode getTextureWrapMode() {
        return this.description.getWrapMode();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void destroy() {
        if (this.imageView != 0L) {
            VK11.vkDestroyImageView((VkDevice)this.device.getVkDevice(), (long)this.imageView, null);
            this.imageView = 0L;
        }
        if (this.image != 0L) {
            VK11.vkDestroyImage((VkDevice)this.device.getVkDevice(), (long)this.image, null);
            this.image = 0L;
        }
        if (this.imageMemory != 0L) {
            VK11.vkFreeMemory((VkDevice)this.device.getVkDevice(), (long)this.imageMemory, null);
            this.imageMemory = 0L;
        }
    }

    public long getExportedMemoryHandle() {
        if (!this.exportable) {
            throw new VulkanException("Texture is not exportable");
        }
        if (this.exportedHandle == -1L) {
            throw new VulkanException("Memory handle not exported");
        }
        return this.exportedHandle;
    }

    @Override
    public void resize(int newWidth, int newHeight) {
        if (newWidth == this.width && newHeight == this.height) {
            return;
        }
        this.destroy();
        this.width = newWidth;
        this.height = newHeight;
        try (MemoryStack stack = MemoryStack.stackPush();){
            this.createImage(stack);
            if (this.isExternal) {
                throw new VulkanException("Cannot resize external memory texture");
            }
            this.allocateMemory(stack);
            this.createImageView(stack);
        }
    }

    @Override
    public long handle() {
        return this.image;
    }

    public long getImageView() {
        return this.imageView;
    }

    public long getImageMemory() {
        return this.imageMemory;
    }

    public long getMemoryHandle() {
        if (this.isExternal) {
            return this.memoryHandle;
        }
        throw new VulkanException("Texture does not have external memory");
    }

    @Override
    public TextureDescription getTextureDescription() {
        return this.description;
    }
}

